/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class JavaGradleProjectResolver
extends AbstractProjectResolverExtension {
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        String projectDirPath = this.resolverCtx.getProjectPath();
        IdeaProject ideaProject = this.resolverCtx.getModels().getIdeaProject();
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, projectDirPath + "/build/classes");
        javaProjectData.setJdkVersion(ideaProject.getJdkName());
        LanguageLevel resolvedLanguageLevel = null;
        String languageLevel = ideaProject.getLanguageLevel().getLevel();
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!level.name().equals(languageLevel)) continue;
            resolvedLanguageLevel = level;
            break;
        }
        if (resolvedLanguageLevel != null) {
            javaProjectData.setLanguageLevel(resolvedLanguageLevel);
        } else {
            javaProjectData.setLanguageLevel(languageLevel);
        }
        ideProject.createChild(JavaProjectData.KEY, (Object)javaProjectData);
        this.nextResolver.populateProjectExtraModels(gradleProject, ideProject);
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        BuildScriptClasspathModel buildScriptClasspathModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        List classpathEntries = buildScriptClasspathModel != null ? ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), model -> new BuildScriptClasspathData.ClasspathEntry(model.getClasses(), model.getSources(), model.getJavadoc())) : ContainerUtil.emptyList();
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(buildScriptClasspathModel != null ? buildScriptClasspathModel.getGradleHomeDir() : null);
        ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        ExternalSystemException friendlyError = new JavaProjectImportErrorHandler().getUserFriendlyError(error, projectPath, buildFilePath);
        if (friendlyError != null) {
            return friendlyError;
        }
        return super.getUserFriendlyError(error, projectPath, buildFilePath);
    }

    private static class JavaProjectImportErrorHandler
    extends AbstractProjectImportErrorHandler {
        private JavaProjectImportErrorHandler() {
        }

        @Nullable
        public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
            String rootCauseText;
            GradleExecutionErrorHandler executionErrorHandler = new GradleExecutionErrorHandler(error, projectPath, buildFilePath);
            ExternalSystemException friendlyError = executionErrorHandler.getUserFriendlyError();
            if (friendlyError != null) {
                return friendlyError;
            }
            Throwable rootCause = executionErrorHandler.getRootCause();
            String location = executionErrorHandler.getLocation();
            if (location == null && !StringUtil.isEmpty((String)buildFilePath)) {
                location = String.format("Build file: '%1$s'", buildFilePath);
            }
            if (StringUtil.startsWith((CharSequence)(rootCauseText = rootCause.toString()), (CharSequence)"org.gradle.api.internal.MissingMethodException")) {
                String method = this.parseMissingMethod(rootCauseText);
                String msg = "Build script error, unsupported Gradle DSL method found: '" + method + "'!";
                msg = msg + "\n\nPossible causes could be:  ";
                msg = msg + String.format("%s  - you are using Gradle version where the method is absent (<a href=\"%s\">Fix Gradle settings</a>)", Character.valueOf('\n'), "open_gradle_settings");
                msg = msg + String.format("%s  - you didn't apply Gradle plugin which provides the method (<a href=\"%s\">Apply Gradle plugin</a>)", Character.valueOf('\n'), "apply_gradle_plugin");
                msg = msg + String.format("%s  - or there is a mistake in a build script (<a href=\"%s\">Goto source</a>)", Character.valueOf('\n'), "goto_source");
                return this.createUserFriendlyError(msg, location, new String[]{"open_gradle_settings", "apply_gradle_plugin", "goto_source"});
            }
            return null;
        }
    }
}

