/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class BuildClasspathModuleGradleDataService
extends AbstractProjectDataService<BuildScriptClasspathData, Module> {
    private static final Logger LOG = Logger.getInstance(BuildClasspathModuleGradleDataService.class);

    @NotNull
    public Key<BuildScriptClasspathData> getTargetDataKey() {
        return BuildScriptClasspathData.KEY;
    }

    public void importData(@NotNull Collection<DataNode<BuildScriptClasspathData>> toImport, @Nullable ProjectData projectData, final @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (projectData == null || toImport.isEmpty()) {
            return;
        }
        final GradleInstallationManager gradleInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        final String linkedExternalProjectPath = projectData.getLinkedExternalProjectPath();
        File gradleHomeDir = ((BuildScriptClasspathData)toImport.iterator().next().getData()).getGradleHomeDir();
        GradleLocalSettings gradleLocalSettings = GradleLocalSettings.getInstance((Project)project);
        if (gradleHomeDir != null) {
            gradleLocalSettings.setGradleHome(linkedExternalProjectPath, gradleHomeDir.getPath());
        }
        GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(linkedExternalProjectPath);
        NotNullLazyValue<Set<String>> externalProjectGradleSdkLibs = new NotNullLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                List libraries;
                LinkedHashSet gradleSdkLibraries = ContainerUtil.newLinkedHashSet();
                File gradleHome = gradleInstallationManager.getGradleHome(project, linkedExternalProjectPath);
                if (gradleHome != null && gradleHome.isDirectory() && (libraries = gradleInstallationManager.getClassRoots(project, linkedExternalProjectPath)) != null) {
                    for (File library : libraries) {
                        gradleSdkLibraries.add(FileUtil.toCanonicalPath((String)library.getPath()));
                    }
                }
                return gradleSdkLibraries;
            }
        };
        THashMap localProjectBuildClasspath = new THashMap(localSettings.getProjectBuildClasspath());
        for (DataNode<BuildScriptClasspathData> node : toImport) {
            DataNode moduleDataNode;
            if (!GradleConstants.SYSTEM_ID.equals((Object)((BuildScriptClasspathData)node.getData()).getOwner()) || (moduleDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.MODULE)) == null) continue;
            String externalModulePath = ((ModuleData)moduleDataNode.getData()).getLinkedExternalProjectPath();
            if (settings == null || settings.getDistributionType() == null) {
                LOG.warn("Gradle SDK distribution type was not configured for the project at " + linkedExternalProjectPath);
            }
            LinkedHashSet buildClasspathSources = ContainerUtil.newLinkedHashSet();
            LinkedHashSet buildClasspathClasses = ContainerUtil.newLinkedHashSet();
            BuildScriptClasspathData buildScriptClasspathData = (BuildScriptClasspathData)node.getData();
            for (BuildScriptClasspathData.ClasspathEntry classpathEntry : buildScriptClasspathData.getClasspathEntries()) {
                for (String path : classpathEntry.getSourcesFile()) {
                    buildClasspathSources.add(FileUtil.toCanonicalPath((String)path));
                }
                for (String path : classpathEntry.getClassesFile()) {
                    buildClasspathClasses.add(FileUtil.toCanonicalPath((String)path));
                }
            }
            ExternalProjectBuildClasspathPojo projectBuildClasspathPojo = (ExternalProjectBuildClasspathPojo)localProjectBuildClasspath.get(linkedExternalProjectPath);
            if (projectBuildClasspathPojo == null) {
                projectBuildClasspathPojo = new ExternalProjectBuildClasspathPojo(((ModuleData)moduleDataNode.getData()).getExternalName(), (List)ContainerUtil.newArrayList(), (Map)ContainerUtil.newHashMap());
                localProjectBuildClasspath.put(linkedExternalProjectPath, projectBuildClasspathPojo);
            }
            ArrayList projectBuildClasspath = ContainerUtil.newArrayList((Iterable)((Iterable)externalProjectGradleSdkLibs.getValue()));
            projectBuildClasspathPojo.setProjectBuildClasspath((List)projectBuildClasspath);
            List buildClasspath = (List)StreamEx.of((Collection)buildClasspathSources).append((Collection)buildClasspathClasses).collect(Collectors.toList());
            projectBuildClasspathPojo.getModulesBuildClasspath().put(externalModulePath, new ExternalModuleBuildClasspathPojo(externalModulePath, buildClasspath));
        }
        localSettings.setProjectBuildClasspath((Map)localProjectBuildClasspath);
        if (!project.isDisposed()) {
            GradleBuildClasspathManager.getInstance(project).reload();
        }
    }
}

