/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocationSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.data.ExternalAnnotationsDataServiceKt;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Order(value=1000)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "Lcom/intellij/openapi/roots/libraries/Library;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "onSuccessImport", "", "imported", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "Companion", "intellij.gradle.java"})
public final class ExternalAnnotationsDataService
extends AbstractProjectDataService<LibraryData, Library> {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        return ProjectKeys.LIBRARY;
    }

    /*
     * WARNING - void declaration
     */
    public void onSuccessImport(@NotNull Collection<DataNode<LibraryData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ExternalAnnotationsArtifactsResolver externalAnnotationsArtifactsResolver = (ExternalAnnotationsArtifactsResolver)CollectionsKt.firstOrNull((List)ExternalAnnotationsArtifactsResolver.EP_NAME.getExtensionList());
        if (externalAnnotationsArtifactsResolver == null) {
            return;
        }
        ExternalAnnotationsArtifactsResolver resolver = externalAnnotationsArtifactsResolver;
        AnnotationsLocationSearcher searcher = AnnotationsLocationSearcher.Companion.getInstance(project);
        Iterable iterable = $receiver$iv = (Iterable)imported;
        Collection destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        Object object = $receiver$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Pair<Library, Collection<AnnotationsLocation>> pair;
            Library lib;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            DataNode it = (DataNode)element$iv$iv;
            boolean bl = false;
            LibraryData libData = (LibraryData)it.getData();
            Pair<Library, Collection<AnnotationsLocation>> pair2 = modelsProvider.getLibraryByName(libData.getInternalName()) == null ? null : ExternalAnnotationsDataServiceKt.lookForLocations(searcher, lib, libData);
            if (pair2 == null) continue;
            Pair<Library, Collection<AnnotationsLocation>> it$iv$iv = pair = pair2;
            destination$iv$iv.add(it$iv$iv);
        }
        Map providedAnnotations = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        ExternalAnnotationsDataServiceKt.resolveProvidedAnnotations(providedAnnotations, resolver, project);
        if (!Registry.is((String)"external.system.import.resolve.annotations")) {
            return;
        }
        if (imported.isEmpty()) {
            return;
        }
        ProjectData projectData2 = projectData;
        if (projectData2 != null) {
            boolean importRepositories;
            Object v3;
            block7: {
                Iterable $receiver = $receiver$iv = projectData2;
                boolean bl = false;
                $receiver$iv$iv$iv = GradleSettings.getInstance((Project)project).getLinkedProjectsSettings();
                object = $receiver$iv$iv$iv;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    GradleProjectSettings settings = (GradleProjectSettings)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)settings.getExternalProjectPath(), (Object)$receiver.getLinkedExternalProjectPath())) continue;
                    v3 = t;
                    break block7;
                }
                v3 = null;
            }
            GradleProjectSettings gradleProjectSettings = v3;
            boolean bl = importRepositories = gradleProjectSettings != null ? gradleProjectSettings.isResolveExternalAnnotations() : false;
            if (!importRepositories) {
                return;
            }
        }
        int totalSize = imported.size();
        String title$iv = "Resolving external annotations";
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title$iv, cancellable$iv, project, title$iv, cancellable$iv, imported, modelsProvider, resolver, project, totalSize){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ Collection $imported$inlined;
            final /* synthetic */ IdeModelsProvider $modelsProvider$inlined;
            final /* synthetic */ ExternalAnnotationsArtifactsResolver $resolver$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ int $totalSize$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$imported$inlined = collection;
                this.$modelsProvider$inlined = ideModelsProvider;
                this.$resolver$inlined = externalAnnotationsArtifactsResolver;
                this.$project$inlined = project;
                this.$totalSize$inlined = n;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                indicator2.setIndeterminate(false);
                Iterable $receiver$iv = this.$imported$inlined;
                int index$iv = 0;
                for (T item$iv : $receiver$iv) {
                    void dataNode;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    DataNode dataNode2 = (DataNode)item$iv;
                    int index = n2;
                    boolean bl2 = false;
                    if (indicator2.isCanceled()) break;
                    LibraryData libraryData = (LibraryData)dataNode.getData();
                    String libraryName = libraryData.getInternalName();
                    Library library = this.$modelsProvider$inlined.getLibraryByName(libraryName);
                    if (library != null) {
                        indicator2.setText("Looking for annotations for '" + libraryName + '\'');
                        String mavenId = libraryData.getGroupId() + ':' + libraryData.getArtifactId() + ':' + libraryData.getVersion();
                        this.$resolver$inlined.resolve(this.$project$inlined, library, mavenId);
                    }
                    indicator2.setFraction((double)(index + 1) / (double)this.$totalSize$inlined);
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(ExternalAnnotationsDataService.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.java"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

