/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksPanel;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNodeBase;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleFrameworkSupportProvider;
import org.jetbrains.plugins.gradle.frameworkSupport.KotlinDslGradleFrameworkSupportProvider;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleBuilder;

public class GradleFrameworksWizardStep
extends ModuleWizardStep
implements Disposable {
    private JPanel myPanel;
    private final AddSupportForFrameworksPanel myFrameworksPanel;
    private JPanel myFrameworksPanelPlaceholder;
    private JPanel myOptionsPanel;
    private JBLabel myFrameworksLabel;
    private JCheckBox kdslCheckBox;

    public GradleFrameworksWizardStep(WizardContext context, final GradleModuleBuilder builder) {
        this.$$$setupUI$$$();
        Project project = context.getProject();
        LibrariesContainer container = LibrariesContainerFactory.createContainer((Project)context.getProject());
        FrameworkSupportModelBase model = new FrameworkSupportModelBase(project, (ModuleBuilder)builder, container){

            @NotNull
            public String getBaseDirectoryForLibrariesPath() {
                return StringUtil.notNullize((String)builder.getContentEntryPath());
            }
        };
        this.myFrameworksPanel = new AddSupportForFrameworksPanel(Collections.emptyList(), model, true, null);
        this.setGradleFrameworkSupportProviders(Collections.singleton("java"));
        Disposer.register((Disposable)this, (Disposable)this.myFrameworksPanel);
        this.myFrameworksPanelPlaceholder.add(this.myFrameworksPanel.getMainPanel());
        ModuleBuilder.ModuleConfigurationUpdater configurationUpdater = new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                GradleFrameworksWizardStep.this.myFrameworksPanel.addSupport(module, rootModel);
            }
        };
        builder.addModuleConfigurationUpdater(configurationUpdater);
        ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, "frameworks card");
        this.kdslCheckBox.addActionListener(actionEvent -> {
            builder.setUseKotlinDsl(this.kdslCheckBox.isSelected());
            Set selectedNodeIds = ContainerUtil.map2Set((Collection)this.myFrameworksPanel.getSelectedNodes(), FrameworkSupportNodeBase::getId);
            if (this.kdslCheckBox.isSelected()) {
                this.setKotlinDslGradleFrameworkSupportProviders(selectedNodeIds);
            } else {
                this.setGradleFrameworkSupportProviders(selectedNodeIds);
            }
        });
    }

    private void setKotlinDslGradleFrameworkSupportProviders(Set<String> selectedNodeIds) {
        ArrayList providers = ContainerUtil.newArrayList();
        Collections.addAll(providers, KotlinDslGradleFrameworkSupportProvider.EP_NAME.getExtensions());
        this.myFrameworksPanel.setProviders((List)providers, Collections.emptySet(), selectedNodeIds);
    }

    private void setGradleFrameworkSupportProviders(Set<String> selectedNodeIds) {
        ArrayList providers = ContainerUtil.newArrayList();
        Collections.addAll(providers, GradleFrameworkSupportProvider.EP_NAME.getExtensions());
        this.myFrameworksPanel.setProviders((List)providers, Collections.emptySet(), selectedNodeIds);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
    }

    public void dispose() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel5, "templates card");
        this.myFrameworksPanelPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "frameworks card");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, "North");
        this.kdslCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Kotlin DSL build script");
        jCheckBox.setVerticalAlignment(1);
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myFrameworksLabel = jBLabel = new JBLabel();
        jBLabel.setText("Additional Libraries and Frameworks:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(25);
        jPanel6.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

