/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalStateComponent;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.externalSystem.service.project.wizard.ExternalModuleSettingsStep;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.KotlinBuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleFrameworksWizardStep;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleWizardStep;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.settings.DefaultGradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleModuleBuilder
extends AbstractExternalModuleBuilder<GradleProjectSettings> {
    private static final Logger LOG = Logger.getInstance(GradleModuleBuilder.class);
    private static final String TEMPLATE_GRADLE_SETTINGS = "Gradle Settings.gradle";
    private static final String TEMPLATE_GRADLE_SETTINGS_MERGE = "Gradle Settings merge.gradle";
    private static final String TEMPLATE_GRADLE_BUILD_WITH_WRAPPER = "Gradle Build Script with wrapper.gradle";
    private static final String DEFAULT_TEMPLATE_GRADLE_BUILD = "Gradle Build Script.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_BUILD = "Gradle Kotlin DSL Build Script.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_BUILD_WITH_WRAPPER = "Gradle Kotlin DSL Build Script with wrapper.gradle";
    private static final String TEMPLATE_ATTRIBUTE_PROJECT_NAME = "PROJECT_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_PATH = "MODULE_PATH";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_FLAT_DIR = "MODULE_FLAT_DIR";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_NAME = "MODULE_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_GROUP = "MODULE_GROUP";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_VERSION = "MODULE_VERSION";
    private static final String TEMPLATE_ATTRIBUTE_GRADLE_VERSION = "GRADLE_VERSION";
    private static final Key<BuildScriptDataBuilder> BUILD_SCRIPT_DATA = Key.create((String)"gradle.module.buildScriptData");
    private WizardContext myWizardContext;
    @Nullable
    private ProjectData myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private ProjectId myProjectId;
    private String rootProjectPath;
    private boolean myUseKotlinDSL;

    public GradleModuleBuilder() {
        super(GradleConstants.SYSTEM_ID, (ExternalProjectSettings)new GradleProjectSettings().withQualifiedModuleNames());
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, ConfigurationException {
        String moduleFileDirectory;
        LOG.assertTrue(this.getName() != null);
        String originModuleFilePath = this.getModuleFilePath();
        LOG.assertTrue(originModuleFilePath != null);
        String moduleName = this.myProjectId == null ? this.getName() : this.myProjectId.getArtifactId();
        Project contextProject = this.myWizardContext.getProject();
        String projectFileDirectory = null;
        if (this.myWizardContext.isCreatingNewProject() || contextProject == null || contextProject.getBasePath() == null) {
            projectFileDirectory = this.myWizardContext.getProjectFileDirectory();
        } else if (this.myWizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT && (moduleFileDirectory = this.getModuleFileDirectory()) != null) {
            projectFileDirectory = moduleFileDirectory;
        }
        if (projectFileDirectory == null) {
            projectFileDirectory = contextProject.getBasePath();
        }
        if (this.myWizardContext.getProjectStorageFormat() == StorageScheme.DIRECTORY_BASED) {
            projectFileDirectory = projectFileDirectory + "/.idea/modules";
        }
        String moduleFilePath = projectFileDirectory + "/" + moduleName + ".iml";
        GradleModuleBuilder.deleteModuleFile((String)moduleFilePath);
        ModuleType moduleType = this.getModuleType();
        Module module = moduleModel.newModule(moduleFilePath, moduleType.getId());
        this.setupModule(module);
        return module;
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        String contentEntryPath = this.getContentEntryPath();
        if (StringUtil.isEmpty((String)contentEntryPath)) {
            return;
        }
        File contentRootDir = new File(contentEntryPath);
        FileUtilRt.createDirectory((File)contentRootDir);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile modelContentRootDir = fileSystem.refreshAndFindFileByIoFile(contentRootDir);
        if (modelContentRootDir == null) {
            return;
        }
        modifiableRootModel.addContentEntry(modelContentRootDir);
        if (this.myJdk != null) {
            modifiableRootModel.setSdk(this.myJdk);
        } else {
            modifiableRootModel.inheritSdk();
        }
        Project project = modifiableRootModel.getProject();
        this.rootProjectPath = this.myParentProject != null ? this.myParentProject.getLinkedExternalProjectPath() : FileUtil.toCanonicalPath((String)(this.myWizardContext.isCreatingNewProject() ? project.getBasePath() : modelContentRootDir.getPath()));
        assert (this.rootProjectPath != null);
        VirtualFile gradleBuildFile = this.setupGradleBuildFile(modelContentRootDir);
        GradleModuleBuilder.setupGradleSettingsFile(this.rootProjectPath, modelContentRootDir, modifiableRootModel.getProject().getName(), this.myProjectId == null ? modifiableRootModel.getModule().getName() : this.myProjectId.getArtifactId(), this.myWizardContext.isCreatingNewProject() || this.myParentProject == null);
        if (gradleBuildFile != null) {
            BuildScriptDataBuilder builder;
            if (this.myUseKotlinDSL) {
                GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)this.getExternalProjectSettings();
                GradleVersion version = gradleProjectSettings.resolveGradleVersion();
                builder = new KotlinBuildScriptDataBuilder(gradleBuildFile, version);
            } else {
                builder = new BuildScriptDataBuilder(gradleBuildFile);
            }
            modifiableRootModel.getModule().putUserData(BUILD_SCRIPT_DATA, (Object)builder);
        }
    }

    protected void setupModule(Module module) throws ConfigurationException {
        super.setupModule(module);
        assert (this.rootProjectPath != null);
        VirtualFile buildScriptFile = null;
        BuildScriptDataBuilder buildScriptDataBuilder = GradleModuleBuilder.getBuildScriptData(module);
        try {
            if (buildScriptDataBuilder != null) {
                buildScriptFile = buildScriptDataBuilder.getBuildScriptFile();
                String lineSeparator = GradleModuleBuilder.lineSeparator(buildScriptFile);
                String imports = StringUtil.convertLineSeparators((String)buildScriptDataBuilder.buildImports(), (String)lineSeparator);
                String configurationPart = StringUtil.convertLineSeparators((String)buildScriptDataBuilder.buildConfigurationPart(), (String)lineSeparator);
                String existingText = StringUtil.trimTrailing((String)VfsUtilCore.loadText((VirtualFile)buildScriptFile));
                String content = (!imports.isEmpty() ? imports + lineSeparator : "") + (!configurationPart.isEmpty() ? configurationPart + lineSeparator : "") + (!existingText.isEmpty() ? existingText + lineSeparator : "") + lineSeparator + StringUtil.convertLineSeparators((String)buildScriptDataBuilder.buildMainPart(), (String)lineSeparator);
                VfsUtil.saveText((VirtualFile)buildScriptFile, (String)content);
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception on applying frameworks templates", (Throwable)e);
        }
        ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module);
        modulePropertyManager.setExternalId(GradleConstants.SYSTEM_ID);
        ExternalStateComponent moduleState = modulePropertyManager.getState();
        moduleState.setRootProjectPath(this.rootProjectPath);
        moduleState.setLinkedProjectPath(this.rootProjectPath);
        Project project = module.getProject();
        if (this.myWizardContext.isCreatingNewProject()) {
            GradleModuleBuilder.preventOldSettingsMigration(project);
            ((GradleProjectSettings)this.getExternalProjectSettings()).setExternalProjectPath(this.rootProjectPath);
            AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
            settings.linkProject(this.getExternalProjectSettings());
            ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, project.getName(), this.myWizardContext.getProjectFileDirectory(), ((GradleProjectSettings)this.getExternalProjectSettings()).getExternalProjectPath());
            DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
            ExternalProjectsManagerImpl.getInstance((Project)project).updateExternalProjectData((ExternalProjectInfo)new InternalExternalProjectInfo(GradleConstants.SYSTEM_ID, ((GradleProjectSettings)this.getExternalProjectSettings()).getExternalProjectPath(), projectDataNode));
        } else {
            FileDocumentManager.getInstance().saveAllDocuments();
            GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)this.getExternalProjectSettings();
            VirtualFile finalBuildScriptFile = buildScriptFile;
            Runnable runnable = () -> {
                PsiFile psiFile;
                if (this.myParentProject == null) {
                    gradleProjectSettings.setExternalProjectPath(this.rootProjectPath);
                    AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                    settings.linkProject((ExternalProjectSettings)gradleProjectSettings);
                }
                ImportSpec importSpec = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).use(ProgressExecutionMode.IN_BACKGROUND_ASYNC).createDirectoriesForEmptyContentRoots().useDefaultCallback().build();
                ExternalSystemUtil.refreshProject((String)this.rootProjectPath, (ImportSpec)importSpec);
                if (finalBuildScriptFile != null && (psiFile = PsiManager.getInstance((Project)project).findFile(finalBuildScriptFile)) != null) {
                    EditorHelper.openInEditor((PsiElement)psiFile);
                }
            };
            ExternalSystemUtil.invokeLater((Project)project, (ModalityState)ModalityState.NON_MODAL, (Runnable)runnable);
        }
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    private static void preventOldSettingsMigration(Project project) {
        DefaultGradleProjectSettings.MyState state = new DefaultGradleProjectSettings.MyState();
        state.isMigrated = true;
        state.delegatedBuild = true;
        state.testRunner = TestRunner.GRADLE;
        DefaultGradleProjectSettings.getInstance((Project)project).loadState(state);
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        this.myWizardContext = wizardContext;
        GradleProjectSettings settings = ((GradleProjectSettings)this.getExternalProjectSettings()).clone();
        settings.setStoreProjectFilesExternally(ThreeState.UNSURE);
        return new ModuleWizardStep[]{new GradleModuleWizardStep(this, wizardContext), new ExternalModuleSettingsStep(wizardContext, (AbstractExternalModuleBuilder)this, (AbstractExternalProjectSettingsControl)new GradleProjectSettingsControl(settings))};
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        GradleFrameworksWizardStep step = new GradleFrameworksWizardStep(context, this);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk instanceof JavaSdkType;
    }

    public String getParentGroup() {
        return "Build Tools";
    }

    public int getWeight() {
        return 80;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    @Nullable
    private VirtualFile setupGradleBuildFile(@NotNull VirtualFile modelContentRootDir) throws ConfigurationException {
        String scriptName = this.myUseKotlinDSL ? "build.gradle.kts" : "build.gradle";
        VirtualFile file = GradleModuleBuilder.getOrCreateExternalProjectConfigFile(modelContentRootDir.getPath(), scriptName);
        if (file != null) {
            String templateName = this.myUseKotlinDSL ? (((GradleProjectSettings)this.getExternalProjectSettings()).getDistributionType() == DistributionType.WRAPPED ? KOTLIN_DSL_TEMPLATE_GRADLE_BUILD_WITH_WRAPPER : KOTLIN_DSL_TEMPLATE_GRADLE_BUILD) : (((GradleProjectSettings)this.getExternalProjectSettings()).getDistributionType() == DistributionType.WRAPPED ? TEMPLATE_GRADLE_BUILD_WITH_WRAPPER : DEFAULT_TEMPLATE_GRADLE_BUILD);
            HashMap attributes = ContainerUtil.newHashMap();
            if (this.myProjectId != null) {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_VERSION, this.myProjectId.getVersion());
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_GROUP, this.myProjectId.getGroupId());
                attributes.put(TEMPLATE_ATTRIBUTE_GRADLE_VERSION, GradleVersion.current().getVersion());
            }
            GradleModuleBuilder.saveFile(file, templateName, attributes);
        }
        return file;
    }

    @Nullable
    public static VirtualFile setupGradleSettingsFile(@NotNull String rootProjectPath, @NotNull VirtualFile modelContentRootDir, String projectName, String moduleName, boolean renderNewFile) throws ConfigurationException {
        VirtualFile file = GradleModuleBuilder.getOrCreateExternalProjectConfigFile(rootProjectPath, "settings.gradle");
        if (file == null) {
            return null;
        }
        if (renderNewFile) {
            String moduleDirName = VfsUtilCore.getRelativePath((VirtualFile)modelContentRootDir, (VirtualFile)file.getParent(), (char)'/');
            HashMap attributes = ContainerUtil.newHashMap();
            attributes.put(TEMPLATE_ATTRIBUTE_PROJECT_NAME, projectName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, moduleDirName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, moduleName);
            GradleModuleBuilder.saveFile(file, TEMPLATE_GRADLE_SETTINGS, attributes);
        } else {
            String flatStructureModulePath;
            char separatorChar = file.getParent() == null || !VfsUtilCore.isAncestor((VirtualFile)file.getParent(), (VirtualFile)modelContentRootDir, (boolean)true) ? (char)'/' : ':';
            String modulePath = VfsUtilCore.findRelativePath((VirtualFile)file, (VirtualFile)modelContentRootDir, (char)separatorChar);
            HashMap attributes = ContainerUtil.newHashMap();
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, moduleName);
            String string = flatStructureModulePath = modulePath != null && StringUtil.startsWith((CharSequence)modulePath, (CharSequence)"../") ? StringUtil.trimStart((String)modulePath, (String)"../") : null;
            if (StringUtil.equals(flatStructureModulePath, (CharSequence)modelContentRootDir.getName())) {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_FLAT_DIR, "true");
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, flatStructureModulePath);
            } else {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, modulePath);
            }
            GradleModuleBuilder.appendToFile(file, TEMPLATE_GRADLE_SETTINGS_MERGE, attributes);
        }
        return file;
    }

    private static void saveFile(@NotNull VirtualFile file, @NotNull String templateName, @Nullable Map templateAttributes) throws ConfigurationException {
        FileTemplateManager manager = FileTemplateManager.getDefaultInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            GradleModuleBuilder.appendToFile(file, templateAttributes != null ? template.getText(templateAttributes) : template.getText());
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected exception on applying template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(e.getMessage(), String.format("Can't apply %s template config text", GradleConstants.SYSTEM_ID.getReadableName()));
        }
    }

    private static void appendToFile(@NotNull VirtualFile file, @NotNull String templateName, @Nullable Map templateAttributes) throws ConfigurationException {
        FileTemplateManager manager = FileTemplateManager.getDefaultInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            GradleModuleBuilder.appendToFile(file, templateAttributes != null ? template.getText(templateAttributes) : template.getText());
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected exception on appending template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(e.getMessage(), String.format("Can't append %s template config text", GradleConstants.SYSTEM_ID.getReadableName()));
        }
    }

    @Nullable
    private static VirtualFile getOrCreateExternalProjectConfigFile(@NotNull String parent, @NotNull String fileName) {
        File file = new File(parent, fileName);
        FileUtilRt.createIfNotExists((File)file);
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    public void setParentProject(@Nullable ProjectData parentProject) {
        this.myParentProject = parentProject;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public void setInheritGroupId(boolean inheritGroupId) {
        this.myInheritGroupId = inheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    public void setInheritVersion(boolean inheritVersion) {
        this.myInheritVersion = inheritVersion;
    }

    public ProjectId getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(@NotNull ProjectId projectId) {
        this.myProjectId = projectId;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep instanceof ProjectSettingsStep) {
            ProjectSettingsStep projectSettingsStep = (ProjectSettingsStep)settingsStep;
            if (this.myProjectId != null) {
                ModuleNameLocationSettings nameLocationSettings = settingsStep.getModuleNameLocationSettings();
                String artifactId = this.myProjectId.getArtifactId();
                if (nameLocationSettings != null && artifactId != null) {
                    nameLocationSettings.setModuleName(artifactId);
                }
            }
            projectSettingsStep.bindModuleSettings();
        }
        return super.modifySettingsStep(settingsStep);
    }

    public static void appendToFile(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        String lineSeparator = GradleModuleBuilder.lineSeparator(file);
        String existingText = StringUtil.trimTrailing((String)VfsUtilCore.loadText((VirtualFile)file));
        String content = (StringUtil.isNotEmpty((String)existingText) ? existingText + lineSeparator : "") + StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
        VfsUtil.saveText((VirtualFile)file, (String)content);
    }

    @NotNull
    private static String lineSeparator(@NotNull VirtualFile file) {
        String lineSeparator = LoadTextUtil.detectLineSeparator((VirtualFile)file, (boolean)true);
        if (lineSeparator == null) {
            lineSeparator = CodeStyle.getDefaultSettings().getLineSeparator();
        }
        return lineSeparator;
    }

    @Nullable
    public static BuildScriptDataBuilder getBuildScriptData(@Nullable Module module) {
        return module == null ? null : (BuildScriptDataBuilder)module.getUserData(BUILD_SCRIPT_DATA);
    }

    @Nullable
    public Project createProject(String name, String path) {
        return ExternalProjectsManagerImpl.setupCreatedProject((Project)super.createProject(name, path));
    }

    public void setUseKotlinDsl(boolean useKotlinDSL) {
        this.myUseKotlinDSL = useKotlinDSL;
    }
}

