/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.startup;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.projectImport.ProjectImportProvider;
import java.io.File;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.config.GradleResourceCompilerConfigurationGenerator;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportProvider;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleJvmStartupActivity
implements StartupActivity {
    @NonNls
    private static final String SHOW_UNLINKED_GRADLE_POPUP = "show.inlinked.gradle.project.popup";
    private static final String IMPORT_EVENT_DESCRIPTION = "import";
    private static final String DO_NOT_SHOW_EVENT_DESCRIPTION = "do.not.show";

    public void runActivity(@NotNull Project project) {
        GradleJvmStartupActivity.configureBuildClasspath(project);
        GradleJvmStartupActivity.showNotificationForUnlinkedGradleProject(project);
        final GradleResourceCompilerConfigurationGenerator buildConfigurationGenerator = new GradleResourceCompilerConfigurationGenerator(project);
        CompilerManager.getInstance((Project)project).addBeforeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                ApplicationManager.getApplication().runReadAction(() -> buildConfigurationGenerator.generateBuildConfiguration(context));
                return true;
            }
        });
    }

    private static void configureBuildClasspath(@NotNull Project project) {
        GradleBuildClasspathManager.getInstance(project).reload();
    }

    private static void showNotificationForUnlinkedGradleProject(final @NotNull Project project) {
        String kotlinDslGradleFile;
        if (!PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_UNLINKED_GRADLE_POPUP, true) || !GradleSettings.getInstance((Project)project).getLinkedProjectsSettings().isEmpty() || project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE || project.getBaseDir() == null) {
            return;
        }
        String baseDir = project.getBaseDir().getPath();
        String gradleGroovyDslFile = baseDir + '/' + "build.gradle";
        final File gradleFile = FileUtil.findFirstThatExist((String[])new String[]{gradleGroovyDslFile, kotlinDslGradleFile = baseDir + '/' + "build.gradle.kts"});
        if (gradleFile != null) {
            String message = String.format("%s<br>\n%s", GradleBundle.message((String)"gradle.notifications.unlinked.project.found.msg", (Object[])new Object[]{IMPORT_EVENT_DESCRIPTION}), GradleBundle.message((String)"gradle.notifications.do.not.show", (Object[])new Object[0]));
            GradleNotification.getInstance((Project)project).showBalloon(GradleBundle.message((String)"gradle.notifications.unlinked.project.found.title", (Object[])new Object[0]), message, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    notification.expire();
                    if (GradleJvmStartupActivity.IMPORT_EVENT_DESCRIPTION.equals(e.getDescription())) {
                        ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
                        GradleProjectImportBuilder gradleProjectImportBuilder = new GradleProjectImportBuilder(projectDataManager);
                        GradleProjectImportProvider gradleProjectImportProvider = new GradleProjectImportProvider(gradleProjectImportBuilder);
                        AddModuleWizard wizard = new AddModuleWizard(project, gradleFile.getPath(), new ProjectImportProvider[]{gradleProjectImportProvider});
                        if (wizard.getStepCount() <= 0 || wizard.showAndGet()) {
                            ImportModuleAction.createFromWizard((Project)project, (AbstractProjectWizard)wizard);
                        }
                    } else if (GradleJvmStartupActivity.DO_NOT_SHOW_EVENT_DESCRIPTION.equals(e.getDescription())) {
                        PropertiesComponent.getInstance((Project)project).setValue(GradleJvmStartupActivity.SHOW_UNLINKED_GRADLE_POPUP, false, true);
                    }
                }
            });
        }
    }
}

