/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleLog;

public class GradleAttachSourcesProvider
implements AttachSourcesProvider {
    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, final PsiFile psiFile) {
        Map<LibraryOrderEntry, Module> gradleModules = GradleAttachSourcesProvider.getGradleModules(orderEntries);
        if (gradleModules.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singleton(new AttachSourcesProvider.AttachSourcesAction(){

            public String getName() {
                return GradleBundle.message((String)"gradle.action.download.sources", (Object[])new Object[0]);
            }

            public String getBusyText() {
                return GradleBundle.message((String)"gradle.action.download.sources.busy.text", (Object[])new Object[0]);
            }

            public ActionCallback perform(final List<LibraryOrderEntry> orderEntries) {
                String sourcesLocationFilePath;
                File sourcesLocationFile;
                Map gradleModules = GradleAttachSourcesProvider.getGradleModules(orderEntries);
                if (gradleModules.isEmpty()) {
                    return ActionCallback.REJECTED;
                }
                final ActionCallback resultWrapper = new ActionCallback();
                final Project project = psiFile.getProject();
                Map.Entry next = gradleModules.entrySet().iterator().next();
                final LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)next.getKey();
                Module module = (Module)next.getValue();
                String libraryName = libraryOrderEntry.getLibraryName();
                if (libraryName == null) {
                    return ActionCallback.REJECTED;
                }
                final String artifactCoordinates = StringUtil.trimStart((String)libraryName, (String)(GradleConstants.SYSTEM_ID.getReadableName() + ": "));
                if (StringUtil.equals((CharSequence)libraryName, (CharSequence)artifactCoordinates)) {
                    return ActionCallback.REJECTED;
                }
                String gradlePath = GradleProjectResolverUtil.getGradlePath((Module)module);
                if (gradlePath == null) {
                    return ActionCallback.REJECTED;
                }
                try {
                    sourcesLocationFile = new File(FileUtil.createTempDirectory((String)"sources", (String)"loc"), "path.tmp");
                    sourcesLocationFilePath = StringUtil.escapeBackSlashes((String)sourcesLocationFile.getCanonicalPath());
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.delete((File)sourcesLocationFile), "GradleAttachSourcesProvider cleanup"));
                }
                catch (IOException e) {
                    GradleLog.LOG.warn((Throwable)e);
                    return ActionCallback.REJECTED;
                }
                String taskName = "DownloadSources";
                String initScript = "allprojects {\n  afterEvaluate { project ->\n    if(project.path == '" + gradlePath + "') {\n        project.tasks.create(name: '" + "DownloadSources" + "', overwrite: true) {\n        doLast {\n          def configuration = null\n          def repository = project.repositories.toList().find {\n              project.repositories.clear()\n              project.repositories.add(it)\n              configuration = project.configurations.create('downloadSourcesFrom_' + it.name + '_' + UUID.randomUUID())\n              configuration.transitive = false\n              project.dependencies.add(configuration.name, '" + artifactCoordinates + ":sources')\n              configuration.resolvedConfiguration.lenientConfiguration.getFiles().any()\n          }\n          if (!repository) {\n              configuration = project.configurations.create('downloadSources_' + UUID.randomUUID())\n              configuration.transitive = false\n              project.dependencies.add(configuration.name, '" + artifactCoordinates + ":sources')\n              configuration.resolve()\n          }\n          new File('" + sourcesLocationFilePath + "').write configuration?.singleFile?.path\n        }\n      }\n    }\n  }\n}\n";
                UserDataHolderBase userData = new UserDataHolderBase();
                userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
                String gradleVmOptions = GradleSettings.getInstance((Project)project).getGradleVmOptions();
                ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
                settings.setExecutionName("Download sources");
                settings.setExternalProjectPath(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
                settings.setTaskNames(ContainerUtil.list((Object[])new String[]{"DownloadSources"}));
                settings.setVmOptions(gradleVmOptions);
                settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
                ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)DefaultRunExecutor.EXECUTOR_ID, (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)new TaskCallback(){

                    public void onSuccess() {
                        VirtualFile classesFile = libraryOrderEntry.getFiles(OrderRootType.CLASSES)[0];
                        File sourceJar = GradleAttachSourcesProvider.getSourceFile(artifactCoordinates, classesFile, project);
                        if (sourceJar == null) {
                            try {
                                sourceJar = new File(FileUtil.loadFile((File)sourcesLocationFile));
                                FileUtil.delete((File)sourcesLocationFile);
                            }
                            catch (IOException e) {
                                GradleLog.LOG.warn((Throwable)e);
                            }
                        }
                        File finalSourceJar = sourceJar;
                        ApplicationManager.getApplication().invokeLater(() -> {
                            HashSet libraries = new HashSet();
                            for (LibraryOrderEntry orderEntry : orderEntries) {
                                ContainerUtil.addIfNotNull(libraries, (Object)orderEntry.getLibrary());
                            }
                            if (finalSourceJar != null) {
                                InternetAttachSourceProvider.attachSourceJar((File)finalSourceJar, libraries);
                            }
                            resultWrapper.setDone();
                        });
                    }

                    public void onFailure() {
                        resultWrapper.setRejected();
                        String message = "<html>Sources not found for: " + artifactCoordinates + "</html>";
                        NotificationData notification = new NotificationData("Sources download failed", message, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
                        ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notification);
                    }
                }, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
                return resultWrapper;
            }
        });
    }

    @Nullable
    private static File getSourceFile(String artifactCoordinates, VirtualFile classesFile, Project project) {
        LibraryData data = new LibraryData(GradleConstants.SYSTEM_ID, artifactCoordinates);
        data.addPath(LibraryPathType.BINARY, VfsUtil.getLocalFile((VirtualFile)classesFile).getPath());
        String serviceDirectory = GradleSettings.getInstance((Project)project).getServiceDirectoryPath();
        File gradleUserHome = serviceDirectory != null ? new File(serviceDirectory) : new BuildLayoutParameters().getGradleUserHomeDir();
        GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded((File)gradleUserHome, (LibraryData)data);
        Iterator iterator = data.getPaths(LibraryPathType.SOURCE).iterator();
        return iterator.hasNext() ? new File((String)iterator.next()) : null;
    }

    private static Map<LibraryOrderEntry, Module> getGradleModules(List<LibraryOrderEntry> libraryOrderEntries) {
        HashMap result = ContainerUtil.newHashMap();
        for (LibraryOrderEntry entry : libraryOrderEntries) {
            Module module;
            if (entry.isModuleLevel() || !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module = entry.getOwnerModule()))) continue;
            result.put(entry, module);
        }
        return result;
    }
}

