/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class CompilerReferenceIndex<Input> {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceIndex.class);
    private static final String FILE_ENUM_TAB = "file.path.enum.tab";
    private static final String NAME_ENUM_TAB = "name.tab";
    private static final String VERSION_FILE = "version";
    private final ConcurrentMap<IndexId<?, ?>, InvertedIndex<?, ?, Input>> myIndices;
    private final NameEnumerator myNameEnumerator;
    private final PersistentStringEnumerator myFilePathEnumerator;
    private final File myBuildDir;
    private final File myIndicesDir;
    private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameEnumerator nameEnumerator = CompilerReferenceIndex.this.myNameEnumerator;
            synchronized (nameEnumerator) {
                if (!CompilerReferenceIndex.this.myNameEnumerator.isClosed()) {
                    CompilerReferenceIndex.this.myNameEnumerator.force();
                }
            }
            nameEnumerator = CompilerReferenceIndex.this.myFilePathEnumerator;
            synchronized (nameEnumerator) {
                if (!CompilerReferenceIndex.this.myFilePathEnumerator.isClosed()) {
                    CompilerReferenceIndex.this.myFilePathEnumerator.force();
                }
            }
        }
    });
    private volatile Throwable myRebuildRequestCause;

    public CompilerReferenceIndex(Collection<? extends IndexExtension<?, ?, ? super Input>> indices, File buildDir, boolean readOnly, int version) {
        this.myBuildDir = buildDir;
        this.myIndicesDir = CompilerReferenceIndex.getIndexDir(buildDir);
        if (!this.myIndicesDir.exists() && !this.myIndicesDir.mkdirs()) {
            throw new RuntimeException("Can't create dir: " + buildDir.getAbsolutePath());
        }
        try {
            if (CompilerReferenceIndex.versionDiffers(buildDir, version)) {
                this.saveVersion(buildDir, version);
            }
            this.myFilePathEnumerator = new PersistentStringEnumerator(new File(this.myIndicesDir, FILE_ENUM_TAB)){

                public int enumerate(String value) throws IOException {
                    return super.enumerate(SystemInfo.isFileSystemCaseSensitive ? value : value.toLowerCase(Locale.ROOT));
                }
            };
            this.myIndices = new ConcurrentHashMap();
            for (IndexExtension<?, ?, Input> indexExtension : indices) {
                this.myIndices.put((IndexId<?, ?>)indexExtension.getName(), (InvertedIndex<?, ?, Input>)new CompilerMapReduceIndex(indexExtension, this.myIndicesDir, readOnly));
            }
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                for (IndexId id : this.myIndices.keySet()) {
                    System.err.println("Leaked javac compiler index \"" + id.getName() + "\"");
                }
            });
            this.myNameEnumerator = new NameEnumerator(new File(this.myIndicesDir, NAME_ENUM_TAB));
        }
        catch (IOException e) {
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir);
            throw new BuildDataCorruptedException(e);
        }
    }

    public Collection<InvertedIndex<?, ?, Input>> getIndices() {
        return this.myIndices.values();
    }

    public <K, V> InvertedIndex<K, V, Input> get(IndexId<K, V> key) {
        return (InvertedIndex)this.myIndices.get(key);
    }

    @NotNull
    public NameEnumerator getByteSeqEum() {
        return this.myNameEnumerator;
    }

    @NotNull
    public PersistentStringEnumerator getFilePathEnumerator() {
        return this.myFilePathEnumerator;
    }

    public void close() {
        this.myLowMemoryWatcher.stop();
        CommonProcessors.FindFirstProcessor<Exception> exceptionProc = new CommonProcessors.FindFirstProcessor<Exception>(){

            public boolean process(Exception e) {
                LOG.error((Throwable)e);
                return super.process((Object)e);
            }
        };
        CompilerReferenceIndex.close((Closeable)this.myFilePathEnumerator, (Processor<Exception>)exceptionProc);
        CompilerReferenceIndex.close((Closeable)((Object)this.myNameEnumerator), (Processor<Exception>)exceptionProc);
        Iterator iterator = this.myIndices.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry index = iterator.next();
            CompilerReferenceIndex.close((InvertedIndex)index.getValue(), exceptionProc);
            iterator.remove();
        }
        Exception exception = (Exception)exceptionProc.getFoundValue();
        if (exception != null) {
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir);
            if (this.myRebuildRequestCause == null) {
                throw new RuntimeException(exception);
            }
            return;
        }
        if (this.myRebuildRequestCause != null) {
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir);
        }
    }

    public static void removeIndexFiles(File buildDir) {
        File indexDir = CompilerReferenceIndex.getIndexDir(buildDir);
        if (indexDir.exists()) {
            FileUtil.delete((File)indexDir);
        }
    }

    private static File getIndexDir(@NotNull File buildDir) {
        return new File(buildDir, "backward-refs");
    }

    public static boolean exists(@NotNull File buildDir) {
        return CompilerReferenceIndex.getIndexDir(buildDir).exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean versionDiffers(@NotNull File buildDir, int expectedVersion) {
        File versionFile = new File(CompilerReferenceIndex.getIndexDir(buildDir), VERSION_FILE);
        try (DataInputStream is = new DataInputStream(new FileInputStream(versionFile));){
            boolean isDiffer;
            int currentIndexVersion = is.readInt();
            boolean bl = isDiffer = currentIndexVersion != expectedVersion;
            if (isDiffer) {
                LOG.info("backward reference index version differ, expected = " + expectedVersion + ", current = " + currentIndexVersion);
            }
            boolean bl2 = isDiffer;
            return bl2;
        }
        catch (IOException e) {
            LOG.info("backward reference index version differ due to: " + e.getClass());
            return true;
        }
    }

    public void saveVersion(@NotNull File buildDir, int version) {
        File versionFile = new File(CompilerReferenceIndex.getIndexDir(buildDir), VERSION_FILE);
        FileUtil.createIfDoesntExist((File)versionFile);
        try (DataOutputStream os = new DataOutputStream(new FileOutputStream(versionFile));){
            os.writeInt(version);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
            throw new BuildDataCorruptedException(ex);
        }
    }

    public Throwable getRebuildRequestCause() {
        return this.myRebuildRequestCause;
    }

    public File getIndicesDir() {
        return this.myIndicesDir;
    }

    public void setRebuildRequestCause(Throwable e) {
        this.myRebuildRequestCause = e;
    }

    private static void close(InvertedIndex<?, ?, ?> index, CommonProcessors.FindFirstProcessor<Exception> exceptionProcessor) {
        try {
            index.dispose();
        }
        catch (Exception e) {
            exceptionProcessor.process((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Closeable closeable, Processor<Exception> exceptionProcessor) {
        Closeable closeable2 = closeable;
        synchronized (closeable2) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                exceptionProcessor.process((Object)new BuildDataCorruptedException(e));
            }
            catch (Exception e) {
                exceptionProcessor.process((Object)e);
            }
        }
    }

    private static <Key, Value> IndexStorage<Key, Value> createIndexStorage(@NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, @NotNull IndexId<Key, Value> indexId, @NotNull File indexDir, boolean readOnly) throws IOException {
        return new MapIndexStorage<Key, Value>(new File(indexDir, indexId.getName()), keyDescriptor, valueExternalizer, 16384, false, true, readOnly){

            public void checkCanceled() {
            }
        };
    }

    class CompilerMapReduceIndex<Key, Value>
    extends MapReduceIndex<Key, Value, Input> {
        CompilerMapReduceIndex(final @NotNull IndexExtension<Key, Value, Input> extension, final File indexDir, boolean readOnly) throws IOException {
            super(extension, CompilerReferenceIndex.createIndexStorage(extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getName(), indexDir, readOnly), (ForwardIndex)(readOnly ? null : new KeyCollectionBasedForwardIndex<Key, Value>(extension){

                @NotNull
                public PersistentHashMap<Integer, Collection<Key>> createMap() throws IOException {
                    IndexId id = this.getIndexExtension().getName();
                    return new PersistentHashMap(new File(indexDir, id.getName() + ".inputs"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new InputIndexDataExternalizer(extension.getKeyDescriptor(), id));
                }
            }));
        }

        public void checkCanceled() {
        }

        protected void requestRebuild(@NotNull Throwable e) {
            CompilerReferenceIndex.this.setRebuildRequestCause(e);
        }
    }
}

