/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs.index;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.CompilerRefDescriptor;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;

public class JavaCompilerIndices {
    public static final int VERSION = 7;
    public static final IndexId<CompilerRef, Integer> BACK_USAGES = IndexId.create((String)"back.refs");
    public static final IndexId<CompilerRef, Collection<CompilerRef>> BACK_HIERARCHY = IndexId.create((String)"back.hierarchy");
    public static final IndexId<CompilerRef, Void> BACK_CLASS_DEF = IndexId.create((String)"back.class.def");
    public static final IndexId<SignatureData, Collection<CompilerRef>> BACK_MEMBER_SIGN = IndexId.create((String)"back.member.sign");
    public static final IndexId<CompilerRef, Collection<CompilerRef>> BACK_CAST = IndexId.create((String)"back.cast");
    public static final IndexId<CompilerRef, Void> IMPLICIT_TO_STRING = IndexId.create((String)"implicit.to.string");

    public static List<IndexExtension<?, ?, CompiledFileData>> getIndices() {
        return Arrays.asList(JavaCompilerIndices.createBackwardClassDefinitionExtension(), JavaCompilerIndices.createBackwardUsagesExtension(), JavaCompilerIndices.createBackwardHierarchyExtension(), JavaCompilerIndices.createBackwardSignatureExtension(), JavaCompilerIndices.createBackwardCastExtension(), JavaCompilerIndices.createImplicitToStringExtension());
    }

    private static IndexExtension<CompilerRef, Void, CompiledFileData> createImplicitToStringExtension() {
        return new IndexExtension<CompilerRef, Void, CompiledFileData>(){

            @NotNull
            public IndexId<CompilerRef, Void> getName() {
                return IMPLICIT_TO_STRING;
            }

            @NotNull
            public DataIndexer<CompilerRef, Void, CompiledFileData> getIndexer() {
                return CompiledFileData::getImplicitToString;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                return CompilerRefDescriptor.INSTANCE;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                return VoidDataExternalizer.INSTANCE;
            }

            public int getVersion() {
                return 0;
            }
        };
    }

    private static IndexExtension<CompilerRef, Collection<CompilerRef>, CompiledFileData> createBackwardCastExtension() {
        return new IndexExtension<CompilerRef, Collection<CompilerRef>, CompiledFileData>(){

            @NotNull
            public IndexId<CompilerRef, Collection<CompilerRef>> getName() {
                return BACK_CAST;
            }

            @NotNull
            public DataIndexer<CompilerRef, Collection<CompilerRef>, CompiledFileData> getIndexer() {
                return CompiledFileData::getCasts;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                return CompilerRefDescriptor.INSTANCE;
            }

            @NotNull
            public DataExternalizer<Collection<CompilerRef>> getValueExternalizer() {
                return JavaCompilerIndices.createCompilerRefSeqExternalizer();
            }

            public int getVersion() {
                return 7;
            }
        };
    }

    private static IndexExtension<CompilerRef, Integer, CompiledFileData> createBackwardUsagesExtension() {
        return new IndexExtension<CompilerRef, Integer, CompiledFileData>(){

            public int getVersion() {
                return 7;
            }

            @NotNull
            public IndexId<CompilerRef, Integer> getName() {
                return BACK_USAGES;
            }

            @NotNull
            public DataIndexer<CompilerRef, Integer, CompiledFileData> getIndexer() {
                return CompiledFileData::getReferences;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                return CompilerRefDescriptor.INSTANCE;
            }

            @NotNull
            public DataExternalizer<Integer> getValueExternalizer() {
                return new UnsignedByteExternalizer();
            }
        };
    }

    private static IndexExtension<CompilerRef, Collection<CompilerRef>, CompiledFileData> createBackwardHierarchyExtension() {
        return new IndexExtension<CompilerRef, Collection<CompilerRef>, CompiledFileData>(){

            public int getVersion() {
                return 7;
            }

            @NotNull
            public IndexId<CompilerRef, Collection<CompilerRef>> getName() {
                return BACK_HIERARCHY;
            }

            @NotNull
            public DataIndexer<CompilerRef, Collection<CompilerRef>, CompiledFileData> getIndexer() {
                return CompiledFileData::getBackwardHierarchy;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                return CompilerRefDescriptor.INSTANCE;
            }

            @NotNull
            public DataExternalizer<Collection<CompilerRef>> getValueExternalizer() {
                return JavaCompilerIndices.createCompilerRefSeqExternalizer();
            }
        };
    }

    private static IndexExtension<CompilerRef, Void, CompiledFileData> createBackwardClassDefinitionExtension() {
        return new IndexExtension<CompilerRef, Void, CompiledFileData>(){

            public int getVersion() {
                return 7;
            }

            @NotNull
            public IndexId<CompilerRef, Void> getName() {
                return BACK_CLASS_DEF;
            }

            @NotNull
            public DataIndexer<CompilerRef, Void, CompiledFileData> getIndexer() {
                return CompiledFileData::getDefinitions;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                return CompilerRefDescriptor.INSTANCE;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                return VoidDataExternalizer.INSTANCE;
            }
        };
    }

    private static IndexExtension<SignatureData, Collection<CompilerRef>, CompiledFileData> createBackwardSignatureExtension() {
        return new IndexExtension<SignatureData, Collection<CompilerRef>, CompiledFileData>(){

            @NotNull
            public IndexId<SignatureData, Collection<CompilerRef>> getName() {
                return BACK_MEMBER_SIGN;
            }

            @NotNull
            public DataIndexer<SignatureData, Collection<CompilerRef>, CompiledFileData> getIndexer() {
                return CompiledFileData::getSignatureData;
            }

            @NotNull
            public KeyDescriptor<SignatureData> getKeyDescriptor() {
                return JavaCompilerIndices.createSignatureDataDescriptor();
            }

            @NotNull
            public DataExternalizer<Collection<CompilerRef>> getValueExternalizer() {
                return JavaCompilerIndices.createCompilerRefSeqExternalizer();
            }

            public int getVersion() {
                return 7;
            }
        };
    }

    @NotNull
    private static DataExternalizer<Collection<CompilerRef>> createCompilerRefSeqExternalizer() {
        return new DataExternalizer<Collection<CompilerRef>>(){

            public void save(@NotNull DataOutput out, Collection<CompilerRef> value) throws IOException {
                DataInputOutputUtilRt.writeSeq((DataOutput)out, value, lightRef -> CompilerRefDescriptor.INSTANCE.save(out, (CompilerRef)lightRef));
            }

            public Collection<CompilerRef> read(@NotNull DataInput in) throws IOException {
                return DataInputOutputUtilRt.readSeq((DataInput)in, () -> CompilerRefDescriptor.INSTANCE.read(in));
            }
        };
    }

    private static KeyDescriptor<SignatureData> createSignatureDataDescriptor() {
        return new KeyDescriptor<SignatureData>(){

            public int getHashCode(SignatureData value) {
                return value.hashCode();
            }

            public boolean isEqual(SignatureData val1, SignatureData val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, SignatureData value) throws IOException {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getRawReturnType());
                out.writeByte(value.getIteratorKind());
                out.writeBoolean(value.isStatic());
            }

            public SignatureData read(@NotNull DataInput in) throws IOException {
                return new SignatureData(DataInputOutputUtil.readINT((DataInput)in), in.readByte(), in.readBoolean());
            }
        };
    }

    private static class UnsignedByteExternalizer
    implements DataExternalizer<Integer> {
        private UnsignedByteExternalizer() {
        }

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            int v = value;
            if (v > 255) {
                v = 255;
            }
            out.writeByte(v);
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            return in.readByte() & 0xFF;
        }
    }
}

