/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.DifferenceImpl;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.RW;

public class ModulePackageRepr
extends Proto {
    private static final DataExternalizer<Integer> INT_EXTERNALIZER = new DataExternalizer<Integer>(){

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            return DataInputOutputUtil.readINT((DataInput)in);
        }
    };
    private final Set<Integer> myModuleNames = new THashSet();

    protected ModulePackageRepr(DependencyContext context, int name, Collection<String> modules) {
        super(0, context.get(null), name, Collections.emptySet());
        for (String module : modules) {
            this.myModuleNames.add(context.get(module));
        }
    }

    protected ModulePackageRepr(DependencyContext context, DataInput in) {
        super(context, in);
        RW.read(INT_EXTERNALIZER, this.myModuleNames, in);
    }

    public Set<Integer> getModuleNames() {
        return Collections.unmodifiableSet(this.myModuleNames);
    }

    public boolean isQualified() {
        return !this.myModuleNames.isEmpty();
    }

    @Override
    public void save(DataOutput out) {
        super.save(out);
        RW.save(this.myModuleNames, INT_EXTERNALIZER, out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name == ((ModulePackageRepr)o).name;
    }

    public int hashCode() {
        return 31 * this.name;
    }

    @Override
    public Diff difference(Proto past) {
        final Difference.Specifier targetModulesDiff = Difference.make(((ModulePackageRepr)past).myModuleNames, this.myModuleNames);
        return new Diff(super.difference(past)){

            @Override
            public Difference.Specifier<Integer, Difference> targetModules() {
                return targetModulesDiff;
            }

            @Override
            public boolean no() {
                return super.no() && this.targetModules().unchanged();
            }
        };
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        StringBuilder sb = new StringBuilder();
        sb.append("Module package: ").append(context.getValue(this.name));
        Set<Integer> moduleNames = this.myModuleNames;
        if (moduleNames != null && !moduleNames.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            for (Integer moduleName : moduleNames) {
                names.add(context.getValue(moduleName));
            }
            Collections.sort(names, String::compareToIgnoreCase);
            sb.append(" to");
            for (String s : names) {
                sb.append(" ").append(s);
            }
        }
        stream.println(sb.toString());
    }

    public static DataExternalizer<ModulePackageRepr> externalizer(final DependencyContext context) {
        return new DataExternalizer<ModulePackageRepr>(){

            public void save(@NotNull DataOutput out, ModulePackageRepr value) {
                value.save(out);
            }

            public ModulePackageRepr read(@NotNull DataInput in) {
                return new ModulePackageRepr(context, in);
            }
        };
    }

    public static abstract class Diff
    extends DifferenceImpl {
        public abstract Difference.Specifier<Integer, Difference> targetModules();

        Diff(@NotNull Difference delegate) {
            super(delegate);
        }
    }
}

