/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileRepr;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.DifferenceImpl;
import org.jetbrains.jps.builders.java.dependencyView.ModulePackageRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRequiresRepr;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class ModuleRepr
extends ClassFileRepr {
    private final int myVersion;
    private final Set<ModuleRequiresRepr> myRequires;
    private final Set<ModulePackageRepr> myExports;

    public ModuleRepr(DependencyContext context, int access, int version, int fileName, int name, Set<ModuleRequiresRepr> requires, Set<ModulePackageRepr> exports, Set<UsageRepr.Usage> usages) {
        super(access, context.get(null), name, Collections.emptySet(), fileName, context, usages);
        this.myVersion = version;
        this.myRequires = requires;
        this.myExports = exports;
        this.updateClassUsages(context, usages);
    }

    public ModuleRepr(DependencyContext context, DataInput in) {
        super(context, in);
        try {
            this.myVersion = DataInputOutputUtil.readINT((DataInput)in);
            this.myRequires = (Set)RW.read(ModuleRequiresRepr.externalizer(context), new THashSet(), in);
            this.myExports = (Set)RW.read(ModulePackageRepr.externalizer(context), new THashSet(), in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public int getVersion() {
        return this.myVersion;
    }

    public Set<ModuleRequiresRepr> getRequires() {
        return this.myRequires;
    }

    public Set<ModulePackageRepr> getExports() {
        return this.myExports;
    }

    @Override
    public void save(DataOutput out) {
        super.save(out);
        try {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myVersion);
            RW.save(this.myRequires, out);
            RW.save(this.myExports, out);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    protected void updateClassUsages(DependencyContext context, Set<UsageRepr.Usage> s) {
        for (ModuleRequiresRepr require : this.myRequires) {
            if (require.name == this.name) continue;
            s.add(UsageRepr.createModuleUsage(context, require.name));
        }
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        super.toStream(context, stream);
        stream.println("      Requires:");
        ModuleRepr.streamProtoCollection(context, stream, this.myRequires);
        stream.println("      End Of Requires");
        stream.println("      Exports:");
        ModuleRepr.streamProtoCollection(context, stream, this.myExports);
        stream.println("      End Of Exports");
    }

    private static <T extends Proto> void streamProtoCollection(DependencyContext context, PrintStream stream, Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(Comparator.comparingInt(o -> o.name));
        for (Proto reqRepr : list) {
            reqRepr.toStream(context, stream);
        }
    }

    public boolean requiresTransitevely(int requirementName) {
        for (ModuleRequiresRepr require : this.myRequires) {
            if (require.name != requirementName) continue;
            return require.isTransitive();
        }
        return false;
    }

    @Override
    public Diff difference(Proto past) {
        Difference delegate = super.difference(past);
        final ModuleRepr pastModule = (ModuleRepr)past;
        final int base = !this.getUsages().equals(pastModule.getUsages()) ? delegate.base() | 0x20 : delegate.base();
        return new Diff(delegate){

            @Override
            public Difference.Specifier<ModuleRequiresRepr, ModuleRequiresRepr.Diff> requires() {
                return Difference.make(pastModule.myRequires, ModuleRepr.this.myRequires);
            }

            @Override
            public Difference.Specifier<ModulePackageRepr, ModulePackageRepr.Diff> exports() {
                return Difference.make(pastModule.myExports, ModuleRepr.this.myExports);
            }

            @Override
            public boolean versionChanged() {
                return pastModule.getVersion() != ModuleRepr.this.myVersion;
            }

            @Override
            public int base() {
                return base;
            }
        };
    }

    public static DataExternalizer<ModuleRepr> externalizer(final DependencyContext context) {
        return new DataExternalizer<ModuleRepr>(){

            public void save(@NotNull DataOutput out, ModuleRepr value) throws IOException {
                value.save(out);
            }

            public ModuleRepr read(@NotNull DataInput in) throws IOException {
                return new ModuleRepr(context, in);
            }
        };
    }

    public static abstract class Diff
    extends DifferenceImpl {
        Diff(@NotNull Difference delegate) {
            super(delegate);
        }

        public abstract Difference.Specifier<ModuleRequiresRepr, ModuleRequiresRepr.Diff> requires();

        public abstract Difference.Specifier<ModulePackageRepr, ModulePackageRepr.Diff> exports();

        public abstract boolean versionChanged();

        @Override
        public boolean no() {
            return this.base() == 0 && this.requires().unchanged() && this.exports().unchanged() && !this.versionChanged();
        }
    }
}

