/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.containers.SLRUCache;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.CollectionFactory;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class ObjectObjectPersistentMultiMaplet<K, V>
extends ObjectObjectMultiMaplet<K, V> {
    private static final Collection NULL_COLLECTION = Collections.emptySet();
    private static final int CACHE_SIZE = 128;
    private final PersistentHashMap<K, Collection<V>> myMap;
    private final DataExternalizer<V> myValueExternalizer;
    private final SLRUCache<K, Collection> myCache;

    public ObjectObjectPersistentMultiMaplet(File file, KeyDescriptor<K> keyExternalizer, DataExternalizer<V> valueExternalizer, CollectionFactory<V> collectionFactory) throws IOException {
        this.myValueExternalizer = valueExternalizer;
        this.myMap = new PersistentHashMap(file, keyExternalizer, new CollectionDataExternalizer<V>(valueExternalizer, collectionFactory));
        this.myCache = new SLRUCache<K, Collection>(128, 128, (EqualityPolicy)keyExternalizer){

            @NotNull
            public Collection createValue(K key) {
                try {
                    Collection collection = (Collection)ObjectObjectPersistentMultiMaplet.this.myMap.get(key);
                    return collection == null ? NULL_COLLECTION : collection;
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            }
        };
    }

    @Override
    public boolean containsKey(K key) {
        try {
            return this.myMap.containsMapping(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public Collection<V> get(K key) {
        Collection collection = (Collection)this.myCache.get(key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(K key, Collection<V> value) {
        try {
            this.myCache.remove(key);
            if (value == null || value.isEmpty()) {
                this.myMap.remove(key);
            } else {
                this.myMap.put(key, value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(K key, final Collection<V> value) {
        try {
            this.myCache.remove(key);
            this.myMap.appendData(key, new PersistentHashMap.ValueDataAppender(){

                public void append(DataOutput out) throws IOException {
                    for (Object v : value) {
                        ObjectObjectPersistentMultiMaplet.this.myValueExternalizer.save(out, v);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(K key, V value) {
        this.put(key, (V)Collections.singleton(value));
    }

    @Override
    public void removeAll(K key, Collection<V> values) {
        try {
            Collection collection = (Collection)this.myCache.get(key);
            if (collection != NULL_COLLECTION && collection.removeAll(values)) {
                this.myCache.remove(key);
                if (collection.isEmpty()) {
                    this.myMap.remove(key);
                } else {
                    this.myMap.put(key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(K key, V value) {
        try {
            Collection collection = (Collection)this.myCache.get(key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.myCache.remove(key);
                if (collection.isEmpty()) {
                    this.myMap.remove(key);
                } else {
                    this.myMap.put(key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(K key) {
        try {
            this.myCache.remove(key);
            this.myMap.remove(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(ObjectObjectMultiMaplet<K, V> m) {
        m.forEachEntry(new TObjectObjectProcedure<K, Collection<V>>(){

            public boolean execute(K key, Collection<V> value) {
                ObjectObjectPersistentMultiMaplet.this.put(key, value);
                return true;
            }
        });
    }

    @Override
    public void replaceAll(ObjectObjectMultiMaplet<K, V> m) {
        m.forEachEntry(new TObjectObjectProcedure<K, Collection<V>>(){

            public boolean execute(K key, Collection<V> value) {
                ObjectObjectPersistentMultiMaplet.this.replace(key, value);
                return true;
            }
        });
    }

    @Override
    public void close() {
        try {
            this.myCache.clear();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.myMap.isDirty()) {
                this.myMap.dropMemoryCaches();
            }
        } else {
            this.myMap.force();
        }
    }

    @Override
    public void forEachEntry(TObjectObjectProcedure<K, Collection<V>> procedure) {
        try {
            this.myMap.processKeysWithExistingMapping(key -> {
                try {
                    return procedure.execute(key, this.myMap.get(key));
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static class CollectionDataExternalizer<V>
    implements DataExternalizer<Collection<V>> {
        private final DataExternalizer<V> myElementExternalizer;
        private final CollectionFactory<V> myCollectionFactory;

        CollectionDataExternalizer(DataExternalizer<V> elementExternalizer, CollectionFactory<V> collectionFactory) {
            this.myElementExternalizer = elementExternalizer;
            this.myCollectionFactory = collectionFactory;
        }

        public void save(@NotNull DataOutput out, Collection<V> value) throws IOException {
            for (V x : value) {
                this.myElementExternalizer.save(out, x);
            }
        }

        public Collection<V> read(@NotNull DataInput in) throws IOException {
            Collection<V> result = this.myCollectionFactory.create();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(this.myElementExternalizer.read(in));
            }
            return result;
        }
    }
}

