/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.DataOutputStream;
import io.netty.channel.Channel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.api.BasicFuture;
import org.jetbrains.jps.api.BuildType;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.ModuleInducedTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.JpsModelLoaderImpl;
import org.jetbrains.jps.cmdline.PreloadedData;
import org.jetbrains.jps.cmdline.ProfilingHelper;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.RebuildRequestedException;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.BuilderStatisticsMessage;
import org.jetbrains.jps.incremental.messages.BuildingTargetProgressMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.CustomBuilderMessage;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.TimestampStorage;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.service.SharedThreadPool;

final class BuildSession
implements Runnable,
CanceledStatus {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.cmdline.BuildSession");
    public static final String FS_STATE_FILE = "fs_state.dat";
    private static final Boolean REPORT_BUILD_STATISTICS = Boolean.valueOf(System.getProperty("jps.report.build.statistics", "false"));
    private final UUID mySessionId;
    private final Channel myChannel;
    @Nullable
    private final PreloadedData myPreloadedData;
    private volatile boolean myCanceled;
    private final String myProjectPath;
    @Nullable
    private CmdlineRemoteProto.Message.ControllerMessage.FSEvent myInitialFSDelta;
    private final EventsProcessor myEventsProcessor = new EventsProcessor();
    private volatile long myLastEventOrdinal;
    private volatile ProjectDescriptor myProjectDescriptor;
    private final Map<Pair<String, String>, ConstantSearchFuture> mySearchTasks = Collections.synchronizedMap(new HashMap());
    private final ConstantSearch myConstantSearch = new ConstantSearch();
    @NotNull
    private final BuildRunner myBuildRunner;
    private final boolean myForceModelLoading;
    private final BuildType myBuildType;
    private final List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> myScopes;
    private final boolean myLoadUnloadedModules;

    BuildSession(UUID sessionId, Channel channel, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage params, @Nullable CmdlineRemoteProto.Message.ControllerMessage.FSEvent delta, @Nullable PreloadedData preloaded) {
        this.mySessionId = sessionId;
        this.myChannel = channel;
        CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals = params.getGlobalSettings();
        this.myProjectPath = FileUtil.toCanonicalPath((String)params.getProjectId());
        String globalOptionsPath = FileUtil.toCanonicalPath((String)globals.getGlobalOptionsPath());
        this.myBuildType = BuildSession.convertCompileType(params.getBuildType());
        this.myScopes = params.getScopeList();
        List<String> filePaths = params.getFilePathList();
        HashMap<String, String> builderParams = new HashMap<String, String>();
        for (CmdlineRemoteProto.Message.KeyValuePair pair : params.getBuilderParameterList()) {
            builderParams.put(pair.getKey(), pair.getValue());
        }
        this.myInitialFSDelta = delta;
        this.myLoadUnloadedModules = Boolean.parseBoolean((String)builderParams.get("load_unloaded_modules"));
        if (this.myLoadUnloadedModules && preloaded != null) {
            this.myPreloadedData = null;
            ProjectDescriptor projectDescriptor = preloaded.getProjectDescriptor();
            if (projectDescriptor != null) {
                projectDescriptor.release();
                preloaded.setProjectDescriptor(null);
            }
        } else {
            this.myPreloadedData = preloaded;
        }
        this.myBuildRunner = this.myPreloadedData == null || this.myPreloadedData.getRunner() == null ? new BuildRunner(new JpsModelLoaderImpl(this.myProjectPath, globalOptionsPath, this.myLoadUnloadedModules, null)) : this.myPreloadedData.getRunner();
        this.myBuildRunner.setFilePaths(filePaths);
        this.myBuildRunner.setBuilderParams(builderParams);
        this.myForceModelLoading = Boolean.parseBoolean((String)builderParams.get("_force_model_loading"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LowMemoryWatcherManager memWatcher = new LowMemoryWatcherManager((Executor)SharedThreadPool.getInstance());
        Throwable error = null;
        final Ref hasErrors = new Ref((Object)false);
        final Ref doneSomething = new Ref((Object)false);
        try {
            ProfilingHelper profilingHelper = null;
            if (Utils.IS_PROFILING_MODE) {
                profilingHelper = new ProfilingHelper();
                profilingHelper.startProfiling();
            }
            this.runBuild(new MessageHandler(){

                @Override
                public void processMessage(BuildMessage buildMessage) {
                    CmdlineRemoteProto.Message.BuilderMessage response;
                    if (buildMessage instanceof FileGeneratedEvent) {
                        Collection<Pair<String, String>> paths = ((FileGeneratedEvent)buildMessage).getPaths();
                        response = !paths.isEmpty() ? CmdlineProtoUtil.createFileGeneratedEvent(paths) : null;
                    } else if (buildMessage instanceof DoneSomethingNotification) {
                        doneSomething.set((Object)true);
                        response = null;
                    } else if (buildMessage instanceof CompilerMessage) {
                        doneSomething.set((Object)true);
                        CompilerMessage compilerMessage = (CompilerMessage)buildMessage;
                        String compilerName = compilerMessage.getCompilerName();
                        String text = !StringUtil.isEmptyOrSpaces((String)compilerName) ? compilerName + ": " + compilerMessage.getMessageText() : compilerMessage.getMessageText();
                        BuildMessage.Kind kind = compilerMessage.getKind();
                        if (kind == BuildMessage.Kind.ERROR) {
                            hasErrors.set((Object)true);
                        }
                        response = CmdlineProtoUtil.createCompileMessage(kind, text, compilerMessage.getSourcePath(), compilerMessage.getProblemBeginOffset(), compilerMessage.getProblemEndOffset(), compilerMessage.getProblemLocationOffset(), compilerMessage.getLine(), compilerMessage.getColumn(), -1.0f);
                    } else if (buildMessage instanceof CustomBuilderMessage) {
                        CustomBuilderMessage builderMessage = (CustomBuilderMessage)buildMessage;
                        response = CmdlineProtoUtil.createCustomBuilderMessage(builderMessage.getBuilderId(), builderMessage.getMessageType(), builderMessage.getMessageText());
                    } else if (buildMessage instanceof BuilderStatisticsMessage) {
                        boolean worthReporting;
                        BuilderStatisticsMessage message = (BuilderStatisticsMessage)buildMessage;
                        boolean bl = worthReporting = message.getNumberOfProcessedSources() != 0 || message.getElapsedTimeMs() > 50L;
                        if (worthReporting) {
                            LOG.info(message.getMessageText());
                        }
                        response = worthReporting && REPORT_BUILD_STATISTICS != false ? CmdlineProtoUtil.createCompileMessage(BuildMessage.Kind.JPS_INFO, message.getMessageText(), null, -1L, -1L, -1L, -1L, -1L, -1.0f) : null;
                    } else if (!(buildMessage instanceof BuildingTargetProgressMessage)) {
                        float done = -1.0f;
                        if (buildMessage instanceof ProgressMessage) {
                            done = ((ProgressMessage)buildMessage).getDone();
                        }
                        response = CmdlineProtoUtil.createCompileProgressMessageResponse(buildMessage.getMessageText(), done);
                    } else {
                        response = null;
                    }
                    if (response != null) {
                        BuildSession.this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(BuildSession.this.mySessionId, response));
                    }
                }
            }, this);
            if (profilingHelper != null) {
                profilingHelper.stopProfiling();
            }
        }
        catch (Throwable e) {
            LOG.info(e);
            error = e;
        }
        finally {
            this.finishBuild(error, (Boolean)hasErrors.get(), (Boolean)doneSomething.get());
            Disposer.dispose((Disposable)memWatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(MessageHandler msgHandler, CanceledStatus cs) throws Throwable {
        DataInputStream fsStateStream;
        boolean storageFilesAbsent;
        File dataStorageRoot = Utils.getDataStorageRoot(this.myProjectPath);
        if (dataStorageRoot == null) {
            msgHandler.processMessage(new CompilerMessage("build", BuildMessage.Kind.ERROR, "Cannot determine build data storage root for project " + this.myProjectPath));
            return;
        }
        boolean bl = storageFilesAbsent = !dataStorageRoot.exists() || !new File(dataStorageRoot, FS_STATE_FILE).exists();
        if (storageFilesAbsent) {
            this.myBuildRunner.setForceCleanCaches(true);
        }
        ProjectDescriptor preloadedProject = this.myPreloadedData != null ? this.myPreloadedData.getProjectDescriptor() : null;
        DataInputStream dataInputStream = fsStateStream = storageFilesAbsent || preloadedProject != null || this.myLoadUnloadedModules || this.myInitialFSDelta == null ? null : BuildSession.createFSDataStream(dataStorageRoot, this.myInitialFSDelta.getOrdinal());
        if (fsStateStream != null || this.myPreloadedData != null) {
            boolean hasWorkToDoWithModules;
            boolean hasWorkFlag = fsStateStream != null ? fsStateStream.readBoolean() : this.myPreloadedData.hasWorkToDo();
            boolean bl2 = hasWorkToDoWithModules = hasWorkFlag || this.myInitialFSDelta == null;
            if (!(this.myForceModelLoading || this.myBuildType != BuildType.BUILD && this.myBuildType != BuildType.UP_TO_DATE_CHECK || hasWorkToDoWithModules || !BuildSession.scopeContainsModulesOnlyForIncrementalMake(this.myScopes) || BuildSession.containsChanges(this.myInitialFSDelta))) {
                DataInputStream storedFsData;
                if (this.myPreloadedData != null) {
                    storedFsData = BuildSession.createFSDataStream(dataStorageRoot, this.myInitialFSDelta.getOrdinal());
                    if (storedFsData != null) {
                        storedFsData.readBoolean();
                    }
                } else {
                    storedFsData = fsStateStream;
                }
                if (storedFsData != null) {
                    BuildSession.updateFsStateOnDisk(dataStorageRoot, storedFsData, this.myInitialFSDelta.getOrdinal());
                    LOG.info("No changes found since last build. Exiting.");
                    if (preloadedProject != null) {
                        preloadedProject.release();
                    }
                    return;
                }
            }
        }
        BuildFSState fsState = preloadedProject != null ? preloadedProject.fsState : new BuildFSState(false);
        try {
            ProjectDescriptor pd;
            if (preloadedProject != null) {
                pd = preloadedProject;
                List<BuildMessage> preloadMessages = this.myPreloadedData.getLoadMessages();
                if (!preloadMessages.isEmpty()) {
                    for (BuildMessage message : preloadMessages) {
                        msgHandler.processMessage(message);
                    }
                }
                if (this.myInitialFSDelta == null || this.myPreloadedData.getFsEventOrdinal() + 1L != this.myInitialFSDelta.getOrdinal()) {
                    fsState.clearAll();
                } else {
                    try {
                        BuildSession.applyFSEvent(pd, this.myInitialFSDelta, false);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        fsState.clearAll();
                    }
                }
            } else {
                pd = this.myBuildRunner.load(msgHandler, dataStorageRoot, fsState);
                TimingLog.LOG.debug("Project descriptor loaded");
                if (fsStateStream != null) {
                    try {
                        fsState.load(fsStateStream, pd.getModel(), pd.getBuildRootIndex());
                        BuildSession.applyFSEvent(pd, this.myInitialFSDelta, false);
                        TimingLog.LOG.debug("FS Delta loaded");
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        fsState.clearAll();
                    }
                }
            }
            this.myProjectDescriptor = pd;
            this.myLastEventOrdinal = this.myInitialFSDelta != null ? this.myInitialFSDelta.getOrdinal() : 0L;
            this.myInitialFSDelta = null;
            this.myEventsProcessor.startProcessing();
            this.myBuildRunner.runBuild(pd, cs, this.myConstantSearch, msgHandler, this.myBuildType, this.myScopes, false);
            TimingLog.LOG.debug("Build finished");
        }
        finally {
            this.saveData(fsState, dataStorageRoot);
        }
    }

    private static boolean scopeContainsModulesOnlyForIncrementalMake(List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        TargetTypeRegistry typeRegistry = null;
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            BuildTargetType<?> targetType;
            if (scope.getForceBuild()) {
                return false;
            }
            String typeId = scope.getTypeId();
            if (BuildSession.isJavaModuleBuildType(typeId)) continue;
            if (typeRegistry == null) {
                typeRegistry = TargetTypeRegistry.getInstance();
            }
            if ((targetType = typeRegistry.getTargetType(typeId)) == null || targetType instanceof ModuleInducedTargetType) continue;
            return false;
        }
        return true;
    }

    private static boolean isJavaModuleBuildType(String typeId) {
        for (JavaModuleBuildTargetType moduleBuildTargetType : JavaModuleBuildTargetType.ALL_TYPES) {
            if (!moduleBuildTargetType.getTypeId().equals(typeId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(BuildFSState fsState, File dataStorageRoot) {
        boolean wasInterrupted = Thread.interrupted();
        try {
            this.saveFsState(dataStorageRoot, fsState);
            ProjectDescriptor pd = this.myProjectDescriptor;
            if (pd != null) {
                pd.release();
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void processFSEvent(CmdlineRemoteProto.Message.ControllerMessage.FSEvent event) {
        this.myEventsProcessor.execute(() -> {
            try {
                BuildSession.applyFSEvent(this.myProjectDescriptor, event, true);
                ++this.myLastEventOrdinal;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public void processConstantSearchResult(CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult result) {
        ConstantSearchFuture future = this.mySearchTasks.remove(Pair.create((Object)result.getOwnerClassName(), (Object)result.getFieldName()));
        if (future != null) {
            if (result.getIsSuccess()) {
                List<String> paths = result.getPathList();
                ArrayList<File> files = new ArrayList<File>(paths.size());
                for (String path : paths) {
                    files.add(new File(path));
                }
                future.setResult(files);
                LOG.debug("Constant search result: " + files.size() + " affected files found");
            } else {
                future.setDone();
                LOG.debug("Constant search failed");
            }
        }
    }

    private static void applyFSEvent(ProjectDescriptor pd, @Nullable CmdlineRemoteProto.Message.ControllerMessage.FSEvent event, boolean saveEventStamp) throws IOException {
        File file;
        if (event == null) {
            return;
        }
        TimestampStorage timestamps = pd.timestamps.getStorage();
        boolean cacheCleared = false;
        for (String deleted : event.getDeletedPathsList()) {
            file = new File(deleted);
            Collection descriptor = pd.getBuildRootIndex().findAllParentDescriptors(file, null, null);
            if (!descriptor.isEmpty()) {
                if (!cacheCleared) {
                    cacheCleared = true;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Applying deleted path from fs event: " + file.getPath());
                }
                for (BuildRootDescriptor rootDescriptor : descriptor) {
                    pd.fsState.registerDeleted(null, rootDescriptor.getTarget(), file, timestamps);
                }
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping deleted path: " + file.getPath());
        }
        for (String changed : event.getChangedPathsList()) {
            file = new File(changed);
            Collection descriptors = pd.getBuildRootIndex().findAllParentDescriptors(file, null, null);
            if (!descriptors.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Applying dirty path from fs event: " + changed);
                }
                long fileStamp = -1L;
                for (BuildRootDescriptor descriptor : descriptors) {
                    long stamp;
                    if (descriptor.isGenerated()) continue;
                    if (fileStamp == -1L) {
                        fileStamp = FSOperations.lastModified(file);
                    }
                    if ((stamp = timestamps.getStamp(file, descriptor.getTarget())) != fileStamp) {
                        if (!cacheCleared) {
                            cacheCleared = true;
                        }
                        pd.fsState.markDirty(null, file, descriptor, timestamps, saveEventStamp);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(descriptor.getTarget() + ": Path considered up-to-date: " + changed + "; timestamp= " + stamp);
                }
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping dirty path: " + file.getPath());
        }
    }

    private static void updateFsStateOnDisk(File dataStorageRoot, DataInputStream original, long ordinal) {
        File file = new File(dataStorageRoot, FS_STATE_FILE);
        try {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream((OutputStream)bytes);){
                int b;
                out.writeInt(3);
                out.writeLong(ordinal);
                out.writeBoolean(false);
                while ((b = original.read()) != -1) {
                    out.write(b);
                }
            }
            BuildSession.saveOnDisk(bytes, file);
        }
        catch (Throwable e) {
            LOG.error(e);
            FileUtil.delete((File)file);
        }
    }

    private void saveFsState(File dataStorageRoot, BuildFSState state) {
        ProjectDescriptor pd = this.myProjectDescriptor;
        File file = new File(dataStorageRoot, FS_STATE_FILE);
        try {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream((OutputStream)bytes);){
                out.writeInt(3);
                out.writeLong(this.myLastEventOrdinal);
                out.writeBoolean(BuildSession.hasWorkToDo(state, pd));
                state.save((DataOutput)out);
            }
            BuildSession.saveOnDisk(bytes, file);
        }
        catch (Throwable e) {
            LOG.error(e);
            FileUtil.delete((File)file);
        }
    }

    private static boolean hasWorkToDo(BuildFSState state, @Nullable ProjectDescriptor pd) {
        if (pd == null) {
            return true;
        }
        BuildTargetIndex targetIndex = pd.getBuildTargetIndex();
        for (JpsModule module : pd.getProject().getModules()) {
            for (ModuleBasedTarget<?> target : targetIndex.getModuleBasedTargets(module, BuildTargetRegistry.ModuleTargetSelector.ALL)) {
                if (pd.getBuildTargetIndex().isDummy(target) || !state.hasWorkToDo(target)) continue;
                return true;
            }
        }
        return false;
    }

    private static void saveOnDisk(BufferExposingByteArrayOutputStream bytes, File file) throws IOException {
        try (FileOutputStream fos = BuildSession.writeOrCreate(file);){
            fos.write(bytes.getInternalBuffer(), 0, bytes.size());
        }
    }

    @NotNull
    private static FileOutputStream writeOrCreate(@NotNull File file) throws FileNotFoundException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ignored) {
            FileUtil.createIfDoesntExist((File)file);
        }
        if (fos == null) {
            fos = new FileOutputStream(file);
        }
        return fos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static DataInputStream createFSDataStream(File dataStorageRoot, long currentEventOrdinal) {
        File file = new File(dataStorageRoot, FS_STATE_FILE);
        try (FileInputStream fs2 = new FileInputStream(file);){
            byte[] bytes = FileUtil.loadBytes((InputStream)fs2, (int)((int)file.length()));
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            int version = in.readInt();
            if (version != 3) {
                DataInputStream dataInputStream = null;
                return dataInputStream;
            }
            long savedOrdinal = in.readLong();
            if (savedOrdinal + 1L != currentEventOrdinal) {
                DataInputStream dataInputStream = null;
                return dataInputStream;
            }
            DataInputStream dataInputStream = in;
            return dataInputStream;
        }
        catch (FileNotFoundException fs2) {
            return null;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    private static boolean containsChanges(CmdlineRemoteProto.Message.ControllerMessage.FSEvent event) {
        return event.getChangedPathsCount() != 0 || event.getDeletedPathsCount() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void finishBuild(Throwable error, boolean hadBuildErrors, boolean doneSomething) {
        block34: {
            CmdlineRemoteProto.Message lastMessage;
            block32: {
                lastMessage = null;
                if (error instanceof CannotLoadJpsModelException) {
                    String text = "Failed to load project configuration: " + StringUtil.decapitalize((String)error.getMessage());
                    String path = ((CannotLoadJpsModelException)error).getFile().getAbsolutePath();
                    lastMessage = CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createCompileMessage(BuildMessage.Kind.ERROR, text, path, -1L, -1L, -1L, -1L, -1L, -1.0f));
                    break block32;
                }
                if (error != null) {
                    Throwable cause = error.getCause();
                    if (cause == null) {
                        cause = error;
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try (PrintStream stream = new PrintStream(out);){
                        cause.printStackTrace(stream);
                    }
                    StringBuilder messageText = new StringBuilder();
                    messageText.append("Internal error: (").append(cause.getClass().getName()).append(") ").append(cause.getMessage());
                    String trace = out.toString();
                    if (!trace.isEmpty()) {
                        messageText.append("\n").append(trace);
                    }
                    if (error instanceof RebuildRequestedException || cause instanceof IOException) {
                        messageText.append("\n").append("Please perform full project rebuild (Build | Rebuild Project)");
                    }
                    lastMessage = CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createFailure(messageText.toString(), cause));
                    break block32;
                }
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.SUCCESS;
                if (this.myCanceled) {
                    status = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED;
                } else if (hadBuildErrors) {
                    status = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.ERRORS;
                } else if (!doneSomething) {
                    status = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.UP_TO_DATE;
                }
                lastMessage = CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createBuildCompletedEvent("build completed", status));
            }
            try {
                this.myChannel.writeAndFlush((Object)lastMessage).await();
            }
            catch (InterruptedException e) {
                LOG.info((Throwable)e);
            }
            break block34;
            catch (Throwable e) {
                try {
                    lastMessage = CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createFailure(e.getMessage(), e));
                }
                catch (Throwable throwable) {
                    try {
                        this.myChannel.writeAndFlush(lastMessage).await();
                    }
                    catch (InterruptedException e2) {
                        LOG.info((Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    this.myChannel.writeAndFlush((Object)lastMessage).await();
                }
                catch (InterruptedException e3) {
                    LOG.info((Throwable)e3);
                }
            }
        }
    }

    public void cancel() {
        this.myCanceled = true;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    private static BuildType convertCompileType(CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.Type compileType) {
        switch (compileType) {
            case CLEAN: {
                return BuildType.CLEAN;
            }
            case BUILD: {
                return BuildType.BUILD;
            }
            case UP_TO_DATE_CHECK: {
                return BuildType.UP_TO_DATE_CHECK;
            }
        }
        return BuildType.BUILD;
    }

    private static class ConstantSearchFuture
    extends BasicFuture<Callbacks.ConstantAffection> {
        private volatile Callbacks.ConstantAffection myResult = Callbacks.ConstantAffection.EMPTY;
        private final CanceledStatus myCanceledStatus;

        private ConstantSearchFuture(CanceledStatus canceledStatus) {
            this.myCanceledStatus = canceledStatus;
        }

        public void setResult(Collection<File> affectedFiles) {
            this.myResult = new Callbacks.ConstantAffection(affectedFiles);
            this.setDone();
        }

        @Override
        public Callbacks.ConstantAffection get() throws InterruptedException, ExecutionException {
            while (true) {
                try {
                    return this.get(300L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    if (!this.myCanceledStatus.isCanceled()) continue;
                    return this.myResult;
                }
                break;
            }
        }

        @Override
        public Callbacks.ConstantAffection get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            super.get(timeout, unit);
            return this.myResult;
        }
    }

    private class ConstantSearch
    implements Callbacks.ConstantAffectionResolver {
        private ConstantSearch() {
        }

        @Override
        @Nullable
        public Future<Callbacks.ConstantAffection> request(String ownerClassName, String fieldName, int accessFlags, boolean fieldRemoved, boolean accessChanged) {
            CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask.Builder task = CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask.newBuilder();
            task.setOwnerClassName(ownerClassName);
            task.setFieldName(fieldName);
            task.setAccessFlags(accessFlags);
            task.setIsAccessChanged(accessChanged);
            task.setIsFieldRemoved(fieldRemoved);
            ConstantSearchFuture future = new ConstantSearchFuture(BuildSession.this);
            ConstantSearchFuture prev = BuildSession.this.mySearchTasks.put(Pair.create((Object)ownerClassName, (Object)fieldName), future);
            if (prev != null) {
                prev.setDone();
            }
            BuildSession.this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(BuildSession.this.mySessionId, (CmdlineRemoteProto.Message.BuilderMessage)CmdlineRemoteProto.Message.BuilderMessage.newBuilder().setType(CmdlineRemoteProto.Message.BuilderMessage.Type.CONSTANT_SEARCH_TASK).setConstantSearchTask((CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask)task.build()).build()));
            return future;
        }
    }

    private static class EventsProcessor {
        private final Semaphore myProcessingEnabled = new Semaphore();
        private final Executor myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildSession.EventsProcessor.EventsProcessor Pool", (Executor)SharedThreadPool.getInstance());

        private EventsProcessor() {
            this.myProcessingEnabled.down();
            this.execute(() -> this.myProcessingEnabled.waitFor());
        }

        private void startProcessing() {
            this.myProcessingEnabled.up();
        }

        public void execute(@NotNull Runnable task) {
            this.myExecutorService.execute(task);
        }
    }
}

