/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.logging.BuildLoggingManager;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.FSCache;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.ProjectTimestamps;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;

public final class ProjectDescriptor {
    private final JpsProject myProject;
    private final JpsModel myModel;
    public final BuildFSState fsState;
    public final ProjectTimestamps timestamps;
    public final BuildDataManager dataManager;
    private final BuildLoggingManager myLoggingManager;
    private final BuildTargetsState myTargetsState;
    private final ModuleExcludeIndex myModuleExcludeIndex;
    private int myUseCounter = 1;
    private final Set<JpsSdk<?>> myProjectJavaSdks;
    private final CompilerEncodingConfiguration myEncodingConfiguration;
    private final BuildRootIndex myBuildRootIndex;
    private final BuildTargetIndex myBuildTargetIndex;
    private final IgnoredFileIndex myIgnoredFileIndex;
    private FSCache myFSCache = FSCache.NO_CACHE;

    public ProjectDescriptor(JpsModel model, BuildFSState fsState, ProjectTimestamps timestamps, BuildDataManager dataManager, BuildLoggingManager loggingManager, ModuleExcludeIndex moduleExcludeIndex, BuildTargetsState targetsState, BuildTargetIndex buildTargetIndex, BuildRootIndex buildRootIndex, IgnoredFileIndex ignoredFileIndex) {
        this.myModel = model;
        this.myIgnoredFileIndex = ignoredFileIndex;
        this.myProject = model.getProject();
        this.fsState = fsState;
        this.timestamps = timestamps;
        this.dataManager = dataManager;
        this.myBuildTargetIndex = buildTargetIndex;
        this.myBuildRootIndex = buildRootIndex;
        this.myLoggingManager = loggingManager;
        this.myModuleExcludeIndex = moduleExcludeIndex;
        this.myProjectJavaSdks = new HashSet();
        this.myEncodingConfiguration = new CompilerEncodingConfiguration(model, buildRootIndex);
        for (JpsModule module : this.myProject.getModules()) {
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
            if (sdk == null || this.myProjectJavaSdks.contains(sdk) || sdk.getVersionString() == null || sdk.getHomePath() == null) continue;
            this.myProjectJavaSdks.add(sdk);
        }
        this.myTargetsState = targetsState;
    }

    @NotNull
    public FSCache getFSCache() {
        return FSCache.NO_CACHE;
    }

    public void setFSCache(FSCache cache) {
        this.myFSCache = cache == null ? FSCache.NO_CACHE : cache;
    }

    public BuildRootIndex getBuildRootIndex() {
        return this.myBuildRootIndex;
    }

    public BuildTargetIndex getBuildTargetIndex() {
        return this.myBuildTargetIndex;
    }

    public IgnoredFileIndex getIgnoredFileIndex() {
        return this.myIgnoredFileIndex;
    }

    public BuildTargetsState getTargetsState() {
        return this.myTargetsState;
    }

    public CompilerEncodingConfiguration getEncodingConfiguration() {
        return this.myEncodingConfiguration;
    }

    public Set<JpsSdk<?>> getProjectJavaSdks() {
        return this.myProjectJavaSdks;
    }

    public BuildLoggingManager getLoggingManager() {
        return this.myLoggingManager;
    }

    public synchronized void incUsageCounter() {
        ++this.myUseCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean shouldClose;
        ProjectDescriptor projectDescriptor = this;
        synchronized (projectDescriptor) {
            --this.myUseCounter;
            shouldClose = this.myUseCounter == 0;
        }
        if (shouldClose) {
            try {
                this.timestamps.close();
            }
            finally {
                try {
                    this.dataManager.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public ModuleExcludeIndex getModuleExcludeIndex() {
        return this.myModuleExcludeIndex;
    }

    public JpsModel getModel() {
        return this.myModel;
    }

    public JpsProject getProject() {
        return this.myProject;
    }
}

