/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;

class CompositeConstantResolver
implements Callbacks.ConstantAffectionResolver {
    private final Collection<? extends Callbacks.ConstantAffectionResolver> myResolvers;

    CompositeConstantResolver(@NotNull Collection<? extends Callbacks.ConstantAffectionResolver> resolvers) {
        this.myResolvers = resolvers;
    }

    @Override
    public Future<Callbacks.ConstantAffection> request(String ownerClassName, String fieldName, int accessFlags, boolean fieldRemoved, boolean accessChanged) {
        SmartList futures = new SmartList();
        for (Callbacks.ConstantAffectionResolver constantAffectionResolver : this.myResolvers) {
            futures.add(constantAffectionResolver.request(ownerClassName, fieldName, accessFlags, fieldRemoved, accessChanged));
        }
        return new Future<Callbacks.ConstantAffection>((List)futures){
            final /* synthetic */ List val$futures;
            {
                this.val$futures = list;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean res = !this.val$futures.isEmpty();
                for (Future future : this.val$futures) {
                    res &= future.cancel(mayInterruptIfRunning);
                }
                return res;
            }

            @Override
            public boolean isCancelled() {
                for (Future future : this.val$futures) {
                    if (future.isCancelled()) continue;
                    return false;
                }
                return !this.val$futures.isEmpty();
            }

            @Override
            public boolean isDone() {
                for (Future future : this.val$futures) {
                    if (future.isDone()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Callbacks.ConstantAffection get() throws InterruptedException, ExecutionException {
                SmartList results = new SmartList();
                for (Future future : this.val$futures) {
                    results.add(future.get());
                }
                return Callbacks.ConstantAffection.compose((Collection<? extends Callbacks.ConstantAffection>)results);
            }

            @Override
            public Callbacks.ConstantAffection get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                SmartList results = new SmartList();
                for (Future future : this.val$futures) {
                    results.add(future.get(timeout, unit));
                }
                return Callbacks.ConstantAffection.compose((Collection<? extends Callbacks.ConstantAffection>)results);
            }
        };
    }
}

