/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsComplexPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsModuleOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsArtifactUtil {
    public static boolean processPackagingElements(@NotNull JpsPackagingElement element, @NotNull Processor<JpsPackagingElement> processor) {
        return JpsArtifactUtil.processPackagingElements(element, processor, new HashSet<JpsPackagingElement>());
    }

    private static boolean processPackagingElements(@NotNull JpsPackagingElement element, @NotNull Processor<JpsPackagingElement> processor, Set<JpsPackagingElement> processed) {
        block5: {
            block4: {
                if (!processed.add(element)) {
                    return false;
                }
                if (!processor.process((Object)element)) {
                    return false;
                }
                if (!(element instanceof JpsCompositePackagingElement)) break block4;
                for (JpsPackagingElement child : ((JpsCompositePackagingElement)element).getChildren()) {
                    JpsArtifactUtil.processPackagingElements(child, processor, processed);
                }
                break block5;
            }
            if (!(element instanceof JpsComplexPackagingElement)) break block5;
            for (JpsPackagingElement child : ((JpsComplexPackagingElement)element).getSubstitution()) {
                JpsArtifactUtil.processPackagingElements(child, processor, processed);
            }
        }
        return true;
    }

    public static boolean isArchiveName(String name) {
        return name.length() >= 4 && name.charAt(name.length() - 4) == '.' && StringUtil.endsWithIgnoreCase((String)name, (String)"ar");
    }

    public static Set<JpsModule> getModulesIncludedInArtifacts(@NotNull Collection<? extends JpsArtifact> artifacts) {
        THashSet modules = new THashSet();
        for (JpsArtifact jpsArtifact : artifacts) {
            JpsArtifactUtil.processPackagingElements((JpsPackagingElement)jpsArtifact.getRootElement(), (Processor<JpsPackagingElement>)((Processor)arg_0 -> JpsArtifactUtil.lambda$getModulesIncludedInArtifacts$0((Set)modules, arg_0)));
        }
        return modules;
    }

    private static /* synthetic */ boolean lambda$getModulesIncludedInArtifacts$0(Set modules, JpsPackagingElement element) {
        if (element instanceof JpsModuleOutputPackagingElement) {
            ContainerUtil.addIfNotNull((Collection)modules, (Object)((JpsModuleOutputPackagingElement)element).getModuleReference().resolve());
        }
        return true;
    }
}

