/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.java.ExcludedJavaSourceRootProvider;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;

public class AnnotationsExcludedJavaSourceRootProvider
extends ExcludedJavaSourceRootProvider {
    @Override
    public boolean isExcludedFromCompilation(@NotNull JpsModule module, @NotNull JpsModuleSourceRoot root) {
        JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(module.getProject());
        ProcessorConfigProfile profile = compilerConfig.getAnnotationProcessingProfile(module);
        if (!profile.isEnabled()) {
            return false;
        }
        File outputDir = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(module, JavaSourceRootType.TEST_SOURCE == root.getRootType(), profile);
        return outputDir != null && FileUtil.filesEqual((File)outputDir, (File)root.getFile());
    }
}

