/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacFileReferencesRegistrar;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public class ImportReferencesRegistrar
implements JavacFileReferencesRegistrar {
    @Override
    public void initialize() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean onlyImports() {
        return true;
    }

    @Override
    public void registerFile(CompileContext context, String filePath, TObjectIntHashMap<JavacRef> refs, Collection<JavacDef> defs, Collection<JavacTypeCast> casts, Collection<JavacRef> implicitToString) {
        if (refs.isEmpty() || defs.isEmpty()) {
            return;
        }
        HashSet<String> classImports = new HashSet<String>();
        HashSet<String> staticImports = new HashSet<String>();
        for (Object key : refs.keys()) {
            JavacRef ref = (JavacRef)key;
            if (ref instanceof JavacRef.JavacClass) {
                classImports.add(ref.getName());
                JavacRef.ImportProperties props = ref.getImportProperties();
                if (props == null || !props.isStatic() || !props.isOnDemand()) continue;
                staticImports.add(ref.getName() + ".*");
                continue;
            }
            if (!(ref instanceof JavacRef.JavacField) && !(ref instanceof JavacRef.JavacMethod)) continue;
            staticImports.add(ref.getOwnerName() + "." + ref.getName());
        }
        ArrayList<String> definedClasses = new ArrayList<String>();
        for (JavacDef def : defs) {
            JavacRef element;
            if (!(def instanceof JavacDef.JavacClassDef) || !((element = def.getDefinedElement()) instanceof JavacRef.JavacClass)) continue;
            definedClasses.add(element.getName());
        }
        if (!(definedClasses.isEmpty() || classImports.isEmpty() && staticImports.isEmpty())) {
            Callbacks.Backend deps = JavaBuilderUtil.getDependenciesRegistrar(context);
            for (String aClass : definedClasses) {
                deps.registerImports(aClass, classImports, staticImports);
            }
        }
    }
}

