/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildRootIndexImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetTypeState;
import org.jetbrains.jps.model.JpsModel;

public class BuildTargetsState {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.storage.BuildTargetsState");
    private final BuildDataPaths myDataPaths;
    private final AtomicInteger myMaxTargetId = new AtomicInteger(0);
    private final ConcurrentMap<BuildTargetType<?>, BuildTargetTypeState> myTypeStates = new ConcurrentHashMap(16, 0.75f, 1);
    private final JpsModel myModel;
    private final BuildRootIndexImpl myBuildRootIndex;

    public BuildTargetsState(BuildDataPaths dataPaths, JpsModel model, BuildRootIndexImpl buildRootIndex) {
        this.myDataPaths = dataPaths;
        this.myModel = model;
        this.myBuildRootIndex = buildRootIndex;
        File targetTypesFile = this.getTargetTypesFile();
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(targetTypesFile)));){
            this.myMaxTargetId.set(input.readInt());
        }
        catch (IOException e) {
            LOG.debug("Cannot load " + targetTypesFile + ":" + e.getMessage(), (Throwable)e);
            LOG.debug("Loading all target types to calculate max target id");
            for (BuildTargetType<?> type : TargetTypeRegistry.getInstance().getTargetTypes()) {
                this.getTypeState(type);
            }
        }
    }

    private File getTargetTypesFile() {
        return new File(this.myDataPaths.getTargetsDataRoot(), "targetTypes.dat");
    }

    public void save() {
        try {
            File targetTypesFile = this.getTargetTypesFile();
            FileUtil.createParentDirs((File)targetTypesFile);
            try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(targetTypesFile)));){
                output.writeInt(this.myMaxTargetId.get());
            }
        }
        catch (IOException e) {
            LOG.info("Cannot save targets info: " + e.getMessage(), (Throwable)e);
        }
        for (BuildTargetTypeState state : this.myTypeStates.values()) {
            state.save();
        }
    }

    public int getBuildTargetId(@NotNull BuildTarget<?> target) {
        return this.getTypeState(target.getTargetType()).getTargetId(target);
    }

    public BuildTargetConfiguration getTargetConfiguration(@NotNull BuildTarget<?> target) {
        return this.getTypeState(target.getTargetType()).getConfiguration(target);
    }

    public List<Pair<String, Integer>> getStaleTargetIds(@NotNull BuildTargetType<?> type) {
        return this.getTypeState(type).getStaleTargetIds();
    }

    public void cleanStaleTarget(BuildTargetType<?> type, String targetId) {
        this.getTypeState(type).removeStaleTarget(targetId);
    }

    public void setAverageBuildTime(BuildTargetType<?> type, long time) {
        this.getTypeState(type).setAverageTargetBuildTime(time);
    }

    public long getAverageBuildTime(BuildTargetType<?> type) {
        return this.getTypeState(type).getAverageTargetBuildTime();
    }

    private BuildTargetTypeState getTypeState(BuildTargetType<?> type) {
        BuildTargetTypeState newState;
        BuildTargetTypeState state = (BuildTargetTypeState)this.myTypeStates.get(type);
        if (state == null && (state = this.myTypeStates.putIfAbsent(type, newState = new BuildTargetTypeState(type, this))) == null) {
            state = newState;
        }
        return state;
    }

    public void markUsedId(int id) {
        int max;
        int current;
        while (!this.myMaxTargetId.compareAndSet(current = this.myMaxTargetId.get(), max = Math.max(id, current))) {
        }
    }

    public int getFreeId() {
        return this.myMaxTargetId.incrementAndGet();
    }

    public void clean() {
        FileUtil.delete((File)this.myDataPaths.getTargetsDataRoot());
    }

    public JpsModel getModel() {
        return this.myModel;
    }

    public BuildRootIndexImpl getBuildRootIndex() {
        return this.myBuildRootIndex;
    }

    public BuildDataPaths getDataPaths() {
        return this.myDataPaths;
    }
}

