/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;

public class OneToManyPathsMapping
extends AbstractStateStorage<String, Collection<String>> {
    public OneToManyPathsMapping(File storePath) throws IOException {
        super(storePath, PathStringDescriptor.INSTANCE, new PathCollectionExternalizer());
    }

    @Override
    public void update(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        super.update(FileUtil.toSystemIndependentName((String)keyPath), OneToManyPathsMapping.normalizePaths(boundPaths));
    }

    @Override
    public final void update(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        super.update(FileUtil.toSystemIndependentName((String)keyPath), Collections.singleton(FileUtil.toSystemIndependentName((String)boundPath)));
    }

    @Override
    public final void appendData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        super.appendData(FileUtil.toSystemIndependentName((String)keyPath), Collections.singleton(FileUtil.toSystemIndependentName((String)boundPath)));
    }

    @Override
    public void appendData(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        super.appendData(FileUtil.toSystemIndependentName((String)keyPath), OneToManyPathsMapping.normalizePaths(boundPaths));
    }

    @Override
    @Nullable
    public Collection<String> getState(@NotNull String keyPath) throws IOException {
        return (Collection)super.getState(FileUtil.toSystemIndependentName((String)keyPath));
    }

    @Override
    public void remove(@NotNull String keyPath) throws IOException {
        super.remove(FileUtil.toSystemIndependentName((String)keyPath));
    }

    public final void removeData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        Collection<String> outputPaths = this.getState(FileUtil.toSystemIndependentName((String)keyPath));
        if (outputPaths != null) {
            boolean removed = outputPaths.remove(FileUtil.toSystemIndependentName((String)boundPath));
            if (outputPaths.isEmpty()) {
                this.remove(keyPath);
            } else if (removed) {
                this.update(keyPath, outputPaths);
            }
        }
    }

    private static Collection<String> normalizePaths(Collection<String> outputs) {
        ArrayList<String> normalized = new ArrayList<String>(outputs.size());
        for (String out : outputs) {
            normalized.add(FileUtil.toSystemIndependentName((String)out));
        }
        return normalized;
    }

    private static class PathCollectionExternalizer
    implements DataExternalizer<Collection<String>> {
        private PathCollectionExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<String> value) throws IOException {
            for (String str : value) {
                IOUtil.writeUTF((DataOutput)out, (String)str);
            }
        }

        public Collection<String> read(@NotNull DataInput in) throws IOException {
            THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                String str = IOUtil.readUTF((DataInput)stream);
                result.add(str);
            }
            return result;
        }
    }
}

