/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilationPaths {
    private final Collection<File> myPlatformClasspath;
    private final Collection<File> myClasspath;
    private final Collection<File> myUpgradeModulePath;
    private final Collection<File> myModulePath;
    private final Collection<File> mySourcePath;

    public CompilationPaths(Collection<File> platformClasspath, Collection<File> classpath, Collection<File> upgradeModulePath, Collection<File> modulePath, Collection<File> sourcePath) {
        this.myPlatformClasspath = CompilationPaths.constCollection(platformClasspath);
        this.myClasspath = CompilationPaths.constCollection(classpath);
        this.myUpgradeModulePath = CompilationPaths.constCollection(upgradeModulePath);
        this.myModulePath = CompilationPaths.constCollection(modulePath);
        this.mySourcePath = CompilationPaths.constCollection(sourcePath);
    }

    private static <T> Collection<T> constCollection(Collection<T> col) {
        return col == null || col.isEmpty() ? Collections.emptyList() : Collections.unmodifiableCollection(col);
    }

    @NotNull
    public Collection<File> getPlatformClasspath() {
        return this.myPlatformClasspath;
    }

    @NotNull
    public Collection<File> getClasspath() {
        return this.myClasspath;
    }

    @NotNull
    public Collection<File> getUpgradeModulePath() {
        return this.myUpgradeModulePath;
    }

    @NotNull
    public Collection<File> getModulePath() {
        return this.myModulePath;
    }

    @NotNull
    public Collection<File> getSourcePath() {
        return this.mySourcePath;
    }

    public static CompilationPaths create(@Nullable Collection<File> platformCp, @Nullable Collection<File> cp, @Nullable Collection<File> upgradeModCp, @Nullable Collection<File> modulePath, @Nullable Collection<File> sourcePath) {
        return new CompilationPaths(platformCp, cp, upgradeModCp, modulePath, sourcePath);
    }

    public static Builder builder() {
        return new Builder(){
            private Collection<File> mySourcePath;
            private Collection<File> myModulePath;
            private Collection<File> myUpgradeModulePath;
            private Collection<File> myClasspath;
            private Collection<File> myPlatformCp;

            @Override
            public CompilationPaths create() {
                return CompilationPaths.create(this.myPlatformCp, this.myClasspath, this.myUpgradeModulePath, this.myModulePath, this.mySourcePath);
            }

            @Override
            public Builder setPlatformClasspath(Collection<File> path) {
                this.myPlatformCp = path;
                return this;
            }

            @Override
            public Builder setClasspath(Collection<File> path) {
                this.myClasspath = path;
                return this;
            }

            @Override
            public Builder setUpgradeModulePath(Collection<File> path) {
                this.myUpgradeModulePath = path;
                return this;
            }

            @Override
            public Builder setModulePath(Collection<File> path) {
                this.myModulePath = path;
                return this;
            }

            @Override
            public Builder setSourcePath(Collection<File> path) {
                this.mySourcePath = path;
                return this;
            }
        };
    }

    public static interface Builder {
        public CompilationPaths create();

        public Builder setPlatformClasspath(Collection<File> var1);

        public Builder setClasspath(Collection<File> var1);

        public Builder setUpgradeModulePath(Collection<File> var1);

        public Builder setModulePath(Collection<File> var1);

        public Builder setSourcePath(Collection<File> var1);
    }
}

