/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\r"}, d2={"Landroid/databinding/tool/util/RelativizableFile;", "", "baseDir", "Ljava/io/File;", "file", "(Ljava/io/File;Ljava/io/File;)V", "absoluteFile", "getAbsoluteFile", "()Ljava/io/File;", "getBaseDir", "relativeFile", "getRelativeFile", "Companion", "db-compilerCommon"})
public final class RelativizableFile {
    @NotNull
    private final File absoluteFile;
    @Nullable
    private final File relativeFile;
    @Nullable
    private final File baseDir;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final File getAbsoluteFile() {
        return this.absoluteFile;
    }

    @Nullable
    public final File getRelativeFile() {
        return this.relativeFile;
    }

    @Nullable
    public final File getBaseDir() {
        return this.baseDir;
    }

    private RelativizableFile(File baseDir, File file) {
        this.baseDir = baseDir;
        if (this.baseDir != null) {
            boolean bl = this.baseDir.isAbsolute();
            if (!bl) {
                boolean bl2 = false;
                String string = this.baseDir.getPath() + " is not an absolute path";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            boolean bl3 = bl = !file.isAbsolute();
            if (!bl) {
                boolean bl4 = false;
                String string = file.getPath() + " is not a relative path";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.absoluteFile = new File(this.baseDir, file.getPath());
            this.relativeFile = file;
        } else {
            boolean bl = file.isAbsolute();
            if (!bl) {
                boolean bl5 = false;
                String string = file.getPath() + " is not an absolute path";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.absoluteFile = file;
            this.relativeFile = null;
        }
    }

    public /* synthetic */ RelativizableFile(File baseDir, File file, DefaultConstructorMarker $constructor_marker) {
        this(baseDir, file);
    }

    @JvmStatic
    @NotNull
    public static final RelativizableFile fromRelativeFile(@NotNull File baseDir, @NotNull File relativeFile) {
        return Companion.fromRelativeFile(baseDir, relativeFile);
    }

    @JvmStatic
    @NotNull
    public static final RelativizableFile fromAbsoluteFile(@NotNull File absoluteFile, @Nullable File baseDir) {
        return Companion.fromAbsoluteFile(absoluteFile, baseDir);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a8\u0006\n"}, d2={"Landroid/databinding/tool/util/RelativizableFile$Companion;", "", "()V", "fromAbsoluteFile", "Landroid/databinding/tool/util/RelativizableFile;", "absoluteFile", "Ljava/io/File;", "baseDir", "fromRelativeFile", "relativeFile", "db-compilerCommon"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RelativizableFile fromRelativeFile(@NotNull File baseDir, @NotNull File relativeFile) {
            return new RelativizableFile(baseDir, relativeFile, null);
        }

        @JvmStatic
        @NotNull
        public final RelativizableFile fromAbsoluteFile(@NotNull File absoluteFile, @Nullable File baseDir) {
            boolean bl = absoluteFile.isAbsolute();
            if (!bl) {
                boolean bl2 = false;
                String string = absoluteFile.getPath() + " is not an absolute path";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            File file = baseDir;
            if (file != null) {
                File file2;
                File it = file2 = file;
                boolean bl3 = false;
                boolean bl4 = it.isAbsolute();
                if (!bl4) {
                    boolean bl5 = false;
                    String string = it.getPath() + " is not an absolute path";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            return baseDir != null && StringsKt.startsWith$default((String)absoluteFile.getAbsolutePath(), (String)baseDir.getAbsolutePath(), (boolean)false, (int)2, null) ? this.fromRelativeFile(baseDir, baseDir.toPath().relativize(absoluteFile.toPath()).toFile()) : new RelativizableFile(null, absoluteFile, null);
        }

        @JvmStatic
        @NotNull
        public static /* synthetic */ RelativizableFile fromAbsoluteFile$default(Companion companion, File file, File file2, int n, Object object) {
            if ((n & 2) != 0) {
                file2 = null;
            }
            return companion.fromAbsoluteFile(file, file2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

