/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.gct.login.CancellableServerReceiver;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.CredentialedUserRoster;
import com.google.gct.login.GoogleLoginListener;
import com.google.gct.login.GoogleLoginPrefs;
import com.google.gct.login.GoogleLoginUtils;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.google.gct.login.InvalidThreadTypeException;
import com.google.gct.login.LoginContext;
import com.google.gct.login.OAuthScopeRegistry;
import com.google.gct.login.RequestCancelledException;
import com.google.gct.login.ui.GoogleLoginCopyAndPasteDialog;
import com.google.gdt.eclipse.login.common.GoogleLoginState;
import com.google.gdt.eclipse.login.common.LoggerFacade;
import com.google.gdt.eclipse.login.common.OAuthData;
import com.google.gdt.eclipse.login.common.OAuthDataStore;
import com.google.gdt.eclipse.login.common.UiFacade;
import com.google.gdt.eclipse.login.common.VerificationCodeHolder;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import icons.GoogleLoginIcons;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleLogin {
    private ClientInfo clientInfo = GoogleLogin.getClientInfo();
    private AndroidUiFacade uiFacade = new AndroidUiFacade();
    private AndroidPreferencesOAuthDataStore dataStore;
    private CredentialedUserRoster users = new CredentialedUserRoster();
    private static GoogleLogin instance;
    public static final Logger LOG;

    private GoogleLogin() {
        this.dataStore = new AndroidPreferencesOAuthDataStore();
        this.addLoginListenersFromExtensionPoints();
    }

    @NotNull
    public static GoogleLogin getInstance() {
        if (instance == null) {
            instance = new GoogleLogin();
            GoogleLogin.instance.dataStore.initializeUsers();
        }
        return instance;
    }

    @VisibleForTesting
    static void setInstance(GoogleLogin newInstance) {
        instance = newInstance;
    }

    public static void promptToLogIn() throws InvalidThreadTypeException {
        GoogleLogin.promptToLogIn(null, null);
    }

    public static void promptToLogIn(@Nullable String message, @Nullable IGoogleLoginCompletedCallback callback) throws InvalidThreadTypeException {
        if (!instance.isLoggedIn()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                GoogleLogin.getInstance().logIn(message, callback);
            } else {
                throw new InvalidThreadTypeException("promptToLogin");
            }
        }
    }

    @Nullable
    public HttpRequestFactory createRequestFactory() {
        return this.createRequestFactory(null);
    }

    @Nullable
    public HttpRequestFactory createRequestFactory(@Nullable String message) {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().createRequestFactory(message);
    }

    @Nullable
    public String fetchAccessToken() throws IOException {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().fetchAccessToken();
    }

    @Nullable
    public String fetchOAuth2ClientId() {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().fetchOAuth2ClientId();
    }

    @Nullable
    public String fetchOAuth2ClientSecret() {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().fetchOAuth2ClientSecret();
    }

    @Nullable
    public String fetchOAuth2RefreshToken() {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().fetchOAuth2RefreshToken();
    }

    @Nullable
    public String fetchOAuth2Token() throws IOException {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().fetchOAuth2Token();
    }

    @Nullable
    public Credential getCredential() {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().getCredential();
    }

    @Nullable
    public String getEmail() {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().getEmail();
    }

    public boolean isConnected() {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return false;
        }
        return activeUser.getGoogleLoginState().isConnected();
    }

    public boolean isLoggedIn() {
        return this.users.isActiveUserAvailable();
    }

    public void logIn() {
        this.logIn(null, null);
    }

    public void logIn(final @Nullable String message, final @Nullable IGoogleLoginCompletedCallback loginCompletedCallback) {
        final CredentialedUser lastActiveUser = this.users.getActiveUser();
        this.users.removeActiveUser();
        final GoogleLoginState state = this.createGoogleLoginState(false);
        new Task.Modal(GoogleLogin.getCurrentProject(), "Please sign in via the opened browser...", true){
            private boolean loggedIn;
            {
                super(x0, x1, x2);
                this.loggedIn = false;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                if (!(indicator instanceof ProgressIndicatorEx)) {
                    return;
                }
                ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                    public void cancel() {
                        assert (GoogleLogin.this.uiFacade != null);
                        GoogleLogin.this.uiFacade.stop();
                        super.cancel();
                    }
                });
                this.loggedIn = state != null && state.logInWithLocalServer(message);
            }

            public void onCancel() {
                this.notifyOnComplete();
            }

            public void onSuccess() {
                this.notifyOnComplete();
            }

            private void notifyOnComplete() {
                if (this.loggedIn) {
                    GoogleLogin.this.users.addUser(new CredentialedUser(state, () -> {
                        if (loginCompletedCallback != null) {
                            loginCompletedCallback.onLoginCompleted();
                        }
                    }));
                } else {
                    this.restoreLastActiveUser();
                    if (loginCompletedCallback != null) {
                        loginCompletedCallback.onLoginCompleted();
                    }
                }
            }

            private void restoreLastActiveUser() {
                if (lastActiveUser != null) {
                    GoogleLogin.this.setActiveUser(lastActiveUser.getEmail());
                }
            }
        }.queue();
    }

    @Nullable
    private static Project getCurrentProject() {
        Window activeWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (activeWindow == null) {
            return null;
        }
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)activeWindow));
    }

    public boolean logOut() {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return false;
        }
        boolean loggedOut = activeUser.getGoogleLoginState().logOut();
        if (loggedOut) {
            this.logOutAllUsers();
        }
        return loggedOut;
    }

    public boolean logOut(boolean showPrompt) {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return false;
        }
        boolean loggedOut = activeUser.getGoogleLoginState().logOut(showPrompt);
        if (loggedOut) {
            this.logOutAllUsers();
        }
        return loggedOut;
    }

    @Nullable
    public Credential makeCredential() {
        CredentialedUser activeUser = this.users.getActiveUser();
        if (activeUser == null) {
            return null;
        }
        return activeUser.getGoogleLoginState().makeCredential();
    }

    public void setActiveUser(String userEmail) throws IllegalArgumentException {
        this.users.setActiveUser(userEmail);
    }

    public LinkedHashMap<String, CredentialedUser> getAllUsers() {
        return this.users.getAllUsers();
    }

    @Nullable
    public CredentialedUser getActiveUser() {
        return this.users.getActiveUser();
    }

    private void logOutAllUsers() {
        for (CredentialedUser aUser : this.users.getAllUsers().values()) {
            aUser.getGoogleLoginState().logOut(false);
        }
        this.users.removeAllUsers();
    }

    private void addLoginListenersFromExtensionPoints() {
        GoogleLoginListener[] loginListeners;
        for (GoogleLoginListener listener : loginListeners = (GoogleLoginListener[])Extensions.getExtensions(GoogleLoginListener.EP_NAME)) {
            this.users.addLoginListener(listener);
        }
    }

    @Nullable
    private GoogleLoginState createGoogleLoginState(boolean initializingUsers) {
        GoogleLoginState state = new GoogleLoginState(this.clientInfo.getId(), this.clientInfo.getInfo(), OAuthScopeRegistry.getScopes(), (OAuthDataStore)new AndroidPreferencesOAuthDataStore(), (UiFacade)this.uiFacade, (LoggerFacade)new AndroidLoggerFacade());
        if (initializingUsers && !state.isLoggedIn()) {
            return null;
        }
        return state;
    }

    private static ClientInfo getClientInfo() {
        String id = LoginContext.getId();
        String info = LoginContext.getInfo();
        if (id != null && !id.trim().isEmpty() && info != null && !info.trim().isEmpty()) {
            return new ClientInfo(id, info);
        }
        throw new IllegalStateException("The client information for Android Studio was not found");
    }

    private static void logErrorAndDisplayDialog(@NotNull String title, @NotNull Exception exception) {
        LOG.error(exception.getMessage(), (Throwable)exception);
        GoogleLoginUtils.showErrorDialog(exception.getMessage(), title);
    }

    static {
        LOG = Logger.getInstance(GoogleLogin.class);
    }

    private static class AndroidLoggerFacade
    implements LoggerFacade {
        private AndroidLoggerFacade() {
        }

        public void logError(String msg, Throwable t) {
            LOG.error(msg, t);
        }

        public void logWarning(String msg) {
            LOG.warn(msg);
        }
    }

    private class AndroidPreferencesOAuthDataStore
    implements OAuthDataStore {
        private AndroidPreferencesOAuthDataStore() {
        }

        public void saveOAuthData(OAuthData credentials) {
            GoogleLoginPrefs.saveOAuthData(credentials);
        }

        public OAuthData loadOAuthData() {
            return GoogleLoginPrefs.loadOAuthData();
        }

        public void clearStoredOAuthData() {
            GoogleLoginPrefs.clearStoredOAuthData();
        }

        public void initializeUsers() {
            String activeUserString = GoogleLoginPrefs.getActiveUser();
            List<String> allUsers = GoogleLoginPrefs.getStoredUsers();
            String removedUsers = "";
            for (String aUser : allUsers) {
                GoogleLogin.this.users.addUser(new CredentialedUser(aUser));
                GoogleLoginState delegate = GoogleLogin.this.createGoogleLoginState(true);
                if (delegate == null) {
                    removedUsers = removedUsers + aUser + ", ";
                    if (aUser.equals(activeUserString)) {
                        activeUserString = null;
                    }
                    GoogleLogin.this.users.removeUser(aUser);
                    continue;
                }
                GoogleLogin.this.users.addUser(new CredentialedUser(delegate, null));
            }
            if (activeUserString == null) {
                GoogleLogin.this.users.removeActiveUser();
            } else {
                try {
                    GoogleLogin.this.users.setActiveUser(activeUserString);
                }
                catch (IllegalArgumentException ex) {
                    LOG.warn("Error while initiating users", (Throwable)ex);
                    GoogleLogin.this.users.removeActiveUser();
                }
            }
            if (!removedUsers.isEmpty()) {
                LOG.info("The following user(s) had expired authentication scopes: " + removedUsers + "and have been logged out.");
            }
        }
    }

    private class AndroidUiFacade
    implements UiFacade {
        private volatile CancellableServerReceiver receiver = null;

        private AndroidUiFacade() {
        }

        public String obtainVerificationCodeFromUserInteraction(String title, GoogleAuthorizationCodeRequestUrl authCodeRequestUrl) {
            GoogleLoginCopyAndPasteDialog dialog = new GoogleLoginCopyAndPasteDialog(authCodeRequestUrl, "Google Login");
            dialog.show();
            if (dialog.getExitCode() == 1) {
                return null;
            }
            return Strings.emptyToNull((String)dialog.getVerificationCode());
        }

        public void stop() {
            CancellableServerReceiver localreceiver = this.receiver;
            if (localreceiver != null) {
                try {
                    localreceiver.stop();
                }
                catch (IOException e) {
                    GoogleLogin.logErrorAndDisplayDialog("Google Login", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VerificationCodeHolder obtainVerificationCodeFromExternalUserInteraction(String title) {
            String verificationCode;
            String redirectUrl;
            this.receiver = new CancellableServerReceiver();
            try {
                redirectUrl = this.receiver.getRedirectUri();
            }
            catch (IOException e) {
                GoogleLogin.logErrorAndDisplayDialog(title == null ? "Google Login" : title, e);
                return null;
            }
            AuthorizationCodeRequestUrl authCodeRequestUrl = new AuthorizationCodeRequestUrl("https://accounts.google.com/o/oauth2/auth", GoogleLogin.this.clientInfo.getId()).setRedirectUri(redirectUrl).setScopes(OAuthScopeRegistry.getScopes());
            BrowserUtil.browse((String)authCodeRequestUrl.build());
            try {
                verificationCode = this.receiver.waitForCode();
            }
            catch (RequestCancelledException e) {
                GoogleLoginUtils.showErrorDialog("Login cancelled.", "Google Login");
                VerificationCodeHolder verificationCodeHolder = null;
                return verificationCodeHolder;
            }
            catch (IOException e) {
                GoogleLogin.logErrorAndDisplayDialog(title == null ? "Google Login" : title, e);
                VerificationCodeHolder verificationCodeHolder = null;
                return verificationCodeHolder;
            }
            finally {
                this.receiver = null;
            }
            return new VerificationCodeHolder(verificationCode, redirectUrl);
        }

        public void showErrorDialog(String title, String message) {
            Messages.showErrorDialog((String)message, (String)title);
        }

        public boolean askYesOrNo(String title, String message) {
            String updatedMessage = message;
            if (message.equals("Are you sure you want to sign out?")) {
                updatedMessage = updatedMessage + " This will sign out all logged in users.";
            }
            return Messages.showYesNoDialog((String)updatedMessage, (String)title, (Icon)GoogleLoginIcons.GOOGLE_FAVICON) == 0;
        }

        public void notifyStatusIndicator() {
        }
    }

    @Immutable
    private static class ClientInfo {
        private final String id;
        private final String info;

        public ClientInfo(String id, String info) {
            this.id = id;
            this.info = info;
        }

        public String getId() {
            return this.id;
        }

        public String getInfo() {
            return this.info;
        }
    }
}

