/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class DeviceProcessTable
extends DataStoreTable<Statements> {
    @Override
    public void prepareStatements() {
        try {
            for (Statements statement : Statements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("DevicesTable", "DeviceId INTEGER", "Data BLOB");
            this.createTable("ProcessesTable", "DeviceId INTEGER", "ProcessId INTEGER", "Name STRING NOT NULL", "State INTEGER", "StartTime INTEGER", "Arch STRING NOT NULL", "AgentStatus INTEGER");
            this.createUniqueIndex("DevicesTable", "DeviceId");
            this.createUniqueIndex("ProcessesTable", "DeviceId", "ProcessId");
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
    }

    @NotNull
    public Transport.GetDevicesResponse getDevices() {
        if (this.isClosed()) {
            return Transport.GetDevicesResponse.getDefaultInstance();
        }
        Transport.GetDevicesResponse.Builder responseBuilder = Transport.GetDevicesResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(Statements.SELECT_DEVICE, new Object[0]);
            while (results.next()) {
                responseBuilder.addDevice(Common.Device.parseFrom((byte[])results.getBytes(1)));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
        return responseBuilder.build();
    }

    @NotNull
    public Transport.GetProcessesResponse getProcesses(@NotNull Transport.GetProcessesRequest request) {
        if (this.isClosed()) {
            return Transport.GetProcessesResponse.getDefaultInstance();
        }
        Transport.GetProcessesResponse.Builder responseBuilder = Transport.GetProcessesResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(Statements.SELECT_PROCESSES, request.getDeviceId());
            while (results.next()) {
                long deviceId = results.getLong(1);
                int pid = results.getInt(2);
                String name = results.getString(3);
                int state = results.getInt(4);
                long startTimeNs = results.getLong(5);
                String arch = results.getString(6);
                Common.Process process = Common.Process.newBuilder().setDeviceId(deviceId).setPid(pid).setName(name).setState(Common.Process.State.forNumber((int)state)).setStartTimestampNs(startTimeNs).setAbiCpuArch(arch).build();
                responseBuilder.addProcess(process);
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
        return responseBuilder.build();
    }

    public void insertOrUpdateDevice(@NotNull Common.Device device) {
        this.execute(Statements.INSERT_DEVICE, device.getDeviceId(), device.toByteArray());
    }

    public void insertOrUpdateProcess(@NotNull long deviceId, @NotNull Common.Process process) {
        try {
            ResultSet results = this.executeQuery(Statements.SELECT_PROCESS_BY_ID, deviceId, process.getPid());
            if (results.next()) {
                this.execute(Statements.UPDATE_PROCESS_STATE, process.getStateValue(), deviceId, process.getPid());
            } else {
                this.execute(Statements.INSERT_PROCESS, deviceId, process.getPid(), process.getName(), process.getStateValue(), process.getStartTimestampNs(), process.getAbiCpuArch());
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
    }

    public void updateAgentStatus(@NotNull long devicId, @NotNull Common.Process process, @NotNull Common.AgentData agentData) {
        try {
            ResultSet results = this.executeQuery(Statements.FIND_AGENT_STATUS, devicId, process.getPid());
            if (results.next()) {
                this.execute(Statements.UPDATE_AGENT_STATUS, agentData.getStatus().ordinal(), devicId, process.getPid());
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
    }

    @NotNull
    public Common.AgentData getAgentStatus(@NotNull Transport.AgentStatusRequest request) {
        Common.AgentData.Builder responseBuilder = Common.AgentData.newBuilder();
        try {
            ResultSet results = this.executeQuery(Statements.FIND_AGENT_STATUS, request.getDeviceId(), request.getPid());
            if (results.next()) {
                responseBuilder.setStatusValue(results.getInt(1));
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
        return responseBuilder.build();
    }

    public static enum Statements {
        INSERT_DEVICE("INSERT OR REPLACE INTO [DevicesTable] (DeviceId, Data) values (?, ?)"),
        INSERT_PROCESS("INSERT OR REPLACE INTO [ProcessesTable] (DeviceId, ProcessId, Name, State, StartTime, Arch) values (?, ?, ?, ?, ?, ?)"),
        UPDATE_PROCESS_STATE("UPDATE [ProcessesTable] Set State = ? WHERE DeviceId = ? AND ProcessId = ?"),
        SELECT_PROCESSES("SELECT DeviceId, ProcessId, Name, State, StartTime, Arch from [ProcessesTable] WHERE DeviceId = ?"),
        SELECT_PROCESS_BY_ID("SELECT ProcessId from [ProcessesTable] WHERE DeviceId = ? AND ProcessId = ?"),
        SELECT_DEVICE("SELECT Data from [DevicesTable]"),
        FIND_AGENT_STATUS("SELECT AgentStatus from [ProcessesTable] WHERE DeviceId = ? AND ProcessId = ?"),
        UPDATE_AGENT_STATUS("UPDATE [ProcessesTable] SET AgentStatus = ? WHERE DeviceId = ? AND ProcessId = ?");

        @NotNull
        private final String mySqlStatement;

        private Statements(String sqlStatement) {
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            return this.mySqlStatement;
        }
    }
}

