/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class ProfilerTable
extends DataStoreTable<ProfilerStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("Profiler_Sessions", "SessionId INTEGER", "DeviceId INTEGER", "ProcessId INTEGER", "StartTime INTEGER", "EndTime INTEGER", "StartTimeEpochMs INTEGER", "Name TEXT", "ProcessAbi TEXT", "JvmtiEnabled INTEGER", "LiveAllocationEnabled INTEGER", "TypeId INTEGER");
            this.createUniqueIndex("Profiler_Sessions", "SessionId");
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(ProfilerStatements.INSERT_SESSION, "INSERT OR REPLACE INTO Profiler_Sessions (SessionId, DeviceId, ProcessId, StartTime, EndTime, StartTimeEpochMs, Name, ProcessAbi, JvmtiEnabled, LiveAllocationEnabled, TypeId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.createStatement(ProfilerStatements.UPDATE_SESSION, "UPDATE Profiler_Sessions Set EndTime = ? WHERE SessionId = ?");
            this.createStatement(ProfilerStatements.SELECT_SESSIONS, "SELECT * from Profiler_Sessions ORDER BY SessionId ASC");
            this.createStatement(ProfilerStatements.SELECT_SESSION_BY_ID, "SELECT * from Profiler_Sessions WHERE SessionId = ?");
            this.createStatement(ProfilerStatements.DELETE_SESSION_BY_ID, "DELETE from Profiler_Sessions WHERE SessionId = ?");
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
    }

    @NotNull
    public Common.Session getSessionById(long sessionId) {
        if (this.isClosed()) {
            return Common.Session.getDefaultInstance();
        }
        Common.Session.Builder builder = Common.Session.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSION_BY_ID, sessionId);
            if (results.next()) {
                builder.setSessionId(results.getLong(1)).setStreamId(results.getLong(2)).setPid(results.getInt(3)).setStartTimestamp(results.getLong(4)).setEndTimestamp(results.getLong(5));
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        return builder.build();
    }

    @NotNull
    public Profiler.GetSessionMetaDataResponse getSessionMetaData(long sessionId) {
        if (this.isClosed()) {
            return Profiler.GetSessionMetaDataResponse.getDefaultInstance();
        }
        Profiler.GetSessionMetaDataResponse.Builder responseBuilder = Profiler.GetSessionMetaDataResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSION_BY_ID, sessionId);
            while (results.next()) {
                responseBuilder.setData(Common.SessionMetaData.newBuilder().setSessionId(results.getLong(1)).setStartTimestampEpochMs(results.getLong(6)).setSessionName(results.getString(7)).setProcessAbi(results.getString(8)).setJvmtiEnabled(results.getBoolean(9)).setLiveAllocationEnabled(results.getBoolean(10)).setType(Common.SessionMetaData.SessionType.forNumber((int)results.getInt(11))).build());
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        return responseBuilder.build();
    }

    @NotNull
    public Profiler.GetSessionsResponse getSessions() {
        if (this.isClosed()) {
            return Profiler.GetSessionsResponse.getDefaultInstance();
        }
        Profiler.GetSessionsResponse.Builder responseBuilder = Profiler.GetSessionsResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSIONS, new Object[0]);
            while (results.next()) {
                responseBuilder.addSessions(Common.Session.newBuilder().setSessionId(results.getLong(1)).setStreamId(results.getLong(2)).setPid(results.getInt(3)).setStartTimestamp(results.getLong(4)).setEndTimestamp(results.getLong(5)).build());
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        return responseBuilder.build();
    }

    public void deleteSession(long sessionId) {
        this.execute(ProfilerStatements.DELETE_SESSION_BY_ID, sessionId);
    }

    public void insertOrUpdateSession(@NotNull Common.Session session, @NotNull String name, long startTimeUtc, String processAbi, boolean jvmtiEnabled, boolean liveAllocationEnabled, Common.SessionMetaData.SessionType sessionType) {
        this.execute(ProfilerStatements.INSERT_SESSION, session.getSessionId(), session.getStreamId(), session.getPid(), session.getStartTimestamp(), session.getEndTimestamp(), startTimeUtc, name, processAbi, jvmtiEnabled, liveAllocationEnabled, sessionType.getNumber());
    }

    public void updateSessionEndTime(long sessionId, long endTimestampNs) {
        this.execute(ProfilerStatements.UPDATE_SESSION, endTimestampNs, sessionId);
    }

    public static enum ProfilerStatements {
        INSERT_SESSION,
        UPDATE_SESSION,
        SELECT_SESSIONS,
        SELECT_SESSION_BY_ID,
        DELETE_SESSION_BY_ID;

    }
}

