/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedEventsTable
extends DataStoreTable<Statements> {
    @Override
    public void prepareStatements() {
        try {
            for (Statements statement : Statements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("UnifiedEventsTable", "StreamId INTEGER NOT NULL", "ProcessId INTEGER NOT NULL", "GroupId INTEGER NOT NULL", "Kind INTEGER NOT NULL", "CommandId INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "Data BLOB");
            this.createTable("BytesTable", "StreamId INTEGER NOT NULL", "Id STRING NOT NULL", "Data BLOB");
            this.createUniqueIndex("UnifiedEventsTable", "StreamId", "ProcessId", "GroupId", "Kind", "Timestamp");
            this.createIndex("UnifiedEventsTable", 1, "StreamId", "Kind", "Timestamp");
            this.createIndex("UnifiedEventsTable", 2, "StreamId", "Kind", "CommandId", "Timestamp");
            this.createUniqueIndex("BytesTable", "StreamId", "Id");
        }
        catch (SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
    }

    public void insertUnifiedEvent(long streamId, @NotNull Common.Event event) {
        this.execute(Statements.INSERT_EVENT, streamId, event.getPid(), event.getGroupId(), event.getKind().getNumber(), event.getCommandId(), event.getTimestamp(), event.toByteArray());
    }

    public List<Common.Event> queryUnifiedEvents() {
        return this.queryUnifiedEvents(Statements.QUERY_EVENTS, new Object[0]);
    }

    public List<Transport.EventGroup> queryUnifiedEventGroups(@NotNull Transport.GetEventGroupsRequest request) {
        ArrayList<Number> baseParams = new ArrayList<Number>();
        ArrayList<Object> beforeRangeParams = null;
        ArrayList<Object> afterRangeParams = null;
        HashMap<Long, Transport.EventGroup.Builder> builderGroups = new HashMap<Long, Transport.EventGroup.Builder>();
        String sql = "SELECT [Data]%s From [UnifiedEventsTable] WHERE Kind = ? %s";
        StringBuilder filter = new StringBuilder();
        baseParams.add(request.getKind().getNumber());
        if (request.getStreamId() != 0L) {
            filter.append(" AND StreamId = ?");
            baseParams.add(request.getStreamId());
        }
        if (request.getPid() != 0) {
            filter.append(" AND ProcessId = ?");
            baseParams.add(request.getPid());
        }
        if (request.getGroupId() != 0L) {
            filter.append(" AND GroupId = ?");
            baseParams.add(request.getGroupId());
        }
        if (request.getCommandId() != 0) {
            filter.append(" AND CommandId = ?");
            baseParams.add(request.getCommandId());
        }
        String sqlBefore = String.format(sql, ", MAX(Timestamp), MAX(ROWID)", filter.toString() + " AND Timestamp < ? GROUP BY GroupId");
        String sqlAfter = String.format(sql, ", MIN(Timestamp), MIN(ROWID)", filter.toString() + " AND Timestamp > ? GROUP BY GroupId");
        ArrayList<Object> inRangeQueryParams = new ArrayList<Object>(baseParams);
        if (request.getFromTimestamp() != 0L) {
            beforeRangeParams = new ArrayList<Object>(baseParams);
            beforeRangeParams.add(request.getFromTimestamp());
            filter.append(" AND Timestamp >= ?");
            inRangeQueryParams.add(request.getFromTimestamp());
        }
        if (request.getToTimestamp() != 0L) {
            afterRangeParams = new ArrayList<Object>(baseParams);
            afterRangeParams.add(request.getToTimestamp());
            filter.append(" AND Timestamp <= ?");
            inRangeQueryParams.add(request.getToTimestamp());
        }
        if (beforeRangeParams != null) {
            this.gatherEvents(sqlBefore, beforeRangeParams, builderGroups, event -> !event.getIsEnded());
        }
        String query = String.format(sql, "", filter.toString());
        this.gatherEvents(query, inRangeQueryParams, builderGroups, unused -> true);
        if (afterRangeParams != null) {
            this.gatherEvents(sqlAfter, afterRangeParams, builderGroups, event -> builderGroups.containsKey(event.getGroupId()));
        }
        ArrayList<Transport.EventGroup> groups = new ArrayList<Transport.EventGroup>();
        builderGroups.values().forEach(builder -> groups.add(builder.build()));
        return groups;
    }

    public void insertBytes(@NotNull long streamId, @NotNull String id, @NotNull Transport.BytesResponse response) {
        this.execute(Statements.INSERT_BYTES, streamId, id, response.toByteArray());
    }

    @Nullable
    public Transport.BytesResponse getBytes(@NotNull Transport.BytesRequest request) {
        try {
            ResultSet results = this.executeQuery(Statements.GET_BYTES, request.getStreamId(), request.getId());
            if (results.next()) {
                return Transport.BytesResponse.parseFrom((byte[])results.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
        return null;
    }

    private void gatherEvents(String sql, List<Object> params, HashMap<Long, Transport.EventGroup.Builder> builderGroups, Predicate<Common.Event> filter) {
        try {
            ResultSet results = this.executeOneTimeQuery(sql, params.toArray());
            while (results.next()) {
                Common.Event event = (Common.Event)Common.Event.parser().parseFrom(results.getBytes(1));
                if (!filter.test(event)) continue;
                Transport.EventGroup.Builder group = builderGroups.computeIfAbsent(event.getGroupId(), key -> Transport.EventGroup.newBuilder().setGroupId(key.longValue()));
                group.addEvents(event);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
    }

    private List<Common.Event> queryUnifiedEvents(Statements stmt, Object ... args) {
        ArrayList<Common.Event> records = new ArrayList<Common.Event>();
        try {
            ResultSet results = this.executeQuery(stmt, args);
            while (results.next()) {
                records.add((Common.Event)Common.Event.parser().parseFrom(results.getBytes(1)));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
        return records;
    }

    public static enum Statements {
        INSERT_EVENT("INSERT OR IGNORE INTO [UnifiedEventsTable] (StreamId, ProcessId, GroupId, Kind, CommandId, Timestamp, Data) VALUES (?, ?, ?, ?, ?, ?, ?)"),
        QUERY_EVENTS("SELECT Data FROM [UnifiedEventsTable]"),
        INSERT_BYTES("INSERT OR IGNORE INTO [BytesTable] (StreamId, Id, Data) VALUES (?, ?, ?)"),
        GET_BYTES("SELECT Data FROM [BytesTable] WHERE StreamId = ? AND Id = ?");

        @NotNull
        private final String mySqlStatement;

        private Statements(String sqlStatement) {
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            return this.mySqlStatement;
        }
    }
}

