/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.energy;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.energy.PowerProfile;
import com.android.tools.datastore.poller.EnergyDataPoller;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.google.common.primitives.Doubles;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CpuConfig {
    @NotNull
    private final LogService myLogService;
    private final int[] myCpuCoreMinFreqInKhz;
    private final int[] myCpuCoreMaxFreqInKhz;
    private final int myBigCoreMaxFrequency;
    private final boolean myIsMinMaxCoreFreqValid;

    public CpuConfig(@NotNull CpuProfiler.CpuCoreConfigResponse message, @NotNull LogService logService) {
        boolean isValidCpuCoreConfig;
        this.myCpuCoreMinFreqInKhz = new int[message.getConfigsCount()];
        this.myCpuCoreMaxFreqInKhz = new int[message.getConfigsCount()];
        this.myLogService = logService;
        boolean[] myIsCpuCorePopulated = new boolean[message.getConfigsCount()];
        boolean bl = isValidCpuCoreConfig = message.getConfigsCount() > 0;
        if (isValidCpuCoreConfig) {
            for (CpuProfiler.CpuCoreConfigResponse.CpuCoreConfigData config : message.getConfigsList()) {
                int core = config.getCore();
                if (core >= message.getConfigsCount() || myIsCpuCorePopulated[core]) {
                    this.getLogger().debug(core > message.getConfigsCount() ? String.format("Core index %d is >= the number of configs (%d) reported.", core, message.getConfigsCount()) : "Core index already populated.");
                    isValidCpuCoreConfig = false;
                    break;
                }
                myIsCpuCorePopulated[core] = true;
                int minFreq = config.getMinFrequencyInKhz();
                int maxFreq = config.getMaxFrequencyInKhz();
                if (minFreq <= 0 || minFreq >= maxFreq) {
                    this.getLogger().debug(minFreq <= 0 ? String.format("Min frequency %d <= 0.", minFreq) : String.format("Min frequency %d >= max frequency of %d.", minFreq, maxFreq));
                    isValidCpuCoreConfig = false;
                    break;
                }
                this.myCpuCoreMinFreqInKhz[core] = minFreq;
                this.myCpuCoreMaxFreqInKhz[core] = maxFreq;
            }
            this.myIsMinMaxCoreFreqValid = isValidCpuCoreConfig;
            if (this.myIsMinMaxCoreFreqValid) {
                int maxFrequency = 0;
                for (int coreMax : this.myCpuCoreMaxFreqInKhz) {
                    if (coreMax <= maxFrequency) continue;
                    maxFrequency = coreMax;
                }
                this.myBigCoreMaxFrequency = maxFrequency;
            } else {
                this.myBigCoreMaxFrequency = 0;
            }
        } else {
            this.getLogger().debug("No valid configs found!");
            this.myIsMinMaxCoreFreqValid = false;
            this.myBigCoreMaxFrequency = 0;
        }
    }

    @NotNull
    public PowerProfile.CpuCoreUsage[] getCpuCoreUsages(@NotNull Cpu.CpuUsageData prevUsageData, Cpu.CpuUsageData currUsageData) {
        int coreCount = currUsageData.getCoresCount();
        if (coreCount != prevUsageData.getCoresCount()) {
            this.getLogger().info(String.format("CPU config changing from %d to %d cores.", prevUsageData.getCoresCount(), coreCount));
            return new PowerProfile.CpuCoreUsage[0];
        }
        PowerProfile.CpuCoreUsage[] cpuCoresUtilization = new PowerProfile.CpuCoreUsage[coreCount];
        if (this.myIsMinMaxCoreFreqValid) {
            double system = currUsageData.getSystemCpuTimeInMillisec() - prevUsageData.getSystemCpuTimeInMillisec();
            double appSystemRatio = (double)(currUsageData.getAppCpuTimeInMillisec() - prevUsageData.getAppCpuTimeInMillisec()) / system;
            List coresUsageData = currUsageData.getCoresList();
            List prevCoresUsageData = prevUsageData.getCoresList();
            for (int i = 0; i < coreCount; ++i) {
                Cpu.CpuCoreUsageData currCore = (Cpu.CpuCoreUsageData)coresUsageData.get(i);
                Cpu.CpuCoreUsageData prevCore = (Cpu.CpuCoreUsageData)prevCoresUsageData.get(i);
                assert (i < this.myCpuCoreMinFreqInKhz.length);
                int minFreqKhz = this.myCpuCoreMinFreqInKhz[i];
                int maxFreqKhz = this.myCpuCoreMaxFreqInKhz[i];
                double elapsedCore = currCore.getElapsedTimeInMillisec() - prevCore.getElapsedTimeInMillisec();
                double corePercent = (double)(currCore.getSystemCpuTimeInMillisec() - prevCore.getSystemCpuTimeInMillisec()) / elapsedCore;
                cpuCoresUtilization[i] = new PowerProfile.CpuCoreUsage(currCore.getCore(), appSystemRatio, corePercent, minFreqKhz, maxFreqKhz, currCore.getFrequencyInKhz(), currCore.getFrequencyInKhz() != this.myBigCoreMaxFrequency);
            }
        } else {
            double elapsed = currUsageData.getElapsedTimeInMillisec() - prevUsageData.getElapsedTimeInMillisec();
            double appElapsedRatio = (double)(currUsageData.getAppCpuTimeInMillisec() - prevUsageData.getAppCpuTimeInMillisec()) / elapsed;
            double normalizedCoreShares = appElapsedRatio * (double)coreCount;
            for (int i = 0; i < coreCount; ++i) {
                cpuCoresUtilization[i] = new PowerProfile.CpuCoreUsage(i, Doubles.constrainToRange((double)normalizedCoreShares, (double)0.0, (double)1.0), 1.0, 0, 1, 1, false);
                normalizedCoreShares -= 1.0;
            }
        }
        return cpuCoresUtilization;
    }

    public boolean getIsMinMaxCoreFreqValid() {
        return this.myIsMinMaxCoreFreqValid;
    }

    @NotNull
    private LogService.Logger getLogger() {
        return this.myLogService.getLogger(EnergyDataPoller.class);
    }
}

