/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.CpuTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CpuDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private long myTraceInfoRequestStartTimestampNs = Long.MIN_VALUE;
    @NotNull
    private final CpuServiceGrpc.CpuServiceBlockingStub myPollingService;
    @NotNull
    private final CpuTable myCpuTable;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final LogService myLogService;

    public CpuDataPoller(@NotNull Common.Session session, @NotNull CpuTable table, @NotNull CpuServiceGrpc.CpuServiceBlockingStub pollingService, @NotNull LogService logService) {
        super(POLLING_DELAY_NS);
        this.myCpuTable = table;
        this.myPollingService = pollingService;
        this.mySession = session;
        this.myLogService = logService;
    }

    @Override
    public void poll() throws StatusRuntimeException {
        long getDataStartNs = this.myDataRequestStartTimestampNs;
        CpuProfiler.CpuDataRequest.Builder request = CpuProfiler.CpuDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(getDataStartNs).setEndTimestamp(Long.MAX_VALUE);
        CpuProfiler.CpuDataResponse response = this.myPollingService.getData(request.build());
        for (Cpu.CpuUsageData data : response.getDataList()) {
            getDataStartNs = Math.max(getDataStartNs, data.getEndTimestamp());
            this.myCpuTable.insert(this.mySession, data);
        }
        long getThreadsStartNs = this.myDataRequestStartTimestampNs;
        CpuProfiler.GetThreadsRequest.Builder threadsRequest = CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(getThreadsStartNs).setEndTimestamp(Long.MAX_VALUE);
        CpuProfiler.GetThreadsResponse threadsResponse = this.myPollingService.getThreads(threadsRequest.build());
        if (this.myDataRequestStartTimestampNs == Long.MIN_VALUE) {
            CpuProfiler.GetThreadsResponse.ThreadSnapshot snapshot = threadsResponse.getInitialSnapshot();
            getThreadsStartNs = Math.max(getThreadsStartNs, snapshot.getTimestamp());
            this.myCpuTable.insertSnapshot(this.mySession, snapshot.getTimestamp(), snapshot.getThreadsList());
        }
        for (CpuProfiler.GetThreadsResponse.Thread thread2 : threadsResponse.getThreadsList()) {
            List activities = thread2.getActivitiesList();
            int count = thread2.getActivitiesCount();
            if (count > 0) {
                CpuProfiler.GetThreadsResponse.ThreadActivity last = (CpuProfiler.GetThreadsResponse.ThreadActivity)activities.get(count - 1);
                getThreadsStartNs = Math.max(getThreadsStartNs, last.getTimestamp());
            }
            this.myCpuTable.insertActivities(this.mySession, thread2.getTid(), thread2.getName(), activities);
        }
        CpuProfiler.ProfilingStateRequest profilingStateRequest = CpuProfiler.ProfilingStateRequest.newBuilder().setSession(this.mySession).build();
        this.myCpuTable.insertProfilingStateData(this.mySession, this.myPollingService.checkAppProfilingState(profilingStateRequest));
        CpuProfiler.GetTraceInfoRequest.Builder traceInfoRequest = CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(this.mySession).setFromTimestamp(this.myTraceInfoRequestStartTimestampNs).setToTimestamp(Long.MAX_VALUE);
        CpuProfiler.GetTraceInfoResponse traceInfoResponse = this.myPollingService.getTraceInfo(traceInfoRequest.build());
        for (Cpu.CpuTraceInfo traceInfo : traceInfoResponse.getTraceInfoList()) {
            if (!traceInfo.getInitiationType().equals((Object)Cpu.TraceInitiationType.INITIATED_BY_API)) continue;
            CpuProfiler.GetTraceRequest.Builder traceRequest = CpuProfiler.GetTraceRequest.newBuilder().setSession(this.mySession).setTraceId(traceInfo.getTraceId());
            CpuProfiler.GetTraceResponse traceResponse = this.myPollingService.getTrace(traceRequest.build());
            File tempTraceFile = new File(String.format("%s/cpu_automated_trace_%d.trace", System.getProperty("java.io.tmpdir"), traceInfo.getTraceId()));
            tempTraceFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempTraceFile);){
                out.write(traceResponse.getData().toByteArray());
            }
            catch (IOException ex) {
                this.myLogService.getLogger(CpuDataPoller.class).warn("Failed to create temp file for automated trace.");
            }
            this.myCpuTable.insertTrace(this.mySession, traceInfo.getTraceId(), traceResponse.getTraceType(), traceResponse.getTraceMode(), traceResponse.getData());
            Cpu.CpuTraceInfo updatedTraceInfo = traceInfo.toBuilder().setTraceFilePath(tempTraceFile.getAbsolutePath()).build();
            this.myCpuTable.insertTraceInfo(this.mySession, updatedTraceInfo);
        }
        this.myTraceInfoRequestStartTimestampNs = traceInfoResponse.getResponseTimestamp();
        this.myDataRequestStartTimestampNs = Math.max(Math.max(this.myDataRequestStartTimestampNs + 1L, getDataStartNs), getThreadsStartNs);
    }

    @Override
    public void stop() {
        CpuProfiler.ProfilingStateResponse response = CpuProfiler.ProfilingStateResponse.newBuilder().setBeingProfiled(false).setCheckTimestamp(Long.MAX_VALUE).build();
        this.myCpuTable.insertProfilingStateData(this.mySession, response);
        super.stop();
    }
}

