/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.EnergyTable;
import com.android.tools.datastore.energy.BatteryModel;
import com.android.tools.datastore.energy.CpuConfig;
import com.android.tools.datastore.energy.PowerProfile;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnergyDataPoller
extends PollRunner {
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final LogService myLogService;
    @NotNull
    private final BatteryModel myBatteryModel;
    @NotNull
    private final EnergyTable myEnergyTable;
    @NotNull
    private final EnergyServiceGrpc.EnergyServiceBlockingStub myEnergyService;
    private long myDataRequestStartTimestampNs;
    @Nullable
    private Cpu.CpuUsageData myLastData = null;
    private PowerProfile.NetworkType myLastKnownNetworkType = PowerProfile.NetworkType.NONE;
    @NotNull
    private TransportServiceGrpc.TransportServiceBlockingStub myTransportService;
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myCpuService;
    @NotNull
    private NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    private long myLastRetryTime = 0L;
    private int myCpuConfigRetries = 5;
    @NotNull
    private CpuConfig myCpuConfig;

    public EnergyDataPoller(@NotNull Common.Session session, @NotNull BatteryModel batteryModel, @NotNull EnergyTable eventTable, @NotNull TransportServiceGrpc.TransportServiceBlockingStub transportService, @NotNull CpuServiceGrpc.CpuServiceBlockingStub cpuService, @NotNull NetworkServiceGrpc.NetworkServiceBlockingStub networkService, @NotNull EnergyServiceGrpc.EnergyServiceBlockingStub energyService, @NotNull LogService logService) {
        super(POLLING_DELAY_NS);
        this.myBatteryModel = batteryModel;
        this.myEnergyTable = eventTable;
        this.myTransportService = transportService;
        this.myCpuService = cpuService;
        this.myNetworkService = networkService;
        this.myEnergyService = energyService;
        this.mySession = session;
        this.myLogService = logService;
        this.myDataRequestStartTimestampNs = this.queryCurrentTime();
        CpuProfiler.CpuCoreConfigResponse response = CpuProfiler.CpuCoreConfigResponse.getDefaultInstance();
        try {
            this.myLastRetryTime = System.currentTimeMillis();
            response = this.myCpuService.getCpuCoreConfig(CpuProfiler.CpuCoreConfigRequest.newBuilder().setDeviceId(session.getStreamId()).build());
        }
        catch (StatusRuntimeException e) {
            this.getLog().debug("Unable to parse CPU frequency files.", e);
        }
        this.myCpuConfig = new CpuConfig(response, this.myLogService);
    }

    private long queryCurrentTime() {
        Transport.TimeRequest timeRequest = Transport.TimeRequest.newBuilder().setStreamId(this.mySession.getStreamId()).build();
        return this.myTransportService.getCurrentTime(timeRequest).getTimestampNs();
    }

    @Override
    public void poll() throws StatusRuntimeException {
        long endTimestampNs = this.queryCurrentTime();
        EnergyProfiler.EnergyRequest request = EnergyProfiler.EnergyRequest.newBuilder().setSession(this.mySession).setStartTimestamp(this.myDataRequestStartTimestampNs).setEndTimestamp(endTimestampNs).build();
        this.addLatestEvents(request);
        this.addLatestSamples(request);
        this.myDataRequestStartTimestampNs = endTimestampNs;
    }

    private void addLatestEvents(@NotNull EnergyProfiler.EnergyRequest request) {
        for (EnergyProfiler.EnergyEvent event : this.myEnergyService.getEvents(request).getEventsList()) {
            if (event.hasLocationUpdateRequested()) {
                this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_REGISTER, new PowerProfile.LocationEvent(event.getEventId(), PowerProfile.LocationType.from(event.getLocationUpdateRequested().getRequest().getProvider())));
            }
            if (event.hasLocationChanged()) {
                this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_UPDATE, new PowerProfile.LocationEvent(event.getEventId(), PowerProfile.LocationType.from(event.getLocationChanged().getLocation().getProvider())));
            }
            if (event.hasLocationUpdateRemoved()) {
                this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_UNREGISTER, new PowerProfile.LocationEvent(event.getEventId(), PowerProfile.LocationType.NONE));
            }
            this.myEnergyTable.insertOrReplace(this.mySession, event);
        }
    }

    private void addLatestSamples(@NotNull EnergyProfiler.EnergyRequest request) {
        NetworkProfiler.NetworkDataRequest networkDataRequest = NetworkProfiler.NetworkDataRequest.newBuilder().setSession(request.getSession()).setStartTimestamp(request.getStartTimestamp()).setEndTimestamp(request.getEndTimestamp()).setType(NetworkProfiler.NetworkDataRequest.Type.ALL).build();
        NetworkProfiler.NetworkDataResponse networkDataResponse = this.myNetworkService.getData(networkDataRequest);
        for (NetworkProfiler.NetworkProfilerData networkData : networkDataResponse.getDataList()) {
            switch (networkData.getDataCase()) {
                case CONNECTIVITY_DATA: {
                    this.myLastKnownNetworkType = PowerProfile.NetworkType.from(networkData.getConnectivityData().getNetworkType());
                    break;
                }
                case SPEED_DATA: {
                    NetworkProfiler.SpeedData speedData = networkData.getSpeedData();
                    this.myBatteryModel.handleEvent(networkData.getEndTimestamp(), BatteryModel.Event.NETWORK_USAGE, new PowerProfile.NetworkStats(this.myLastKnownNetworkType, speedData.getReceived(), speedData.getSent()));
                    break;
                }
            }
        }
        if (!this.myCpuConfig.getIsMinMaxCoreFreqValid() && this.myCpuConfigRetries > 0 && (this.myLastRetryTime = System.currentTimeMillis()) - this.myLastRetryTime > TimeUnit.SECONDS.toMillis(1L)) {
            --this.myCpuConfigRetries;
            this.myLastRetryTime = System.currentTimeMillis();
            try {
                this.myCpuConfig = new CpuConfig(this.myCpuService.getCpuCoreConfig(CpuProfiler.CpuCoreConfigRequest.newBuilder().setDeviceId(this.mySession.getStreamId()).build()), this.myLogService);
            }
            catch (StatusRuntimeException e) {
                this.getLog().debug(String.format("Unable to parse CPU frequency files. Retries remaining: %d", this.myCpuConfigRetries), e);
            }
        }
        CpuProfiler.CpuDataRequest cpuDataRequest = CpuProfiler.CpuDataRequest.newBuilder().setSession(request.getSession()).setStartTimestamp(request.getStartTimestamp()).setEndTimestamp(request.getEndTimestamp()).build();
        CpuProfiler.CpuDataResponse cpuDataResponse = this.myCpuService.getData(cpuDataRequest);
        Cpu.CpuUsageData prevUsageData = this.myLastData;
        for (Cpu.CpuUsageData currUsageData : cpuDataResponse.getDataList()) {
            if (prevUsageData == null) {
                prevUsageData = currUsageData;
                continue;
            }
            this.myBatteryModel.handleEvent(currUsageData.getEndTimestamp(), BatteryModel.Event.CPU_USAGE, this.myCpuConfig.getCpuCoreUsages(prevUsageData, currUsageData));
            prevUsageData = currUsageData;
        }
        for (EnergyProfiler.EnergySample sample : this.myBatteryModel.getSamplesBetween(request.getStartTimestamp(), request.getEndTimestamp())) {
            this.myEnergyTable.insertOrReplace(this.mySession, sample);
        }
    }

    @NotNull
    private LogService.Logger getLog() {
        return this.myLogService.getLogger(EnergyDataPoller.class);
    }
}

