/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.EnergyTable;
import com.android.tools.datastore.energy.BatteryModel;
import com.android.tools.datastore.poller.EnergyDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.datastore.service.ResponseData;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class EnergyService
extends EnergyServiceGrpc.EnergyServiceImplBase
implements ServicePassThrough {
    private final BatteryModel myBatteryModel;
    private final EnergyTable myEnergyTable;
    @NotNull
    private final DataStoreService myService;
    private final Map<Long, PollRunner> myRunners = new HashMap<Long, PollRunner>();
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private final LogService myLogService;
    private ResponseData<EnergyProfiler.EnergySamplesResponse> myLastSamplesResponse = ResponseData.createEmpty();
    private ResponseData<EnergyProfiler.EnergyEventsResponse> myLastEventsResponse = ResponseData.createEmpty();

    public EnergyService(@NotNull DataStoreService service, @NotNull Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        this(new BatteryModel(), service, fetchExecutor, logService);
    }

    public EnergyService(@NotNull BatteryModel batteryModel, @NotNull DataStoreService service, Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        this.myBatteryModel = batteryModel;
        this.myService = service;
        this.myFetchExecutor = fetchExecutor;
        this.myLogService = logService;
        this.myEnergyTable = new EnergyTable();
    }

    public void startMonitoringApp(EnergyProfiler.EnergyStartRequest request, StreamObserver<EnergyProfiler.EnergyStartResponse> responseObserver) {
        long streamId = request.getSession().getStreamId();
        EnergyServiceGrpc.EnergyServiceBlockingStub energyClient = this.myService.getEnergyClient(streamId);
        CpuServiceGrpc.CpuServiceBlockingStub cpuClient = this.myService.getCpuClient(streamId);
        NetworkServiceGrpc.NetworkServiceBlockingStub networkClient = this.myService.getNetworkClient(streamId);
        TransportServiceGrpc.TransportServiceBlockingStub transportClient = this.myService.getTransportClient(streamId);
        if (energyClient != null && transportClient != null) {
            responseObserver.onNext((Object)energyClient.startMonitoringApp(request));
            responseObserver.onCompleted();
            long sessionId = request.getSession().getSessionId();
            this.myRunners.put(sessionId, new EnergyDataPoller(request.getSession(), this.myBatteryModel, this.myEnergyTable, transportClient, cpuClient, networkClient, energyClient, this.myLogService));
            this.myFetchExecutor.accept(this.myRunners.get(sessionId));
        } else {
            responseObserver.onNext((Object)EnergyProfiler.EnergyStartResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    public void stopMonitoringApp(EnergyProfiler.EnergyStopRequest request, StreamObserver<EnergyProfiler.EnergyStopResponse> responseObserver) {
        EnergyServiceGrpc.EnergyServiceBlockingStub client;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((client = this.myService.getEnergyClient(request.getSession().getStreamId())) == null) {
            responseObserver.onNext((Object)EnergyProfiler.EnergyStopResponse.getDefaultInstance());
        } else {
            responseObserver.onNext((Object)client.stopMonitoringApp(request));
        }
        responseObserver.onCompleted();
    }

    public void getSamples(EnergyProfiler.EnergyRequest request, StreamObserver<EnergyProfiler.EnergySamplesResponse> responseObserver) {
        if (!this.myLastSamplesResponse.matches(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            EnergyProfiler.EnergySamplesResponse.Builder response = EnergyProfiler.EnergySamplesResponse.newBuilder();
            List<EnergyProfiler.EnergySample> samples = this.myEnergyTable.getSamples(request);
            response.addAllSamples(samples);
            this.myLastSamplesResponse = new ResponseData<EnergyProfiler.EnergySamplesResponse>(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        responseObserver.onNext((Object)this.myLastSamplesResponse.getResponse());
        responseObserver.onCompleted();
    }

    public void getEvents(EnergyProfiler.EnergyRequest request, StreamObserver<EnergyProfiler.EnergyEventsResponse> responseObserver) {
        if (!this.myLastEventsResponse.matches(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            EnergyProfiler.EnergyEventsResponse.Builder response = EnergyProfiler.EnergyEventsResponse.newBuilder();
            List<EnergyProfiler.EnergyEvent> events = this.myEnergyTable.getEvents(request);
            response.addAllEvents(events);
            this.myLastEventsResponse = new ResponseData<EnergyProfiler.EnergyEventsResponse>(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        responseObserver.onNext((Object)this.myLastEventsResponse.getResponse());
        responseObserver.onCompleted();
    }

    public void getEventGroup(EnergyProfiler.EnergyEventGroupRequest request, StreamObserver<EnergyProfiler.EnergyEventsResponse> responseObserver) {
        EnergyProfiler.EnergyEventsResponse.Builder response = EnergyProfiler.EnergyEventsResponse.newBuilder();
        List<EnergyProfiler.EnergyEvent> events = this.myEnergyTable.getEventGroup(request);
        response.addAllEvents(events);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myEnergyTable.initialize(connection);
    }
}

