/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.EventsTable;
import com.android.tools.datastore.poller.EventDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class EventService
extends EventServiceGrpc.EventServiceImplBase
implements ServicePassThrough {
    private static final int INCLUDED_STATE_CHANGES_BEFORE_START_COUNT = 3;
    private final EventsTable myEventsTable;
    private final Map<Long, PollRunner> myRunners = new HashMap<Long, PollRunner>();
    private final Consumer<Runnable> myFetchExecutor;
    private final DataStoreService myService;

    public EventService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor) {
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myEventsTable = new EventsTable();
    }

    public void getActivityData(EventProfiler.EventDataRequest request, StreamObserver<EventProfiler.ActivityDataResponse> responseObserver) {
        EventProfiler.ActivityDataResponse.Builder response = EventProfiler.ActivityDataResponse.newBuilder();
        Common.Session session = request.getSession();
        List<EventProfiler.ActivityData> activities = this.myEventsTable.getActivityDataBySession(session);
        for (EventProfiler.ActivityData data : activities) {
            EventProfiler.ActivityStateData state;
            int firstIndexGreaterThanStart;
            EventProfiler.ActivityData.Builder builder = EventProfiler.ActivityData.newBuilder();
            builder.setName(data.getName());
            builder.setHash(data.getHash());
            builder.setActivityContextHash(data.getActivityContextHash());
            for (firstIndexGreaterThanStart = 0; firstIndexGreaterThanStart < data.getStateChangesCount() && data.getStateChanges(firstIndexGreaterThanStart).getTimestamp() < request.getStartTimestamp(); ++firstIndexGreaterThanStart) {
            }
            for (int i = firstIndexGreaterThanStart = Math.max(0, firstIndexGreaterThanStart - 3); i < data.getStateChangesCount() && (state = data.getStateChanges(i)).getTimestamp() <= request.getEndTimestamp(); ++i) {
                builder.addStateChanges(state);
            }
            response.addData(builder);
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getSystemData(EventProfiler.EventDataRequest request, StreamObserver<EventProfiler.SystemDataResponse> responseObserver) {
        EventProfiler.SystemDataResponse.Builder response = EventProfiler.SystemDataResponse.newBuilder();
        List<EventProfiler.SystemData> systemData = this.myEventsTable.getSystemDataByRequest(request);
        for (EventProfiler.SystemData data : systemData) {
            response.addData(data);
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void startMonitoringApp(EventProfiler.EventStartRequest request, StreamObserver<EventProfiler.EventStartResponse> observer) {
        EventServiceGrpc.EventServiceBlockingStub client = this.myService.getEventClient(request.getSession().getStreamId());
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            Common.Session session = request.getSession();
            this.myRunners.put(session.getSessionId(), new EventDataPoller(session, this.myEventsTable, client));
            this.myFetchExecutor.accept(this.myRunners.get(session.getSessionId()));
        } else {
            observer.onNext((Object)EventProfiler.EventStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(EventProfiler.EventStopRequest request, StreamObserver<EventProfiler.EventStopResponse> observer) {
        EventServiceGrpc.EventServiceBlockingStub client;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((client = this.myService.getEventClient(request.getSession().getStreamId())) == null) {
            observer.onNext((Object)EventProfiler.EventStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)client.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myEventsTable.initialize(connection);
    }
}

