/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreDatabase;
import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.MemoryLiveAllocationTable;
import com.android.tools.datastore.database.MemoryStatsTable;
import com.android.tools.datastore.poller.MemoryDataPoller;
import com.android.tools.datastore.poller.MemoryJvmtiDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MemoryService
extends MemoryServiceGrpc.MemoryServiceImplBase
implements ServicePassThrough {
    private static final DataStoreService.BackingNamespace LIVE_ALLOCATION_NAMESPACE = new DataStoreService.BackingNamespace("LiveAllocations", DataStoreDatabase.Characteristic.PERFORMANT);
    private final Map<Long, PollRunner> myRunners = new HashMap<Long, PollRunner>();
    private final Map<Long, PollRunner> myJvmtiRunners = new HashMap<Long, PollRunner>();
    private final MemoryStatsTable myStatsTable;
    private final MemoryLiveAllocationTable myAllocationsTable;
    private final Consumer<Runnable> myFetchExecutor;
    private final DataStoreService myService;
    private final LogService myLogService;

    public MemoryService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        this.myLogService = logService;
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myStatsTable = new MemoryStatsTable();
        this.myAllocationsTable = new MemoryLiveAllocationTable(this.myLogService);
    }

    public void startMonitoringApp(MemoryProfiler.MemoryStartRequest request, StreamObserver<MemoryProfiler.MemoryStartResponse> observer) {
        long streamId = request.getSession().getStreamId();
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(streamId);
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            Common.Session session = request.getSession();
            long sessionId = session.getSessionId();
            this.myJvmtiRunners.put(sessionId, new MemoryJvmtiDataPoller(session, this.myAllocationsTable, client));
            this.myRunners.put(sessionId, new MemoryDataPoller(session, this.myStatsTable, client, this.myFetchExecutor));
            this.myFetchExecutor.accept(this.myJvmtiRunners.get(sessionId));
            this.myFetchExecutor.accept(this.myRunners.get(sessionId));
        } else {
            observer.onNext((Object)MemoryProfiler.MemoryStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(MemoryProfiler.MemoryStopRequest request, StreamObserver<MemoryProfiler.MemoryStopResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub service;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((runner = this.myJvmtiRunners.remove(sessionId)) != null) {
            runner.stop();
        }
        if ((service = this.myService.getMemoryClient(request.getSession().getStreamId())) == null) {
            observer.onNext((Object)MemoryProfiler.MemoryStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)service.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    public void triggerHeapDump(MemoryProfiler.TriggerHeapDumpRequest request, StreamObserver<MemoryProfiler.TriggerHeapDumpResponse> responseObserver) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession().getStreamId());
        MemoryProfiler.TriggerHeapDumpResponse response = MemoryProfiler.TriggerHeapDumpResponse.getDefaultInstance();
        if (client != null && (response = client.triggerHeapDump(request)).getStatus() == MemoryProfiler.TriggerHeapDumpResponse.Status.SUCCESS) {
            assert (response.getInfo() != null);
            this.myStatsTable.insertOrReplaceHeapInfo(request.getSession(), response.getInfo());
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getHeapDump(MemoryProfiler.DumpDataRequest request, StreamObserver<MemoryProfiler.DumpDataResponse> responseObserver) {
        MemoryProfiler.DumpDataResponse.Builder responseBuilder = MemoryProfiler.DumpDataResponse.newBuilder();
        MemoryProfiler.DumpDataResponse.Status status = this.myStatsTable.getHeapDumpStatus(request.getSession(), request.getDumpTime());
        switch (status) {
            case SUCCESS: {
                byte[] data = this.myStatsTable.getHeapDumpData(request.getSession(), request.getDumpTime());
                assert (data != null);
                responseBuilder.setData(ByteString.copyFrom((byte[])data));
                responseBuilder.setStatus(status);
                break;
            }
            case NOT_READY: 
            case FAILURE_UNKNOWN: 
            case NOT_FOUND: {
                responseBuilder.setStatus(status);
                break;
            }
            default: {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
            }
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void listHeapDumpInfos(MemoryProfiler.ListDumpInfosRequest request, StreamObserver<MemoryProfiler.ListHeapDumpInfosResponse> responseObserver) {
        MemoryProfiler.ListHeapDumpInfosResponse.Builder responseBuilder = MemoryProfiler.ListHeapDumpInfosResponse.newBuilder();
        List<MemoryProfiler.HeapDumpInfo> dump = this.myStatsTable.getHeapDumpInfoByRequest(request.getSession(), request);
        responseBuilder.addAllInfos(dump);
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void importHeapDump(MemoryProfiler.ImportHeapDumpRequest request, StreamObserver<MemoryProfiler.ImportHeapDumpResponse> responseObserver) {
        MemoryProfiler.ImportHeapDumpResponse.Builder responseBuilder = MemoryProfiler.ImportHeapDumpResponse.newBuilder();
        this.myStatsTable.insertOrReplaceHeapInfo(request.getSession(), request.getInfo());
        this.myStatsTable.insertHeapDumpData(request.getSession(), request.getInfo().getStartTime(), MemoryProfiler.DumpDataResponse.Status.SUCCESS, request.getData());
        responseBuilder.setStatus(MemoryProfiler.ImportHeapDumpResponse.Status.SUCCESS);
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void trackAllocations(MemoryProfiler.TrackAllocationsRequest request, StreamObserver<MemoryProfiler.TrackAllocationsResponse> responseObserver) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession().getStreamId());
        MemoryProfiler.TrackAllocationsResponse response = MemoryProfiler.TrackAllocationsResponse.getDefaultInstance();
        if (client != null) {
            response = client.trackAllocations(request);
            if (request.getEnabled() && response.getStatus() == MemoryProfiler.TrackAllocationsResponse.Status.SUCCESS) {
                assert (response.getInfo() != null);
                this.myStatsTable.insertOrReplaceAllocationsInfo(request.getSession(), response.getInfo());
            }
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void importLegacyAllocations(MemoryProfiler.ImportLegacyAllocationsRequest request, StreamObserver<MemoryProfiler.ImportLegacyAllocationsResponse> responseObserver) {
        assert (request.getInfo().getLegacy());
        this.myStatsTable.insertOrReplaceAllocationsInfo(request.getSession(), request.getInfo());
        MemoryProfiler.AllocationContextsResponse contexts = request.getContexts();
        MemoryProfiler.LegacyAllocationEventsResponse allocations = request.getAllocations();
        if (!contexts.equals((Object)MemoryProfiler.AllocationContextsResponse.getDefaultInstance())) {
            this.myStatsTable.insertLegacyAllocationContext(request.getSession(), contexts.getAllocatedClassesList(), contexts.getAllocationStacksList());
        }
        if (!allocations.equals((Object)MemoryProfiler.LegacyAllocationEventsResponse.getDefaultInstance())) {
            this.myStatsTable.updateLegacyAllocationEvents(request.getSession(), request.getInfo().getStartTime(), allocations);
        }
        responseObserver.onNext((Object)MemoryProfiler.ImportLegacyAllocationsResponse.newBuilder().setStatus(MemoryProfiler.ImportLegacyAllocationsResponse.Status.SUCCESS).build());
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationContexts(MemoryProfiler.LegacyAllocationContextsRequest request, StreamObserver<MemoryProfiler.AllocationContextsResponse> responseObserver) {
        responseObserver.onNext((Object)this.myStatsTable.getLegacyAllocationContexts(request));
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationDump(MemoryProfiler.DumpDataRequest request, StreamObserver<MemoryProfiler.DumpDataResponse> responseObserver) {
        MemoryProfiler.DumpDataResponse.Builder responseBuilder = MemoryProfiler.DumpDataResponse.newBuilder();
        MemoryProfiler.AllocationsInfo response = this.myStatsTable.getAllocationsInfo(request.getSession(), request.getDumpTime());
        if (response == null) {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.NOT_FOUND);
        } else if (response.getStatus() == MemoryProfiler.AllocationsInfo.Status.FAILURE_UNKNOWN) {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
        } else if (response.getLegacy()) {
            byte[] data = this.myStatsTable.getLegacyAllocationDumpData(request.getSession(), request.getDumpTime());
            if (data == null) {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.NOT_READY);
            } else {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.SUCCESS);
                responseBuilder.setData(ByteString.copyFrom((byte[])data));
            }
        } else {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void getStackFrameInfo(MemoryProfiler.StackFrameInfoRequest request, StreamObserver<MemoryProfiler.StackFrameInfoResponse> responseObserver) {
        responseObserver.onNext((Object)this.myAllocationsTable.getStackFrameInfo(request.getSession(), request.getMethodId()));
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationEvents(MemoryProfiler.LegacyAllocationEventsRequest request, StreamObserver<MemoryProfiler.LegacyAllocationEventsResponse> responseObserver) {
        MemoryProfiler.LegacyAllocationEventsResponse.Builder builder = MemoryProfiler.LegacyAllocationEventsResponse.newBuilder();
        MemoryProfiler.AllocationsInfo response = this.myStatsTable.getAllocationsInfo(request.getSession(), request.getStartTime());
        if (response == null) {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_FOUND);
        } else if (response.getStatus() == MemoryProfiler.AllocationsInfo.Status.FAILURE_UNKNOWN) {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.FAILURE_UNKNOWN);
        } else if (response.getLegacy()) {
            MemoryProfiler.LegacyAllocationEventsResponse events = this.myStatsTable.getLegacyAllocationData(request.getSession(), request.getStartTime());
            if (events == null) {
                builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_READY);
            } else {
                builder.mergeFrom(events);
            }
        } else {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.FAILURE_UNKNOWN);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void getData(MemoryProfiler.MemoryRequest request, StreamObserver<MemoryProfiler.MemoryData> responseObserver) {
        MemoryProfiler.MemoryData response = this.myStatsTable.getData(request);
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getJvmtiData(MemoryProfiler.MemoryRequest request, StreamObserver<MemoryProfiler.MemoryData> responseObserver) {
        MemoryProfiler.MemoryData response = MemoryProfiler.MemoryData.newBuilder().addAllAllocSamplingRateEvents(this.myAllocationsTable.getAllocationSamplingRateEvents(request.getSession().getSessionId(), request.getStartTime(), request.getEndTime())).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getAllocations(MemoryProfiler.AllocationSnapshotRequest request, StreamObserver<MemoryProfiler.BatchAllocationSample> responseObserver) {
        MemoryProfiler.BatchAllocationSample response = request.getLiveObjectsOnly() ? this.myAllocationsTable.getSnapshot(request.getSession(), request.getEndTime()) : this.myAllocationsTable.getAllocations(request.getSession(), request.getStartTime(), request.getEndTime());
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getJNIGlobalRefsEvents(MemoryProfiler.JNIGlobalRefsEventsRequest request, StreamObserver<MemoryProfiler.BatchJNIGlobalRefEvent> responseObserver) {
        MemoryProfiler.BatchJNIGlobalRefEvent result = request.getLiveObjectsOnly() ? this.myAllocationsTable.getJniReferencesSnapshot(request.getSession(), request.getEndTime()) : this.myAllocationsTable.getJniReferencesEventsFromRange(request.getSession(), request.getStartTime(), request.getEndTime());
        responseObserver.onNext((Object)result);
        responseObserver.onCompleted();
    }

    public void resolveNativeBacktrace(MemoryProfiler.ResolveNativeBacktraceRequest request, StreamObserver<MemoryProfiler.NativeCallStack> responseObserver) {
        MemoryProfiler.NativeCallStack callStack = this.myAllocationsTable.resolveNativeBacktrace(request.getSession(), request.getBacktrace());
        responseObserver.onNext((Object)callStack);
        responseObserver.onCompleted();
    }

    public void getLatestAllocationTime(MemoryProfiler.LatestAllocationTimeRequest request, StreamObserver<MemoryProfiler.LatestAllocationTimeResponse> responseObserver) {
        MemoryProfiler.LatestAllocationTimeResponse response = this.myAllocationsTable.getLatestDataTimestamp(request.getSession());
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getAllocationContexts(MemoryProfiler.AllocationContextsRequest request, StreamObserver<MemoryProfiler.AllocationContextsResponse> responseObserver) {
        MemoryProfiler.AllocationContextsResponse response = this.myAllocationsTable.getAllocationContexts(request.getSession(), request.getStartTime(), request.getEndTime());
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void forceGarbageCollection(MemoryProfiler.ForceGarbageCollectionRequest request, StreamObserver<MemoryProfiler.ForceGarbageCollectionResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession().getStreamId());
        if (client != null) {
            observer.onNext((Object)client.forceGarbageCollection(request));
        } else {
            observer.onNext((Object)MemoryProfiler.ForceGarbageCollectionResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void setAllocationSamplingRate(MemoryProfiler.SetAllocationSamplingRateRequest request, StreamObserver<MemoryProfiler.SetAllocationSamplingRateResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession().getStreamId());
        if (client != null) {
            observer.onNext((Object)client.setAllocationSamplingRate(request));
        } else {
            observer.onNext((Object)MemoryProfiler.SetAllocationSamplingRateResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Arrays.asList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE, LIVE_ALLOCATION_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (this.getBackingNamespaces().contains(namespace));
        if (namespace.equals(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE)) {
            this.myStatsTable.initialize(connection);
        } else {
            this.myAllocationsTable.initialize(connection);
        }
    }
}

