/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ContentType {
    BMP,
    CSV,
    GIF,
    HTML,
    JPEG,
    JPG,
    JSON,
    PNG,
    WEBP,
    XML,
    DEFAULT;

    private static final ImmutableSet<ContentType> IMAGE_TYPES;
    private static final ImmutableSet<ContentType> TEXT_TYPES;
    private static final Map<ContentType, FileType> FILE_TYPE_MAP;
    private String myType = "";

    @NotNull
    public String getType() {
        return this.myType;
    }

    private ContentType withType(@NotNull String type) {
        this.myType = type;
        return this;
    }

    public boolean isSupportedTextType() {
        return "text".equalsIgnoreCase(this.getType()) || TEXT_TYPES.contains((Object)this);
    }

    public boolean isSupportedImageType() {
        return IMAGE_TYPES.contains((Object)this);
    }

    @Nullable
    public FileType getFileType() {
        return FILE_TYPE_MAP.containsKey((Object)this) ? FILE_TYPE_MAP.get((Object)this) : null;
    }

    @NotNull
    private static ContentType get(@NotNull String type, @NotNull String subtype) {
        for (ContentType contentType : ContentType.values()) {
            if (!subtype.equalsIgnoreCase(contentType.name())) continue;
            return contentType.withType(type);
        }
        return DEFAULT.withType(type);
    }

    @NotNull
    public static ContentType fromMimeType(@NotNull String mimeType) {
        String[] typeAndSubType = mimeType.split("/", 2);
        if (typeAndSubType.length < 2) {
            return typeAndSubType.length == 1 ? DEFAULT.withType(typeAndSubType[0]) : DEFAULT;
        }
        String[] subTypeAndSuffix = typeAndSubType[1].split("\\+", 2);
        return ContentType.get(typeAndSubType[0], subTypeAndSuffix[subTypeAndSuffix.length - 1]);
    }

    static {
        IMAGE_TYPES = ImmutableSet.of((Object)((Object)BMP), (Object)((Object)GIF), (Object)((Object)JPEG), (Object)((Object)JPG), (Object)((Object)PNG), (Object)((Object)WEBP), (Object[])new ContentType[0]);
        TEXT_TYPES = ImmutableSet.of((Object)((Object)CSV), (Object)((Object)HTML), (Object)((Object)JSON), (Object)((Object)XML));
        FILE_TYPE_MAP = new ImmutableMap.Builder().put((Object)CSV, (Object)FileTypeManager.getInstance().getStdFileType("CSV")).put((Object)HTML, (Object)StdFileTypes.HTML).put((Object)JSON, (Object)FileTypeManager.getInstance().getStdFileType("JSON")).put((Object)XML, (Object)StdFileTypes.XML).build();
    }
}

