/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.profilers.DragAndDropModelListElement;
import com.intellij.util.containers.OrderedSet;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragAndDropListModel<T extends DragAndDropModelListElement>
extends DefaultListModel<T> {
    private static final String UNSUPPORTED_EXCEPTION_STRING = "Do not call DefaultListModel functions directly, use drag and drop operations for managing elements.";
    @NotNull
    private final OrderedSet<OrderedElement<T>> myOrderedElements = new OrderedSet();

    public void moveElementTo(@NotNull T element, int toPosition) {
        OrderedElement<T> searchElement = new OrderedElement<T>(element);
        int index = this.myOrderedElements.indexOf(searchElement);
        OrderedElement orderedElement = (OrderedElement)this.myOrderedElements.remove(index);
        if (toPosition > this.myOrderedElements.size()) {
            toPosition = this.myOrderedElements.size();
        }
        this.myOrderedElements.add(toPosition, (Object)orderedElement);
        super.removeElement(orderedElement.getElement());
        if (toPosition > this.getSize()) {
            toPosition = this.getSize();
        }
        super.add(toPosition, orderedElement.getElement());
    }

    protected void clearOrderedElements() {
        this.myOrderedElements.clear();
        super.removeAllElements();
    }

    protected void removeOrderedElement(@NotNull T element) {
        OrderedElement<T> searchElement = new OrderedElement<T>(element);
        int index = this.myOrderedElements.indexOf(searchElement);
        assert (index != -1);
        super.removeElement(element);
        ((OrderedElement)this.myOrderedElements.get(index)).setElement(null);
    }

    protected void insertOrderedElement(@NotNull T element) {
        int i = 0;
        for (OrderedElement orderedElement : this.myOrderedElements) {
            if (orderedElement.getId() == element.getId()) {
                orderedElement.setElement(element);
                super.add(i, element);
                return;
            }
            if (!orderedElement.hasElement()) continue;
            ++i;
        }
        this.myOrderedElements.add(new OrderedElement<T>(element));
        super.addElement(element);
    }

    @Override
    public void removeElementAt(int index) {
        throw new UnsupportedOperationException(UNSUPPORTED_EXCEPTION_STRING);
    }

    @Override
    public void addElement(T element) {
        throw new UnsupportedOperationException(UNSUPPORTED_EXCEPTION_STRING);
    }

    @Override
    public boolean removeElement(Object obj) {
        throw new UnsupportedOperationException(UNSUPPORTED_EXCEPTION_STRING);
    }

    @Override
    public void removeAllElements() {
        throw new UnsupportedOperationException(UNSUPPORTED_EXCEPTION_STRING);
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException(UNSUPPORTED_EXCEPTION_STRING);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException(UNSUPPORTED_EXCEPTION_STRING);
    }

    private static final class OrderedElement<T extends DragAndDropModelListElement> {
        private int myId;
        @Nullable
        private T myElement;

        public OrderedElement(@NotNull T element) {
            this.myId = element.getId();
            this.myElement = element;
        }

        public int getId() {
            return this.myId;
        }

        @Nullable
        public T getElement() {
            return this.myElement;
        }

        public void setElement(@Nullable T element) {
            this.myElement = element;
        }

        public boolean hasElement() {
            return this.myElement != null;
        }

        public int hashCode() {
            return this.getId();
        }

        public boolean equals(Object obj) {
            return obj instanceof OrderedElement && this.getId() == ((OrderedElement)obj).getId();
        }
    }
}

