/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.StudioProfilers;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilerMonitor
extends AspectModel<Aspect> {
    public static final int LEGEND_UPDATE_FREQUENCY_MS = 100;
    @NotNull
    protected final StudioProfilers myProfilers;
    private boolean myFocus;

    public ProfilerMonitor(@NotNull StudioProfilers profilers) {
        this.myProfilers = profilers;
    }

    @NotNull
    public final ProfilerTimeline getTimeline() {
        return this.myProfilers.getTimeline();
    }

    public abstract void exit();

    public abstract void enter();

    @NotNull
    public StudioProfilers getProfilers() {
        return this.myProfilers;
    }

    public void expand() {
    }

    public boolean canExpand() {
        return true;
    }

    public abstract String getName();

    public abstract ProfilerTooltip buildTooltip();

    public void setFocus(boolean focus) {
        if (focus != this.myFocus) {
            this.myFocus = focus;
            this.changed(Aspect.FOCUS);
        }
    }

    public boolean isFocused() {
        return this.myFocus;
    }

    public boolean isEnabled() {
        return true;
    }

    public static enum Aspect {
        FOCUS,
        ENABLE;

    }
}

