/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerTimeline;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilerTooltipView
extends AspectObserver {
    @NotNull
    private final ProfilerTimeline myTimeline;
    @NotNull
    private final JLabel myHeadingLabel;
    protected final Font myFont;

    protected ProfilerTooltipView(@NotNull ProfilerTimeline timeline) {
        this.myTimeline = timeline;
        this.myHeadingLabel = new JLabel();
        this.myHeadingLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.myFont = ProfilerFonts.TOOLTIP_HEADER_FONT;
        this.myHeadingLabel.setFont(this.myFont);
        timeline.getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::timeChanged);
    }

    @VisibleForTesting
    public String getHeadingText() {
        return this.myHeadingLabel.getText();
    }

    private void timeChanged() {
        this.updateHeader();
        this.updateTooltip();
    }

    private void updateHeader() {
        Range range = this.myTimeline.getTooltipRange();
        if (!range.isEmpty() && range.getMin() >= this.myTimeline.getDataRange().getMin()) {
            String time = TimeFormatter.getSemiSimplifiedClockString((long)((long)(range.getMin() - this.myTimeline.getDataRange().getMin())));
            this.myHeadingLabel.setText(time);
        } else {
            this.myHeadingLabel.setText("");
        }
    }

    protected void updateTooltip() {
    }

    @NotNull
    protected abstract JComponent createTooltip();

    protected static JLabel createTooltipLabel() {
        JLabel label = new JLabel();
        label.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        label.setForeground(ProfilerColors.TOOLTIP_TEXT);
        return label;
    }

    public final JComponent createComponent() {
        TooltipPanel tooltipPanel = new TooltipPanel((LayoutManager)new TabularLayout("Fit", "Fit-,8px,Fit"));
        tooltipPanel.add((Component)this.myHeadingLabel, new TabularLayout.Constraint(0, 0));
        tooltipPanel.add((Component)this.createTooltip(), new TabularLayout.Constraint(2, 0));
        tooltipPanel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        tooltipPanel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        Border visibleBorder = JBUI.Borders.customLine((Color)StudioColorsKt.getBorderLight());
        tooltipPanel.setBorder(JBUI.Borders.merge((Border)new JBEmptyBorder(9, 9, 9, 9), (Border)visibleBorder, (boolean)true));
        this.updateHeader();
        new TreeWalker((Component)tooltipPanel).descendantStream().forEach(component -> component.setBackground(tooltipPanel.getBackground()));
        return tooltipPanel;
    }

    public void dispose() {
        this.myTimeline.getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private static class TooltipPanel
    extends JPanel {
        public TooltipPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        @Override
        public void doLayout() {
            Rectangle oldBounds = this.getBounds();
            Dimension preferredSize = this.getPreferredSize();
            this.setBounds(oldBounds.x, oldBounds.y, preferredSize.width, preferredSize.height);
            super.doLayout();
        }
    }
}

