/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.StudioProfilers;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Stage
extends AspectObserver {
    protected static final long PROFILING_INSTRUCTIONS_EASE_OUT_NS = TimeUnit.SECONDS.toNanos(3L);
    private final StudioProfilers myProfilers;
    private ProfilerMode myProfilerMode = ProfilerMode.NORMAL;
    @Nullable
    private ProfilerTooltip myTooltip;

    public Stage(@NotNull StudioProfilers profilers) {
        this.myProfilers = profilers;
    }

    public StudioProfilers getStudioProfilers() {
        return this.myProfilers;
    }

    public abstract void enter();

    public abstract void exit();

    @NotNull
    public final ProfilerMode getProfilerMode() {
        return this.myProfilerMode;
    }

    @Nullable
    public ProfilerTooltip getTooltip() {
        return this.myTooltip;
    }

    protected final void setProfilerMode(@NotNull ProfilerMode profilerMode) {
        if (this.myProfilerMode != profilerMode) {
            this.myProfilerMode = profilerMode;
            this.getStudioProfilers().modeChanged();
        }
    }

    public void setTooltip(ProfilerTooltip tooltip) {
        if (tooltip != null && this.myTooltip != null && tooltip.getClass().equals(this.myTooltip.getClass())) {
            return;
        }
        if (this.myTooltip != null) {
            this.myTooltip.dispose();
        }
        this.myTooltip = tooltip;
        this.getStudioProfilers().changed(ProfilerAspect.TOOLTIP);
    }
}

