/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.ViewBinder;
import com.intellij.ui.components.JBPanel;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class StageView<T extends Stage>
extends AspectObserver {
    private final T myStage;
    private final JPanel myComponent;
    private final StudioProfilersView myProfilersView;
    private final JPanel myTooltipPanel;
    private ProfilerTooltipView myActiveTooltipView;
    private final ViewBinder<StageView, ProfilerTooltip, ProfilerTooltipView> myTooltipBinder;
    @NotNull
    private final JLabel mySelectionTimeLabel;

    public StageView(@NotNull StudioProfilersView profilersView, @NotNull T stage) {
        this.myProfilersView = profilersView;
        this.myStage = stage;
        this.myComponent = new JBPanel((LayoutManager)new BorderLayout());
        this.myComponent.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myTooltipPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.myTooltipPanel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myTooltipBinder = new ViewBinder();
        this.mySelectionTimeLabel = this.createSelectionTimeLabel();
        ((Stage)((Object)stage)).getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.TOOLTIP, this::tooltipChanged);
        ((Stage)((Object)stage)).getStudioProfilers().getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::selectionChanged);
        this.selectionChanged();
    }

    @NotNull
    public T getStage() {
        return this.myStage;
    }

    @NotNull
    public StudioProfilersView getProfilersView() {
        return this.myProfilersView;
    }

    @NotNull
    public IdeProfilerComponents getIdeComponents() {
        return this.myProfilersView.getIdeProfilerComponents();
    }

    @NotNull
    public final JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public final ProfilerTimeline getTimeline() {
        return ((Stage)((Object)this.myStage)).getStudioProfilers().getTimeline();
    }

    public ViewBinder<StageView, ProfilerTooltip, ProfilerTooltipView> getTooltipBinder() {
        return this.myTooltipBinder;
    }

    public JPanel getTooltipPanel() {
        return this.myTooltipPanel;
    }

    @NotNull
    public JLabel getSelectionTimeLabel() {
        return this.mySelectionTimeLabel;
    }

    @NotNull
    protected JComponent buildTimeAxis(StudioProfilers profilers) {
        JPanel axisPanel = new JPanel(new BorderLayout());
        axisPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        AxisComponent timeAxis = new AxisComponent(profilers.getViewAxis(), AxisComponent.AxisOrientation.BOTTOM);
        timeAxis.setShowAxisLine(false);
        timeAxis.setMinimumSize(new Dimension(0, ProfilerLayout.TIME_AXIS_HEIGHT));
        timeAxis.setPreferredSize(new Dimension(Integer.MAX_VALUE, ProfilerLayout.TIME_AXIS_HEIGHT));
        axisPanel.add((Component)timeAxis, "Center");
        return axisPanel;
    }

    public abstract JComponent getToolbar();

    public boolean isToolbarVisible() {
        return true;
    }

    public boolean navigationControllersEnabled() {
        return true;
    }

    public boolean needsProcessSelection() {
        return false;
    }

    protected void tooltipChanged() {
        if (this.myActiveTooltipView != null) {
            this.myActiveTooltipView.dispose();
            this.myActiveTooltipView = null;
        }
        this.myTooltipPanel.removeAll();
        this.myTooltipPanel.setVisible(false);
        if (((Stage)((Object)this.myStage)).getTooltip() != null) {
            this.myActiveTooltipView = this.myTooltipBinder.build(this, ((Stage)((Object)this.myStage)).getTooltip());
            this.myTooltipPanel.add(this.myActiveTooltipView.createComponent());
            this.myTooltipPanel.setVisible(true);
        }
        this.myTooltipPanel.invalidate();
        this.myTooltipPanel.repaint();
    }

    private void selectionChanged() {
        ProfilerTimeline timeline = ((Stage)((Object)this.myStage)).getStudioProfilers().getTimeline();
        Range selectionRange = timeline.getSelectionRange();
        if (selectionRange.isEmpty()) {
            this.mySelectionTimeLabel.setIcon(null);
            this.mySelectionTimeLabel.setText("");
            return;
        }
        long selectionMinUs = timeline.convertToRelativeTimeUs(TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMin()));
        long selectionMaxUs = timeline.convertToRelativeTimeUs(TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMax()));
        this.mySelectionTimeLabel.setIcon(StudioIcons.Profiler.Toolbar.CLOCK);
        if (selectionRange.isPoint()) {
            this.mySelectionTimeLabel.setText(TimeFormatter.getSimplifiedClockString((long)selectionMinUs));
        } else {
            this.mySelectionTimeLabel.setText(String.format("%s - %s", TimeFormatter.getSimplifiedClockString((long)selectionMinUs), TimeFormatter.getSimplifiedClockString((long)selectionMaxUs)));
        }
    }

    @NotNull
    private JLabel createSelectionTimeLabel() {
        JLabel selectionTimeLabel = new JLabel("");
        selectionTimeLabel.setFont(ProfilerFonts.STANDARD_FONT);
        selectionTimeLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        selectionTimeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProfilerTimeline timeline = ((Stage)((Object)StageView.this.getStage())).getStudioProfilers().getTimeline();
                timeline.frameViewToRange(timeline.getSelectionRange());
            }
        });
        selectionTimeLabel.setToolTipText("Selected range");
        selectionTimeLabel.setCursor(Cursor.getPredefinedCursor(12));
        return selectionTimeLabel;
    }
}

