/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.FpsTimer;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StopwatchTimer;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.energy.EnergyProfiler;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.event.EventProfiler;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.network.NetworkProfiler;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.text.StringUtil;
import io.grpc.StatusRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProfilers
extends AspectModel<ProfilerAspect>
implements Updatable {
    @VisibleForTesting
    static final int AGENT_STATUS_MAX_RETRY_COUNT = 10;
    public static final int PROFILERS_UPDATE_RATE = 60;
    @NotNull
    private final ProfilerClient myClient;
    private final ProfilerTimeline myTimeline;
    private final List<StudioProfiler> myProfilers;
    @NotNull
    private final IdeProfilerServices myIdeServices;
    private Map<Common.Device, List<Common.Process>> myProcesses;
    private Map<Common.Device, Long> myStreamIds;
    @NotNull
    private final SessionsManager mySessionsManager;
    @Nullable
    private Common.Process myProcess;
    @NotNull
    private Common.AgentData myAgentData;
    @Nullable
    private String myPreferredDeviceName;
    @Nullable
    private String myPreferredProcessName;
    private Predicate<Common.Process> myPreferredProcessFilter;
    private Common.Device myDevice;
    @NotNull
    private Common.Session mySelectedSession;
    @NotNull
    private Common.Session myProfilingSession;
    @NotNull
    private Stage myStage;
    private Updater myUpdater;
    private AxisComponentModel myViewAxis;
    private long myRefreshDevices;
    private final Map<Common.SessionMetaData.SessionType, Runnable> mySessionChangeListener;
    private boolean myAutoProfilingEnabled;
    public final Map<Long, Integer> mySessionIdToAgentStatusRetryMap = new HashMap<Long, Integer>();

    public StudioProfilers(@NotNull ProfilerClient client, @NotNull IdeProfilerServices ideServices) {
        this(client, ideServices, (StopwatchTimer)new FpsTimer(60));
    }

    @VisibleForTesting
    public StudioProfilers(@NotNull ProfilerClient client, @NotNull IdeProfilerServices ideServices, @NotNull StopwatchTimer timer) {
        this.myClient = client;
        this.myIdeServices = ideServices;
        this.myPreferredProcessName = null;
        this.myPreferredProcessFilter = null;
        this.myStage = new NullMonitorStage(this);
        this.mySessionsManager = new SessionsManager(this);
        this.mySessionChangeListener = new HashMap<Common.SessionMetaData.SessionType, Runnable>();
        this.myStreamIds = new HashMap<Common.Device, Long>();
        this.myStage.enter();
        this.myUpdater = new Updater(timer);
        ImmutableList.Builder profilersBuilder = new ImmutableList.Builder();
        profilersBuilder.add((Object)new EventProfiler(this));
        profilersBuilder.add((Object)new CpuProfiler(this));
        profilersBuilder.add((Object)new MemoryProfiler(this));
        profilersBuilder.add((Object)new NetworkProfiler(this));
        if (this.myIdeServices.getFeatureConfig().isEnergyProfilerEnabled()) {
            profilersBuilder.add((Object)new EnergyProfiler(this));
        }
        this.myProfilers = profilersBuilder.build();
        this.myTimeline = new ProfilerTimeline(this.myUpdater);
        this.myProcesses = Maps.newHashMap();
        this.myDevice = null;
        this.myProcess = null;
        this.mySelectedSession = this.myProfilingSession = Common.Session.getDefaultInstance();
        this.myAgentData = Common.AgentData.getDefaultInstance();
        this.myTimeline.getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> {
            if (!this.myTimeline.getSelectionRange().isEmpty()) {
                this.myTimeline.setStreaming(false);
            }
        });
        this.registerSessionChangeListener(Common.SessionMetaData.SessionType.FULL, () -> {
            this.setStage(new StudioMonitorStage(this));
            if (SessionsManager.isSessionAlive(this.mySelectedSession)) {
                Transport.TimeResponse timeResponse = this.myClient.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.mySelectedSession.getStreamId()).build());
                this.myTimeline.reset(this.mySelectedSession.getStartTimestamp(), timeResponse.getTimestampNs());
                if (this.startupCpuProfilingStarted()) {
                    this.setStage(new CpuProfilerStage(this));
                }
            } else {
                this.myTimeline.reset(this.mySelectedSession.getStartTimestamp(), this.mySelectedSession.getEndTimestamp());
                this.myTimeline.setIsPaused(true);
                this.myTimeline.setStreaming(false);
                this.myTimeline.getViewRange().set(this.mySessionsManager.getSessionPreferredViewRange(this.mySelectedSession));
            }
        });
        this.mySessionsManager.addDependency((AspectObserver)this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::selectedSessionChanged).onChange((Enum)SessionAspect.PROFILING_SESSION, this::profilingSessionChanged);
        this.myViewAxis = new ResizingAxisComponentModel.Builder(this.myTimeline.getViewRange(), (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).setGlobalRange(this.myTimeline.getDataRange()).build();
        this.myUpdater.register((Updatable)this);
    }

    public boolean isStopped() {
        return !this.myUpdater.isRunning();
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.myUpdater.stop();
        this.setProcess(null, null);
        this.changed(ProfilerAspect.STAGE);
    }

    public Map<Common.Device, List<Common.Process>> getDeviceProcessMap() {
        return this.myProcesses;
    }

    public List<Common.Device> getDevices() {
        return Lists.newArrayList(this.myProcesses.keySet());
    }

    public void setPreferredProcess(@Nullable String deviceName, @Nullable String processName, @Nullable Predicate<Common.Process> processFilter) {
        this.myIdeServices.getFeatureTracker().trackAutoProfilingRequested();
        this.myPreferredDeviceName = deviceName;
        this.setPreferredProcessName(processName);
        this.myPreferredProcessFilter = processFilter;
        this.setAutoProfilingEnabled(true);
        this.changed(ProfilerAspect.PREFERRED_PROCESS);
    }

    public void setPreferredProcessName(@Nullable String processName) {
        this.myPreferredProcessName = processName;
    }

    @Nullable
    public String getPreferredProcessName() {
        return this.myPreferredProcessName;
    }

    public void setAutoProfilingEnabled(boolean enabled) {
        this.myAutoProfilingEnabled = enabled;
        if (this.myAutoProfilingEnabled) {
            this.setProcess(this.findPreferredDevice(), null);
        }
    }

    public boolean getAutoProfilingEnabled() {
        return this.myAutoProfilingEnabled;
    }

    private List<Common.Device> getUpToDateDevices() {
        return StudioProfilers.getUpToDateDevices(this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled(), this.myClient, this.myStreamIds);
    }

    @NotNull
    public static List<Common.Device> getUpToDateDevices(boolean isUnifiedPipelineEnabled, @NotNull ProfilerClient client, @Nullable Map<Common.Device, Long> streamIds) {
        LinkedList<Common.Device> devices = new LinkedList();
        if (isUnifiedPipelineEnabled) {
            Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(-1L).setKind(Common.Event.Kind.STREAM).build();
            Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(request);
            for (Transport.EventGroup group : response.getGroupsList()) {
                Common.Stream stream;
                boolean isStreamDead = group.getEvents(group.getEventsCount() - 1).getIsEnded();
                Common.Event connectedEvent = StudioProfilers.getLastMatchingEvent(group, e -> e.hasStream() && e.getStream().hasStreamConnected());
                if (connectedEvent == null || (stream = connectedEvent.getStream().getStreamConnected().getStream()).getType() != Common.Stream.Type.DEVICE) continue;
                if (isStreamDead) {
                    stream = stream.toBuilder().setDevice(stream.getDevice().toBuilder().setState(Common.Device.State.DISCONNECTED)).build();
                }
                if (streamIds != null) {
                    streamIds.putIfAbsent(stream.getDevice(), stream.getStreamId());
                }
                devices.add(stream.getDevice());
            }
        } else {
            Transport.GetDevicesResponse response = client.getTransportClient().getDevices(Transport.GetDevicesRequest.getDefaultInstance());
            devices = response.getDeviceList();
        }
        return devices;
    }

    public void update(long elapsedNs) {
        this.myRefreshDevices += elapsedNs;
        if (this.myRefreshDevices < TimeUnit.SECONDS.toNanos(1L)) {
            return;
        }
        this.myRefreshDevices = 0L;
        try {
            HashMap<Common.Device, List<Common.Process>> newProcesses = new HashMap<Common.Device, List<Common.Process>>();
            List<Common.Device> devices = this.getUpToDateDevices();
            if (this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled()) {
                for (Common.Device device : devices) {
                    Transport.GetEventGroupsRequest processRequest = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamIds.get(device).longValue()).setKind(Common.Event.Kind.PROCESS).build();
                    Transport.GetEventGroupsResponse processResponse = this.myClient.getTransportClient().getEventGroups(processRequest);
                    ArrayList<Common.Process> processList = new ArrayList<Common.Process>();
                    int lastProcessId = this.myProcess == null ? 0 : this.myProcess.getPid();
                    for (Transport.EventGroup groupProcess : processResponse.getGroupsList()) {
                        boolean isProcessAlive = !groupProcess.getEvents(groupProcess.getEventsCount() - 1).getIsEnded();
                        Common.Event aliveEvent = StudioProfilers.getLastMatchingEvent(groupProcess, e -> e.hasProcess() && e.getProcess().hasProcessStarted());
                        if (aliveEvent == null) continue;
                        Common.Process process2 = aliveEvent.getProcess().getProcessStarted().getProcess();
                        if (isProcessAlive || process2.getPid() == lastProcessId) {
                            if (!isProcessAlive) {
                                process2 = process2.toBuilder().setState(Common.Process.State.DEAD).build();
                            }
                            processList.add(process2);
                        }
                        newProcesses.put(device, processList);
                    }
                }
            } else {
                for (Common.Device device : devices) {
                    Transport.GetProcessesRequest request = Transport.GetProcessesRequest.newBuilder().setDeviceId(device.getDeviceId()).build();
                    Transport.GetProcessesResponse processes = this.myClient.getTransportClient().getProcesses(request);
                    int lastProcessId = this.myProcess == null ? 0 : this.myProcess.getPid();
                    List processList = processes.getProcessList().stream().filter(process -> process.getState() == Common.Process.State.ALIVE || process.getPid() == lastProcessId).collect(Collectors.toList());
                    newProcesses.put(device, processList);
                }
            }
            if (!newProcesses.equals(this.myProcesses)) {
                this.myProcesses = newProcesses;
                this.setProcess(this.findPreferredDevice(), null);
                this.changed(ProfilerAspect.PROCESSES);
            }
            this.mySessionsManager.update();
            if (SessionsManager.isSessionAlive(this.mySelectedSession)) {
                Common.AgentData agentData = this.getAgentData(this.mySelectedSession);
                int agentStatusRetryCount = this.mySessionIdToAgentStatusRetryMap.getOrDefault(this.mySelectedSession.getSessionId(), 0) + 1;
                if (agentData.getStatus() == Common.AgentData.Status.UNSPECIFIED && agentStatusRetryCount >= 10) {
                    agentData = Common.AgentData.newBuilder().setStatus(Common.AgentData.Status.UNATTACHABLE).build();
                }
                this.mySessionIdToAgentStatusRetryMap.put(this.mySelectedSession.getSessionId(), agentStatusRetryCount);
                if (!this.myAgentData.equals((Object)agentData)) {
                    if (this.myAgentData.getStatus() != Common.AgentData.Status.ATTACHED && agentData.getStatus() == Common.AgentData.Status.ATTACHED) {
                        this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
                    }
                    this.myAgentData = agentData;
                    this.changed(ProfilerAspect.AGENT);
                }
            }
        }
        catch (StatusRuntimeException e2) {
            System.err.println("Cannot find profiler service, retrying...");
        }
    }

    @Nullable
    private Common.Device findPreferredDevice() {
        Set<Common.Device> devices = this.myProcesses.keySet();
        Set onlineDevices = devices.stream().filter(device -> device.getState().equals((Object)Common.Device.State.ONLINE)).collect(Collectors.toSet());
        if (this.myAutoProfilingEnabled && this.myPreferredDeviceName != null) {
            for (Common.Device device2 : onlineDevices) {
                if (!this.myPreferredDeviceName.equals(StudioProfilers.buildDeviceName(device2))) continue;
                return device2;
            }
        }
        if (this.myDevice != null) {
            for (Common.Device device2 : devices) {
                if (this.myDevice.getDeviceId() != device2.getDeviceId()) continue;
                return device2;
            }
        }
        return null;
    }

    public void setMonitoringStage() {
        this.setStage(new StudioMonitorStage(this));
    }

    public void setProcess(@Nullable Common.Device device, @Nullable Common.Process process) {
        if (device != null) {
            this.myPreferredDeviceName = null;
        }
        if (!Objects.equals(device, this.myDevice)) {
            this.mySessionsManager.endCurrentSession();
            this.myDevice = device;
            this.myIdeServices.getFeatureTracker().trackChangeDevice(this.myDevice);
        }
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        if (process == null || processes == null || !processes.contains(process)) {
            process = this.getPreferredProcess(processes);
        } else {
            this.setAutoProfilingEnabled(false);
        }
        if (!Objects.equals(process, this.myProcess)) {
            this.mySessionsManager.endCurrentSession();
            this.myProcess = process;
            this.changed(ProfilerAspect.PROCESSES);
            this.myIdeServices.getFeatureTracker().trackChangeProcess(this.myProcess);
            if (this.myProcess != null && this.myProcess.getState() == Common.Process.State.ALIVE) {
                if (this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled()) {
                    this.mySessionsManager.beginSession(this.myStreamIds.get(this.myDevice), this.myDevice, this.myProcess);
                } else {
                    this.mySessionsManager.beginSession(this.myDevice, this.myProcess);
                }
            }
        }
    }

    public void registerSessionChangeListener(Common.SessionMetaData.SessionType sessionType, Runnable listener) {
        this.mySessionChangeListener.put(sessionType, listener);
    }

    private void selectedSessionChanged() {
        Common.Session newSession = this.mySessionsManager.getSelectedSession();
        if (this.mySelectedSession.getSessionId() == newSession.getSessionId() && SessionsManager.isSessionAlive(this.mySelectedSession) && !SessionsManager.isSessionAlive(newSession)) {
            this.mySelectedSession = newSession;
            this.myTimeline.setIsPaused(true);
            return;
        }
        this.mySelectedSession = newSession;
        this.myAgentData = this.getAgentData(this.mySelectedSession);
        if (Common.Session.getDefaultInstance().equals((Object)newSession)) {
            this.myTimeline.setIsPaused(true);
            this.setStage(new NullMonitorStage(this));
            return;
        }
        Common.SessionMetaData.SessionType sessionType = this.mySessionsManager.getSelectedSessionMetaData().getType();
        assert (this.mySessionChangeListener.containsKey(sessionType));
        this.mySessionChangeListener.get(sessionType).run();
        this.changed(ProfilerAspect.AGENT);
    }

    private void profilingSessionChanged() {
        Common.Session newSession = this.mySessionsManager.getProfilingSession();
        if (!Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            assert (SessionsManager.isSessionAlive(this.myProfilingSession));
            this.myProfilers.forEach(profiler -> profiler.stopProfiling(this.myProfilingSession));
        }
        this.myProfilingSession = newSession;
        if (!Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            assert (SessionsManager.isSessionAlive(this.myProfilingSession));
            this.myProfilers.forEach(profiler -> profiler.startProfiling(this.myProfilingSession));
            this.myIdeServices.getFeatureTracker().trackProfilingStarted();
            if (this.getAgentData(this.myProfilingSession).getStatus() == Common.AgentData.Status.ATTACHED) {
                this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
            }
        }
    }

    private boolean startupCpuProfilingStarted() {
        if (!this.getIdeServices().getFeatureConfig().isStartupCpuProfilingEnabled()) {
            return false;
        }
        CpuProfiler.ProfilingStateResponse response = this.getClient().getCpuClient().checkAppProfilingState(CpuProfiler.ProfilingStateRequest.newBuilder().setSession(this.mySelectedSession).build());
        return response.getBeingProfiled() && response.getIsStartupProfiling();
    }

    @Nullable
    private Common.Process getPreferredProcess(List<Common.Process> processes) {
        if (processes == null || processes.isEmpty()) {
            return null;
        }
        if (this.myAutoProfilingEnabled && this.myPreferredProcessName != null) {
            for (Common.Process process : processes) {
                if (!process.getName().equals(this.myPreferredProcessName) || process.getState() != Common.Process.State.ALIVE || this.myPreferredProcessFilter != null && !this.myPreferredProcessFilter.test(process)) continue;
                this.myIdeServices.getFeatureTracker().trackAutoProfilingSucceeded();
                return process;
            }
        }
        if (this.myProcess != null) {
            for (Common.Process process : processes) {
                if (!StudioProfilers.isSameProcess(this.myProcess, process) || this.myProcess.getState() != process.getState() && (this.myProcess.getState() != Common.Process.State.ALIVE || process.getState() != Common.Process.State.DEAD)) continue;
                return process;
            }
        }
        return null;
    }

    @NotNull
    private Common.AgentData getAgentData(@NotNull Common.Session session) {
        Common.AgentData agentData = Common.AgentData.getDefaultInstance();
        if (Common.Session.getDefaultInstance().equals((Object)session)) {
            return agentData;
        }
        if (!this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.AgentStatusRequest statusRequest = Transport.AgentStatusRequest.newBuilder().setPid(session.getPid()).setDeviceId(session.getStreamId()).build();
            return this.myClient.getTransportClient().getAgentStatus(statusRequest);
        }
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.AGENT).setStreamId(session.getStreamId()).setPid(session.getPid()).build();
        Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            agentData = group.getEvents(group.getEventsCount() - 1).getAgentData();
        }
        return agentData;
    }

    private static boolean isSameProcess(@Nullable Common.Process process1, @Nullable Common.Process process2) {
        return process1 != null && process2 != null && process1.getPid() == process2.getPid() && process1.getName().equals(process2.getName()) && process1.getStartTimestampNs() == process2.getStartTimestampNs();
    }

    public List<Common.Process> getProcesses() {
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        return processes == null ? ImmutableList.of() : processes;
    }

    @NotNull
    public Stage getStage() {
        return this.myStage;
    }

    @NotNull
    public ProfilerClient getClient() {
        return this.myClient;
    }

    @NotNull
    public SessionsManager getSessionsManager() {
        return this.mySessionsManager;
    }

    @NotNull
    public Common.Session getSession() {
        return this.mySelectedSession;
    }

    @NotNull
    public String getSelectedAppName() {
        String name = "";
        if (!this.getSession().equals((Object)Common.Session.getDefaultInstance())) {
            name = this.mySessionsManager.getSelectedSessionMetaData().getSessionName();
        } else if (this.myProcess != null) {
            name = this.myProcess.getName();
        }
        String[] nameSplit = name.split(" \\(", 2);
        return nameSplit.length > 0 ? nameSplit[0] : "";
    }

    public void setStage(@NotNull Stage stage) {
        this.myStage.exit();
        this.getTimeline().getSelectionRange().clear();
        this.myStage = stage;
        this.myStage.getStudioProfilers().getUpdater().reset();
        this.myStage.enter();
        this.changed(ProfilerAspect.STAGE);
    }

    @NotNull
    public ProfilerTimeline getTimeline() {
        return this.myTimeline;
    }

    @Nullable
    public Common.Device getDevice() {
        return this.myDevice;
    }

    @Nullable
    public Common.Process getProcess() {
        return this.myProcess;
    }

    public boolean isAgentAttached() {
        return this.myAgentData.getStatus() == Common.AgentData.Status.ATTACHED;
    }

    @NotNull
    public Common.AgentData getAgentData() {
        return this.myAgentData;
    }

    public List<StudioProfiler> getProfilers() {
        return this.myProfilers;
    }

    public ProfilerMode getMode() {
        return this.myStage.getProfilerMode();
    }

    public void modeChanged() {
        this.changed(ProfilerAspect.MODE);
    }

    @NotNull
    public IdeProfilerServices getIdeServices() {
        return this.myIdeServices;
    }

    public Updater getUpdater() {
        return this.myUpdater;
    }

    public AxisComponentModel getViewAxis() {
        return this.myViewAxis;
    }

    public List<Class<? extends Stage>> getDirectStages() {
        boolean isEnergyStageEnabled;
        boolean hasSession;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(CpuProfilerStage.class);
        listBuilder.add(MemoryProfilerStage.class);
        listBuilder.add(NetworkProfilerStage.class);
        boolean bl = hasSession = this.mySelectedSession.getSessionId() != 0L;
        boolean bl2 = hasSession ? this.mySessionsManager.getSelectedSessionMetaData().getJvmtiEnabled() : (isEnergyStageEnabled = this.myDevice != null && this.myDevice.getFeatureLevel() >= 26);
        if (this.getIdeServices().getFeatureConfig().isEnergyProfilerEnabled() && isEnergyStageEnabled) {
            listBuilder.add(EnergyProfilerStage.class);
        }
        return listBuilder.build();
    }

    @NotNull
    public Class<? extends Stage> getStageClass() {
        return ((Object)((Object)this.myStage)).getClass();
    }

    public void setNewStage(Class<? extends Stage> clazz) {
        try {
            Constructor<? extends Stage> constructor = clazz.getConstructor(StudioProfilers.class);
            Stage stage = constructor.newInstance(new Object[]{this});
            this.setStage(stage);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    @NotNull
    public static String buildSessionName(@NotNull Common.Device device, @NotNull Common.Process process) {
        return String.format("%s (%s)", process.getName(), StudioProfilers.buildDeviceName(device));
    }

    public void setMemoryLiveAllocationEnabled(boolean enabled) {
        int samplingRateOff;
        int savedSamplingRate;
        if (this.getIdeServices().getFeatureConfig().isLiveAllocationsSamplingEnabled() && this.getDevice() != null && this.getDevice().getFeatureLevel() >= 26 && this.isAgentAttached() && (savedSamplingRate = this.getIdeServices().getPersistentProfilerPreferences().getInt("memory.live.allocation.mode", MemoryProfilerStage.DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue())) != (samplingRateOff = MemoryProfilerStage.LiveAllocationSamplingMode.NONE.getValue())) {
            this.getClient().getMemoryClient().setAllocationSamplingRate(MemoryProfiler.SetAllocationSamplingRateRequest.newBuilder().setSession(this.getSession()).setSamplingRate(MemoryProfiler.AllocationSamplingRate.newBuilder().setSamplingNumInterval(enabled ? savedSamplingRate : samplingRateOff)).build());
        }
    }

    @NotNull
    public static String buildDeviceName(@NotNull Common.Device device) {
        StringBuilder deviceNameBuilder = new StringBuilder();
        String manufacturer = device.getManufacturer();
        String model = device.getModel();
        String serial = device.getSerial();
        String suffix = String.format("-%s", serial);
        if (model.endsWith(suffix)) {
            model = model.substring(0, model.length() - suffix.length());
        }
        if (!StringUtil.isEmpty((String)manufacturer)) {
            deviceNameBuilder.append(manufacturer);
            deviceNameBuilder.append(" ");
        }
        deviceNameBuilder.append(model);
        return deviceNameBuilder.toString();
    }

    @Nullable
    private static Common.Event getLastMatchingEvent(@NotNull Transport.EventGroup group, @NotNull Predicate<Common.Event> predicate) {
        Common.Event matched = null;
        for (Common.Event event : group.getEventsList()) {
            if (!predicate.test(event)) continue;
            matched = event;
        }
        return matched;
    }
}

