/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatComboBox;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.NullMonitorStageView;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerContextMenu;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioMonitorStageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.ViewBinder;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyProfilerStageView;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfilerStageView;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsView;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class StudioProfilersView
extends AspectObserver
implements Disposable {
    private static final String LOADING_VIEW_CARD = "LoadingViewCard";
    private static final String STAGE_VIEW_CARD = "StageViewCard";
    private static final int SHORTCUT_MODIFIER_MASK_NUMBER = SystemInfo.isMac ? 256 : 128;
    @NotNull
    public static final String ATTACH_LIVE = "Attach to live";
    @NotNull
    public static final String DETACH_LIVE = "Detach live";
    @NotNull
    public static final String ZOOM_IN = "Zoom in";
    @NotNull
    public static final String ZOOM_OUT = "Zoom out";
    private final StudioProfilers myProfiler;
    private final ViewBinder<StudioProfilersView, Stage, StageView> myBinder;
    private StageView myStageView;
    @NotNull
    private final ProfilerLayeredPane myLayeredPane;
    @NotNull
    private final ThreeComponentsSplitter mySplitter;
    @NotNull
    private final LoadingPanel myStageLoadingPanel;
    private final JPanel myStageComponent;
    private final JPanel myStageCenterComponent;
    private final CardLayout myStageCenterCardLayout;
    private SessionsView mySessionsView;
    private JPanel myToolbar;
    private JPanel myStageToolbar;
    private JPanel myCommonToolbar;
    private JPanel myGoLiveToolbar;
    private JToggleButton myGoLive;
    private CommonButton myZoomOut;
    private CommonButton myZoomIn;
    private CommonButton myResetZoom;
    private CommonButton myFrameSelection;
    private ProfilerAction myFrameSelectionAction;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;

    public StudioProfilersView(@NotNull StudioProfilers profiler, @NotNull IdeProfilerComponents ideProfilerComponents) {
        this.myProfiler = profiler;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myStageView = null;
        this.myStageComponent = new JPanel(new BorderLayout());
        this.myStageCenterCardLayout = new CardLayout();
        this.myStageCenterComponent = new JPanel(this.myStageCenterCardLayout);
        this.myStageLoadingPanel = this.myIdeProfilerComponents.createLoadingPanel(0);
        this.myStageLoadingPanel.setLoadingText("");
        this.myStageLoadingPanel.getComponent().setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.mySplitter = new ThreeComponentsSplitter();
        this.mySplitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        this.mySplitter.setDividerWidth(0);
        this.mySplitter.setDividerMouseZoneSize(-1);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setLastComponent((JComponent)this.myStageComponent);
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        this.myLayeredPane = new ProfilerLayeredPane((JComponent)this.mySplitter);
        this.initializeSessionUi();
        this.initializeStageUi();
        this.myBinder = new ViewBinder();
        this.myBinder.bind(StudioMonitorStage.class, StudioMonitorStageView::new);
        this.myBinder.bind(CpuProfilerStage.class, CpuProfilerStageView::new);
        this.myBinder.bind(MemoryProfilerStage.class, MemoryProfilerStageView::new);
        this.myBinder.bind(NetworkProfilerStage.class, NetworkProfilerStageView::new);
        this.myBinder.bind(NullMonitorStage.class, NullMonitorStageView::new);
        this.myBinder.bind(EnergyProfilerStage.class, EnergyProfilerStageView::new);
        this.myProfiler.addDependency(this).onChange((Enum)ProfilerAspect.STAGE, this::updateStageView).onChange((Enum)ProfilerAspect.AGENT, this::toggleStageLayout).onChange((Enum)ProfilerAspect.PREFERRED_PROCESS, this::toggleStageLayout);
        this.updateStageView();
        this.toggleStageLayout();
    }

    public void dispose() {
    }

    @VisibleForTesting
    public <S extends Stage, T extends StageView> void bind(@NotNull Class<S> clazz, @NotNull BiFunction<StudioProfilersView, S, T> constructor) {
        this.myBinder.bind(clazz, constructor);
    }

    @VisibleForTesting
    @NotNull
    CommonButton getZoomInButton() {
        return this.myZoomIn;
    }

    @VisibleForTesting
    @NotNull
    CommonButton getZoomOutButton() {
        return this.myZoomOut;
    }

    @VisibleForTesting
    @NotNull
    CommonButton getResetZoomButton() {
        return this.myResetZoom;
    }

    @VisibleForTesting
    @NotNull
    CommonButton getFrameSelectionButton() {
        return this.myFrameSelection;
    }

    @VisibleForTesting
    @NotNull
    JToggleButton getGoLiveButton() {
        return this.myGoLive;
    }

    @VisibleForTesting
    public StageView getStageView() {
        return this.myStageView;
    }

    @VisibleForTesting
    @NotNull
    SessionsView getSessionsView() {
        return this.mySessionsView;
    }

    private void initializeSessionUi() {
        this.mySessionsView = new SessionsView(this.myProfiler, this.myIdeProfilerComponents);
        final JComponent sessionsComponent = this.mySessionsView.getComponent();
        this.mySplitter.setFirstComponent(sessionsComponent);
        this.mySessionsView.addExpandListener(e -> {
            this.toggleSessionsPanel(false);
            this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelStateChanged(true);
        });
        this.mySessionsView.addCollapseListener(e -> {
            this.toggleSessionsPanel(true);
            this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelStateChanged(false);
        });
        boolean initiallyCollapsed = this.myProfiler.getIdeServices().getPersistentProfilerPreferences().getBoolean("SESSION_IS_COLLAPSED", false);
        this.toggleSessionsPanel(initiallyCollapsed);
        new UiNotifyConnector.Once((Component)this.mySplitter, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)StudioProfilersView.this.mySplitter);
                glassPane.addMousePreprocessor((MouseListener)new MouseAdapter(){
                    private int mySessionsUiWidth;

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.mySessionsUiWidth = sessionsComponent.getWidth();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        int width = sessionsComponent.getWidth();
                        if (this.mySessionsUiWidth != width) {
                            StudioProfilersView.this.myProfiler.getIdeServices().getPersistentProfilerPreferences().setInt("SESSION_EXPANDED_WIDTH", width);
                            StudioProfilersView.this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelResized();
                        }
                    }
                }, (Disposable)StudioProfilersView.this.mySplitter);
            }
        });
    }

    private void initializeStageUi() {
        this.myToolbar = new JPanel(new BorderLayout());
        JPanel leftToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myToolbar.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
        this.myToolbar.setPreferredSize(new Dimension(0, ProfilerLayout.TOOLBAR_HEIGHT));
        this.myCommonToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        CommonButton button = new CommonButton(AllIcons.Actions.Back);
        button.addActionListener(action -> {
            this.myProfiler.setMonitoringStage();
            this.myProfiler.getIdeServices().getFeatureTracker().trackGoBack();
        });
        this.myCommonToolbar.add((Component)button);
        this.myCommonToolbar.add((Component)new FlatSeparator());
        FlatComboBox stageCombo = new FlatComboBox();
        JComboBoxView<Class, ProfilerAspect> stages = new JComboBoxView<Class, ProfilerAspect>((JComboBox<Class>)stageCombo, this.myProfiler, ProfilerAspect.STAGE, this.myProfiler::getDirectStages, this.myProfiler::getStageClass, stage -> {
            this.myProfiler.getIdeServices().getFeatureTracker().trackSelectMonitor();
            this.myProfiler.setNewStage((Class<? extends Stage>)stage);
        });
        stageCombo.setRenderer(new StageComboBoxRenderer());
        stages.bind();
        this.myCommonToolbar.add((Component)stageCombo);
        this.myCommonToolbar.add((Component)new FlatSeparator());
        leftToolbar.add(this.myCommonToolbar);
        this.myToolbar.add((Component)leftToolbar, "West");
        JPanel rightToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myToolbar.add((Component)rightToolbar, "East");
        rightToolbar.setBorder((Border)new JBEmptyBorder(0, 0, 0, 2));
        ProfilerTimeline timeline = this.myProfiler.getTimeline();
        this.myZoomOut = new CommonButton(AllIcons.General.ZoomOut);
        this.myZoomOut.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.General.ZoomOut));
        this.myZoomOut.addActionListener(event -> {
            timeline.zoomOut();
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomOut();
        });
        ProfilerAction zoomOutAction = new ProfilerAction.Builder(ZOOM_OUT).setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myZoomOut.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(45, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(109, SHORTCUT_MODIFIER_MASK_NUMBER)).build();
        this.myZoomOut.setToolTipText(zoomOutAction.getDefaultToolTipText());
        rightToolbar.add((Component)this.myZoomOut);
        this.myZoomIn = new CommonButton(AllIcons.General.ZoomIn);
        this.myZoomIn.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.General.ZoomIn));
        this.myZoomIn.addActionListener(event -> {
            timeline.zoomIn();
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomIn();
        });
        ProfilerAction zoomInAction = new ProfilerAction.Builder(ZOOM_IN).setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myZoomIn.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(521, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(61, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(107, SHORTCUT_MODIFIER_MASK_NUMBER)).build();
        this.myZoomIn.setToolTipText(zoomInAction.getDefaultToolTipText());
        rightToolbar.add((Component)this.myZoomIn);
        this.myResetZoom = new CommonButton(StudioIcons.Common.RESET_ZOOM);
        this.myResetZoom.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.RESET_ZOOM));
        this.myResetZoom.addActionListener(event -> {
            timeline.resetZoom();
            this.myProfiler.getIdeServices().getFeatureTracker().trackResetZoom();
        });
        ProfilerAction resetZoomAction = new ProfilerAction.Builder("Reset zoom").setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myResetZoom.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(96, 0), KeyStroke.getKeyStroke(48, 0)).build();
        this.myResetZoom.setToolTipText(resetZoomAction.getDefaultToolTipText());
        rightToolbar.add((Component)this.myResetZoom);
        this.myFrameSelection = new CommonButton(StudioIcons.Common.ZOOM_SELECT);
        this.myFrameSelection.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.ZOOM_SELECT));
        this.myFrameSelection.addActionListener(event -> timeline.frameViewToRange(timeline.getSelectionRange()));
        this.myFrameSelectionAction = new ProfilerAction.Builder("Zoom to Selection").setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myFrameSelection.doClick(0)).setEnableBooleanSupplier(() -> !timeline.getSelectionRange().isEmpty()).build();
        this.myFrameSelection.setToolTipText(this.myFrameSelectionAction.getDefaultToolTipText());
        rightToolbar.add((Component)this.myFrameSelection);
        timeline.getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> this.myFrameSelection.setEnabled(this.myFrameSelectionAction.isEnabled()));
        this.myGoLiveToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myGoLiveToolbar.add((Component)new FlatSeparator());
        this.myGoLive = new CommonToggleButton("", StudioIcons.Profiler.Toolbar.GOTO_LIVE);
        this.myGoLive.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.GOTO_LIVE));
        this.myGoLive.setFont(ProfilerFonts.H4_FONT);
        this.myGoLive.setHorizontalTextPosition(2);
        this.myGoLive.setHorizontalAlignment(2);
        this.myGoLive.setBorder((Border)new JBEmptyBorder(3, 7, 3, 7));
        ProfilerAction attachAction = new ProfilerAction.Builder(ATTACH_LIVE).setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myGoLive.doClick(0)).setEnableBooleanSupplier(() -> this.myGoLive.isEnabled() && !this.myGoLive.isSelected() && this.myStageView.navigationControllersEnabled()).setKeyStrokes(KeyStroke.getKeyStroke(39, SHORTCUT_MODIFIER_MASK_NUMBER)).build();
        ProfilerAction detachAction = new ProfilerAction.Builder(DETACH_LIVE).setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myGoLive.doClick(0)).setEnableBooleanSupplier(() -> this.myGoLive.isEnabled() && this.myGoLive.isSelected() && this.myStageView.navigationControllersEnabled()).setKeyStrokes(KeyStroke.getKeyStroke(32, 0)).build();
        this.myGoLive.setToolTipText(detachAction.getDefaultToolTipText());
        this.myGoLive.addActionListener(event -> {
            timeline.toggleStreaming();
            this.myProfiler.getIdeServices().getFeatureTracker().trackToggleStreaming();
        });
        this.myGoLive.addChangeListener(e -> {
            boolean isSelected = this.myGoLive.isSelected();
            this.myGoLive.setIcon(isSelected ? StudioIcons.Profiler.Toolbar.PAUSE_LIVE : StudioIcons.Profiler.Toolbar.GOTO_LIVE);
            this.myGoLive.setToolTipText(isSelected ? detachAction.getDefaultToolTipText() : attachAction.getDefaultToolTipText());
        });
        timeline.addDependency(this).onChange((Enum)ProfilerTimeline.Aspect.STREAMING, this::updateStreaming);
        this.myGoLiveToolbar.add(this.myGoLive);
        rightToolbar.add(this.myGoLiveToolbar);
        ProfilerContextMenu.createIfAbsent(this.myStageComponent).add(attachAction, detachAction, ContextMenuItem.SEPARATOR, zoomInAction, zoomOutAction);
        this.myProfiler.getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::toggleTimelineButtons);
        this.toggleTimelineButtons();
        this.myStageToolbar = new JPanel(new BorderLayout());
        this.myToolbar.add((Component)this.myStageToolbar, "Center");
        this.myStageComponent.add((Component)this.myToolbar, "North");
        this.myStageComponent.add((Component)this.myStageCenterComponent, "Center");
        this.updateStreaming();
    }

    private void toggleTimelineButtons() {
        boolean isAlive = this.myProfiler.getSessionsManager().isSessionAlive();
        if (isAlive) {
            boolean waitForAgent;
            Common.AgentData agentData = this.myProfiler.getAgentData();
            boolean bl = waitForAgent = agentData.getStatus() == Common.AgentData.Status.UNSPECIFIED;
            if (waitForAgent) {
                this.myZoomOut.setEnabled(false);
                this.myZoomIn.setEnabled(false);
                this.myResetZoom.setEnabled(false);
                this.myFrameSelection.setEnabled(false);
                this.myGoLive.setEnabled(false);
                this.myGoLive.setSelected(false);
            } else {
                this.myZoomOut.setEnabled(true);
                this.myZoomIn.setEnabled(true);
                this.myResetZoom.setEnabled(true);
                this.myFrameSelection.setEnabled(this.myFrameSelectionAction.isEnabled());
                this.myGoLive.setEnabled(true);
                this.myGoLive.setSelected(true);
            }
        } else {
            boolean isValidSession = !Common.Session.getDefaultInstance().equals((Object)this.myProfiler.getSessionsManager().getSelectedSession());
            this.myZoomOut.setEnabled(isValidSession);
            this.myZoomIn.setEnabled(isValidSession);
            this.myResetZoom.setEnabled(isValidSession);
            this.myFrameSelection.setEnabled(isValidSession && this.myFrameSelectionAction.isEnabled());
            this.myGoLive.setEnabled(false);
            this.myGoLive.setSelected(false);
        }
    }

    private void toggleSessionsPanel(boolean isCollapsed) {
        if (isCollapsed) {
            this.mySplitter.setDividerMouseZoneSize(-1);
            this.mySessionsView.getComponent().setMinimumSize(SessionsView.getComponentMinimizeSize(false));
            this.mySplitter.setFirstSize(0);
        } else {
            this.mySplitter.setDividerMouseZoneSize(JBUI.scale((int)10));
            this.mySessionsView.getComponent().setMinimumSize(SessionsView.getComponentMinimizeSize(true));
            this.mySplitter.setFirstSize(this.myProfiler.getIdeServices().getPersistentProfilerPreferences().getInt("SESSION_EXPANDED_WIDTH", 0));
        }
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    private void updateStreaming() {
        this.myGoLive.setSelected(this.myProfiler.getTimeline().isStreaming());
    }

    private void updateStageView() {
        Stage stage = this.myProfiler.getStage();
        if (this.myStageView != null && this.myStageView.getStage() == stage) {
            return;
        }
        this.myStageView = this.myBinder.build(this, stage);
        SwingUtilities.invokeLater(() -> {
            Component focussed = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focussed == null || !SwingUtilities.isDescendingFrom(focussed, (Component)this.mySplitter)) {
                this.mySplitter.requestFocusInWindow();
            }
        });
        this.myStageCenterComponent.removeAll();
        this.myStageCenterComponent.add((Component)this.myStageView.getComponent(), STAGE_VIEW_CARD);
        this.myStageCenterComponent.add((Component)this.myStageLoadingPanel.getComponent(), LOADING_VIEW_CARD);
        this.myStageCenterComponent.revalidate();
        this.myStageToolbar.removeAll();
        this.myStageToolbar.add((Component)this.myStageView.getToolbar(), "Center");
        this.myStageToolbar.revalidate();
        this.myToolbar.setVisible(this.myStageView.isToolbarVisible());
        this.myGoLiveToolbar.setVisible(this.myStageView.navigationControllersEnabled());
        boolean topLevel = this.myStageView == null || this.myStageView.needsProcessSelection();
        this.myCommonToolbar.setVisible(!topLevel && this.myStageView.navigationControllersEnabled());
    }

    private void toggleStageLayout() {
        boolean loading = this.myProfiler.getAutoProfilingEnabled() && this.myProfiler.getPreferredProcessName() != null && !this.myProfiler.getSessionsManager().isSessionAlive();
        Common.AgentData agentData = this.myProfiler.getAgentData();
        if (loading |= agentData.getStatus() == Common.AgentData.Status.UNSPECIFIED && this.myProfiler.getSessionsManager().isSessionAlive()) {
            this.myStageLoadingPanel.startLoading();
            this.myStageCenterCardLayout.show(this.myStageCenterComponent, LOADING_VIEW_CARD);
        } else {
            this.myStageLoadingPanel.stopLoading();
            this.myStageCenterCardLayout.show(this.myStageCenterComponent, STAGE_VIEW_CARD);
        }
        this.toggleTimelineButtons();
    }

    @NotNull
    public JLayeredPane getComponent() {
        return this.myLayeredPane;
    }

    public void installCommonMenuItems(@NotNull JComponent component) {
        ContextMenuInstaller contextMenuInstaller = this.getIdeProfilerComponents().createContextMenuInstaller();
        ProfilerContextMenu.createIfAbsent(this.myStageComponent).getContextMenuItems().forEach(item -> contextMenuInstaller.installGenericContextMenu(component, (ContextMenuItem)item));
    }

    @VisibleForTesting
    final JPanel getStageComponent() {
        return this.myStageComponent;
    }

    @VisibleForTesting
    final JComponent getStageLoadingComponent() {
        return this.myStageLoadingPanel.getComponent();
    }

    @VisibleForTesting
    final JComponent getStageViewComponent() {
        return this.myStageView.getComponent();
    }

    @NotNull
    public IdeProfilerComponents getIdeProfilerComponents() {
        return this.myIdeProfilerComponents;
    }

    @VisibleForTesting
    public static class StageComboBoxRenderer
    extends ColoredListCellRenderer<Class> {
        private static ImmutableMap<Class<? extends Stage>, String> CLASS_TO_NAME = ImmutableMap.of(CpuProfilerStage.class, (Object)"CPU", MemoryProfilerStage.class, (Object)"MEMORY", NetworkProfilerStage.class, (Object)"NETWORK", EnergyProfilerStage.class, (Object)"ENERGY");

        protected void customizeCellRenderer(@NotNull JList list, Class value, int index, boolean selected, boolean hasFocus) {
            String name = (String)CLASS_TO_NAME.get((Object)value);
            this.append(name == null ? "[UNKNOWN]" : name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

