/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.HoverRowTable;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTimeline;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class TimelineTable {
    private static final int HEADER_HEIGHT = 20;
    private static final int TIMELINE_HEIGHT = 14;

    @NotNull
    public static JBTable create(@NotNull TableModel model, @NotNull ProfilerTimeline timeline, int column) {
        HoverRowTable table = new HoverRowTable(model);
        table.getTableHeader().setDefaultRenderer(new HeaderRenderer((JTable)table, timeline, column));
        AspectObserver timelineObserver = new AspectObserver();
        table.addHierarchyListener(new HierarchyListener((JBTable)table, timeline, timelineObserver){
            final /* synthetic */ JBTable val$table;
            final /* synthetic */ ProfilerTimeline val$timeline;
            final /* synthetic */ AspectObserver val$timelineObserver;
            {
                this.val$table = jBTable;
                this.val$timeline = profilerTimeline;
                this.val$timelineObserver = aspectObserver;
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (this.val$table.isShowing()) {
                        this.val$timeline.getSelectionRange().addDependency(this.val$timelineObserver).onChange((Enum)Range.Aspect.RANGE, () -> this.val$table.repaint());
                    } else {
                        this.val$timeline.getSelectionRange().removeDependencies(this.val$timelineObserver);
                    }
                }
            }
        });
        boolean[] lastIsEmpty = new boolean[]{true};
        table.getModel().addTableModelListener(new TableModelListener((JBTable)table, lastIsEmpty){
            final /* synthetic */ JBTable val$table;
            final /* synthetic */ boolean[] val$lastIsEmpty;
            {
                this.val$table = jBTable;
                this.val$lastIsEmpty = blArray;
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean isEmpty;
                boolean bl = isEmpty = this.val$table.getRowCount() == 0;
                if (this.val$lastIsEmpty[0] != isEmpty) {
                    this.val$lastIsEmpty[0] = isEmpty;
                    this.val$table.getTableHeader().resizeAndRepaint();
                }
            }
        });
        return table;
    }

    @NotNull
    private static AxisComponent createAxis(@NotNull ProfilerTimeline timeline) {
        ResizingAxisComponentModel model = new ResizingAxisComponentModel.Builder(timeline.getSelectionRange(), (BaseAxisFormatter)new TimeAxisFormatter(1, 5, 1)).setGlobalRange(timeline.getDataRange()).build();
        AxisComponent axis = new AxisComponent((AxisComponentModel)model, AxisComponent.AxisOrientation.BOTTOM);
        axis.setShowAxisLine(false);
        axis.setMarkerColor(ProfilerColors.AXIS_MARKER_COLOR);
        return axis;
    }

    private static final class GridBorder
    implements Border {
        private final Color myColor;

        public GridBorder(@NotNull JTable table) {
            this.myColor = table.getGridColor();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.myColor);
            int xRight = x + width - 1;
            g.drawLine(xRight, y, xRight, y + height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBUI.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    public static abstract class CellRenderer
    implements TableCellRenderer {
        private ProfilerTimeline myTimeline;

        public CellRenderer(@NotNull ProfilerTimeline timeline) {
            this.myTimeline = timeline;
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("*", "*"));
            panel.add(this.getTableCellRendererComponent(isSelected, row), new TabularLayout.Constraint(0, 0));
            AxisComponent axisTicks = TimelineTable.createAxis(this.myTimeline);
            axisTicks.setShowLabels(false);
            axisTicks.setMarkerLengths(table.getRowHeight(), 0);
            panel.add((Component)axisTicks, new TabularLayout.Constraint(0, 0));
            return panel;
        }

        @NotNull
        protected final ProfilerTimeline getTimeline() {
            return this.myTimeline;
        }

        @NotNull
        protected abstract Component getTableCellRendererComponent(boolean var1, int var2);
    }

    private static final class HeaderRenderer
    implements TableCellRenderer {
        @NotNull
        private final TableCellRenderer myDelegateRenderer;
        @NotNull
        private final ProfilerTimeline myTimeline;
        private int myTimelineColumn;

        private HeaderRenderer(@NotNull JTable table, @NotNull ProfilerTimeline timeline, int timelineColumn) {
            this.myDelegateRenderer = table.getTableHeader().getDefaultRenderer();
            this.myTimeline = timeline;
            this.myTimelineColumn = timelineColumn;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent headerComponent = (JComponent)this.myDelegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (headerComponent instanceof JLabel) {
                headerComponent.setBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER);
                ((JLabel)headerComponent).setHorizontalAlignment(2);
            }
            if (table.getRowCount() == 0) {
                return headerComponent;
            }
            JPanel rendererPanel = new JPanel((LayoutManager)new TabularLayout("*", String.format("%dpx,%dpx", 20, 14)));
            rendererPanel.setOpaque(false);
            headerComponent.setOpaque(false);
            JPanel axisPanel = new JPanel(new BorderLayout());
            axisPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
            if (column == this.myTimelineColumn) {
                AxisComponent header = TimelineTable.createAxis(this.myTimeline);
                header.setShowAxisLine(false);
                header.setMarkerLengths(14, 0);
                axisPanel.add((Component)header);
            } else {
                JComponent separator = AdtUiUtils.createHorizontalSeparator();
                separator.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
                axisPanel.add(separator);
            }
            axisPanel.setBorder(new GridBorder(table));
            rendererPanel.add((Component)headerComponent, new TabularLayout.Constraint(0, 0));
            rendererPanel.add((Component)axisPanel, new TabularLayout.Constraint(1, 0));
            return rendererPanel;
        }
    }
}

