/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class UnifiedEventDataSeries
implements DataSeries<Long> {
    public static final int DEFAULT_GROUP_ID = 0;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    private final long myStreamId;
    private final int myPid;
    @NotNull
    private final Common.Event.Kind myKind;
    private final int myGroupId;
    @NotNull
    private final Function<List<Common.Event>, Stream<SeriesData<Long>>> myDataExtractor;

    public UnifiedEventDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, long streamId, int pid, @NotNull Common.Event.Kind kind, int groupId, @NotNull Function<List<Common.Event>, Stream<SeriesData<Long>>> dataExtractor) {
        this.myClient = client;
        this.myStreamId = streamId;
        this.myPid = pid;
        this.myKind = kind;
        this.myGroupId = groupId;
        this.myDataExtractor = dataExtractor;
    }

    public List<SeriesData<Long>> getDataForXRange(Range xRangeUs) {
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)xRangeUs.getMin()) - TimeUnit.SECONDS.toNanos(1L);
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)xRangeUs.getMax()) + TimeUnit.SECONDS.toNanos(1L);
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(this.myKind).setGroupId((long)this.myGroupId).setFromTimestamp(minNs).setToTimestamp(maxNs).build();
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(request);
        assert (response.getGroupsCount() <= 1);
        if (response.getGroupsCount() == 0) {
            return new ArrayList<SeriesData<Long>>();
        }
        return this.myDataExtractor.apply(response.getGroups(0).getEventsList()).collect(Collectors.toList());
    }

    public static Function<List<Common.Event>, Stream<SeriesData<Long>>> fromFieldToDataExtractor(Function<Common.Event, Long> fieldExtractor) {
        return events -> events.stream().map(event -> new SeriesData(TimeUnit.NANOSECONDS.toMicros(event.getTimestamp()), fieldExtractor.apply((Common.Event)event)));
    }
}

