/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.TraceParser;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCapture
implements ConfigurableDurationData {
    private final int myMainThreadId;
    @NotNull
    private ClockType myClockType;
    @NotNull
    private final TraceParser myParser;
    private final long myTraceId;
    private final Cpu.CpuTraceType myType;

    public CpuCapture(@NotNull TraceParser parser, long traceId, Cpu.CpuTraceType type) {
        this.myParser = parser;
        this.myTraceId = traceId;
        this.myType = type;
        Map<CpuThreadInfo, CaptureNode> captureTrees = this.myParser.getCaptureTrees();
        if (captureTrees.isEmpty()) {
            throw new IllegalStateException("Trace file contained no CPU data.");
        }
        Map.Entry<CpuThreadInfo, CaptureNode> main = null;
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : captureTrees.entrySet()) {
            if (entry.getKey().isMainThread()) {
                main = entry;
                break;
            }
            if (main != null && main.getValue().getDuration() >= entry.getValue().getDuration()) continue;
            main = entry;
        }
        this.myMainThreadId = ((CpuThreadInfo)main.getKey()).getId();
        CaptureNode mainNode = this.getCaptureNode(this.myMainThreadId);
        assert (mainNode != null);
        this.myClockType = mainNode.getClockType();
    }

    public int getMainThreadId() {
        return this.myMainThreadId;
    }

    @NotNull
    public Range getRange() {
        return this.myParser.getRange();
    }

    @Nullable
    public CaptureNode getCaptureNode(int threadId) {
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : this.myParser.getCaptureTrees().entrySet()) {
            if (entry.getKey().getId() != threadId) continue;
            return entry.getValue();
        }
        return null;
    }

    @NotNull
    Set<CpuThreadInfo> getThreads() {
        return this.myParser.getCaptureTrees().keySet();
    }

    public boolean containsThread(int threadId) {
        return this.myParser.getCaptureTrees().keySet().stream().anyMatch(info -> info.getId() == threadId);
    }

    public long getDurationUs() {
        return (long)this.myParser.getRange().getLength();
    }

    public boolean getSelectableWhenMaxDuration() {
        return false;
    }

    public long getTraceId() {
        return this.myTraceId;
    }

    public boolean canSelectPartialRange() {
        return true;
    }

    public void updateClockType(@NotNull ClockType clockType) {
        if (this.myClockType == clockType) {
            return;
        }
        this.myClockType = clockType;
        for (CaptureNode tree : this.myParser.getCaptureTrees().values()) {
            CpuCapture.updateClockType(tree, clockType);
        }
    }

    private static void updateClockType(@Nullable CaptureNode node, @NotNull ClockType clockType) {
        if (node == null) {
            return;
        }
        node.setClockType(clockType);
        for (CaptureNode child : node.getChildren()) {
            CpuCapture.updateClockType(child, clockType);
        }
    }

    public boolean isDualClock() {
        return this.myParser.supportsDualClock();
    }

    public Cpu.CpuTraceType getType() {
        return this.myType;
    }
}

