/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.art.ArtTraceParser;
import com.android.tools.profilers.cpu.atrace.AtraceParser;
import com.android.tools.profilers.cpu.atrace.AtraceProducer;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.atrace.PerfettoProducer;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfTraceParser;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureParser {
    @VisibleForTesting
    static final int MAX_SUPPORTED_TRACE_SIZE = 0x6400000;
    static final long IMPORTED_TRACE_ID = 42L;
    private final Map<Long, CompletableFuture<CpuCapture>> myCaptures;
    private final Map<Long, String> myTraceFiles;
    @NotNull
    private final IdeProfilerServices myServices;
    private final AspectModel<CpuProfilerAspect> myAspect = new AspectModel();
    private boolean myIsParsing;
    private long myParsingStartTimeMs;

    public CpuCaptureParser(@NotNull IdeProfilerServices services) {
        this.myServices = services;
        this.myCaptures = new HashMap<Long, CompletableFuture<CpuCapture>>();
        this.myTraceFiles = new HashMap<Long, String>();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuCaptureParser.class);
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCapture(long traceId) {
        return this.myCaptures.get(traceId);
    }

    @Nullable
    String getTraceFilePath(long traceId) {
        return this.myTraceFiles.get(traceId);
    }

    public void abortParsing() {
        this.myCaptures.forEach((id, capture) -> {
            boolean isCaptureCancelled = capture.cancel(true);
            if (!isCaptureCancelled) {
                CpuCaptureParser.getLogger().warn(String.format("Parsing of capture %d was not properly cancelled.", id));
            }
        });
    }

    public boolean isParsing() {
        return this.myIsParsing;
    }

    public long getParsingElapsedTimeMs() {
        return System.currentTimeMillis() - this.myParsingStartTimeMs;
    }

    private void updateParsingStateWhenDone(CompletableFuture<CpuCapture> future) {
        future.handleAsync((capture, exception) -> {
            this.myIsParsing = false;
            this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
            return capture;
        }, this.myServices.getPoolExecutor());
    }

    @VisibleForTesting
    public void updateParsingStateWhenStarting() {
        this.myParsingStartTimeMs = System.currentTimeMillis();
        this.myIsParsing = true;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
    }

    @Nullable
    public CompletableFuture<CpuCapture> parse(@NotNull File traceFile) {
        if (!traceFile.exists() || traceFile.isDirectory()) {
            CpuCaptureParser.getLogger().info("Trace not parsed, as its path doesn't exist or points to a directory.");
            return null;
        }
        this.myTraceFiles.put(42L, traceFile.getAbsolutePath());
        long fileLength = traceFile.length();
        if (fileLength > 0x6400000L) {
            Runnable yesCallback = () -> {
                CpuCaptureParser.getLogger().warn(String.format("Parsing long (%d bytes) trace file.", fileLength));
                this.myCaptures.put(42L, this.createCaptureFuture(traceFile));
            };
            Runnable noCallback = () -> {
                CpuCaptureParser.getLogger().warn(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", fileLength));
                this.myCaptures.put(42L, null);
            };
            this.myServices.openParseLargeTracesDialog(yesCallback, noCallback);
        } else {
            this.myCaptures.put(42L, this.createCaptureFuture(traceFile));
        }
        return this.myCaptures.get(42L);
    }

    private CompletableFuture<CpuCapture> createCaptureFuture(@NotNull File traceFile) {
        CompletableFuture<CpuCapture> future = CompletableFuture.supplyAsync(() -> this.tryParsingFileWithDifferentParsers(traceFile), this.myServices.getPoolExecutor());
        this.updateParsingStateWhenDone(future);
        return future;
    }

    private CpuCapture tryParsingFileWithDifferentParsers(File traceFile) {
        try {
            ArtTraceParser artTraceParser = new ArtTraceParser();
            return artTraceParser.parse(traceFile, 42L);
        }
        catch (Exception artTraceParser) {
            try {
                SimpleperfTraceParser simpleperfParser = new SimpleperfTraceParser();
                return simpleperfParser.parse(traceFile, 42L);
            }
            catch (Exception simpleperfParser) {
                if (this.myServices.getFeatureConfig().isAtraceEnabled()) {
                    try {
                        AtraceParser parser;
                        CpuThreadSliceInfo[] processList;
                        CpuThreadSliceInfo selected;
                        if ((AtraceProducer.verifyFileHasAtraceHeader(traceFile) || this.myServices.getFeatureConfig().isPerfettoEnabled() && PerfettoProducer.verifyFileHasPerfettoTraceHeader(traceFile)) && (selected = this.myServices.openListBoxChooserDialog("Select a process", "Select the process you want to analyze.", processList = (parser = new AtraceParser(traceFile)).getProcessList(this.myServices.getApplicationId()), t -> t.getProcessName())) != null) {
                            parser.setSelectProcess(selected);
                            return parser.parse(traceFile, 42L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                CpuCaptureParser.getLogger().warn(String.format("Parsing %s has failed.", traceFile.getPath()));
                return null;
            }
        }
    }

    @Nullable
    public CompletableFuture<CpuCapture> parse(@NotNull Common.Session session, long traceId, @NotNull ByteString traceData, Cpu.CpuTraceType profilerType) {
        if (!this.myCaptures.containsKey(traceId)) {
            if (traceData.size() <= 0x6400000) {
                this.myCaptures.put(traceId, this.createCaptureFuture(session, traceId, traceData, profilerType));
            } else {
                Runnable yesCallback = () -> {
                    CpuCaptureParser.getLogger().warn(String.format("Parsing long (%d bytes) trace file.", traceData.size()));
                    this.myCaptures.put(traceId, this.createCaptureFuture(session, traceId, traceData, profilerType));
                };
                Runnable noCallback = () -> {
                    CpuCaptureParser.getLogger().warn(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", traceData.size()));
                    this.myCaptures.put(traceId, null);
                };
                this.myServices.openParseLargeTracesDialog(yesCallback, noCallback);
            }
        }
        return this.myCaptures.get(traceId);
    }

    private CompletableFuture<CpuCapture> createCaptureFuture(@NotNull Common.Session session, long traceId, ByteString traceBytes, Cpu.CpuTraceType profilerType) {
        CompletableFuture<CpuCapture> future = CompletableFuture.supplyAsync(() -> this.traceBytesToCapture(session, traceId, traceBytes, profilerType), this.myServices.getPoolExecutor());
        this.updateParsingStateWhenDone(future);
        return future;
    }

    private CpuCapture traceBytesToCapture(@NotNull Common.Session session, long traceId, @NotNull ByteString traceData, Cpu.CpuTraceType profilerType) {
        try {
            TraceParser parser;
            File trace = FileUtil.createTempFile((String)String.format("cpu_trace_%d", traceId), (String)".trace", (boolean)true);
            try (FileOutputStream out = new FileOutputStream(trace);){
                out.write(traceData.toByteArray());
            }
            this.myTraceFiles.put(traceId, trace.getAbsolutePath());
            if (profilerType == Cpu.CpuTraceType.ART) {
                parser = new ArtTraceParser();
            } else if (profilerType == Cpu.CpuTraceType.SIMPLEPERF) {
                parser = new SimpleperfTraceParser();
            } else if (profilerType == Cpu.CpuTraceType.ATRACE) {
                parser = new AtraceParser(session.getPid());
            } else {
                throw new IllegalStateException("Trace file cannot be parsed. Profiler type (ART, simpleperf, or atrace) needs to be set.");
            }
            return parser.parse(trace, traceId);
        }
        catch (IOException | BufferUnderflowException e) {
            throw new IllegalStateException(e);
        }
    }
}

