/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureSessionArtifact
implements SessionArtifact<Cpu.CpuTraceInfo> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Common.SessionMetaData mySessionMetaData;
    @NotNull
    private final Cpu.CpuTraceInfo myInfo;
    private final boolean myIsOngoingCapture;

    public CpuCaptureSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull Cpu.CpuTraceInfo info, boolean isOngoingCapture) {
        this.myProfilers = profilers;
        this.mySession = session;
        this.mySessionMetaData = sessionMetaData;
        this.myInfo = info;
        this.myIsOngoingCapture = isOngoingCapture;
    }

    @Override
    @NotNull
    public Cpu.CpuTraceInfo getArtifactProto() {
        return this.myInfo;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.myProfilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.mySession;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.mySessionMetaData;
    }

    @Override
    @NotNull
    public String getName() {
        return ProfilingTechnology.fromTypeAndMode(this.myInfo.getTraceType(), this.myInfo.getTraceMode()).getName();
    }

    public String getSubtitle() {
        if (this.myIsOngoingCapture) {
            return "Recording...";
        }
        if (this.isImportedSession()) {
            return TimeFormatter.getLocalizedDateTime((long)TimeUnit.NANOSECONDS.toMillis(this.mySession.getStartTimestamp()));
        }
        return TimeFormatter.getFullClockString((long)TimeUnit.NANOSECONDS.toMicros(this.getTimestampNs()));
    }

    @Override
    public long getTimestampNs() {
        if (this.isImportedSession()) {
            return 0L;
        }
        return this.myInfo.getFromTimestamp() - this.mySession.getStartTimestamp();
    }

    @Override
    public void onSelect() {
        boolean needsToOpenCpuProfiler;
        boolean needsToChangeSession;
        boolean bl = needsToChangeSession = this.mySession != this.myProfilers.getSession();
        if (needsToChangeSession) {
            this.myProfilers.getSessionsManager().setSession(this.mySession);
        }
        if (this.isImportedSession()) {
            return;
        }
        boolean bl2 = needsToOpenCpuProfiler = !(this.myProfilers.getStage() instanceof CpuProfilerStage);
        if (needsToOpenCpuProfiler) {
            this.myProfilers.setStage(new CpuProfilerStage(this.myProfilers));
        }
        if (this.myIsOngoingCapture) {
            SessionArtifact.navigateTimelineToOngoingCapture(this.myProfilers.getTimeline(), TimeUnit.NANOSECONDS.toMicros(this.myInfo.getFromTimestamp()));
        } else {
            assert (this.myProfilers.getStage() instanceof CpuProfilerStage);
            ((CpuProfilerStage)this.myProfilers.getStage()).setAndSelectCapture(this.myInfo.getTraceId());
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.myProfilers.getSessionsManager().isSessionAlive());
    }

    @Override
    public boolean isOngoing() {
        return this.myIsOngoingCapture;
    }

    @Override
    public boolean canExport() {
        return !this.isOngoing();
    }

    @Override
    public void export(@NotNull OutputStream outputStream) {
        assert (this.canExport());
        CpuProfiler.saveCaptureToFile(this.getArtifactProto(), outputStream);
    }

    private boolean isImportedSession() {
        return this.mySessionMetaData.getType() == Common.SessionMetaData.SessionType.CPU_CAPTURE;
    }

    public static List<SessionArtifact> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
        CpuProfiler.ProfilingStateResponse profilingStateResponse;
        CpuProfiler.GetTraceInfoResponse response = profilers.getClient().getCpuClient().getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(session).setFromTimestamp(Long.MIN_VALUE).setToTimestamp(Long.MAX_VALUE).build());
        ArrayList<SessionArtifact> artifacts = new ArrayList<SessionArtifact>();
        for (Cpu.CpuTraceInfo info : response.getTraceInfoList()) {
            artifacts.add(new CpuCaptureSessionArtifact(profilers, session, sessionMetaData, info, false));
        }
        if (SessionsManager.isSessionAlive(session) && (profilingStateResponse = profilers.getClient().getCpuClient().checkAppProfilingState(CpuProfiler.ProfilingStateRequest.newBuilder().setSession(session).build())).getBeingProfiled()) {
            Cpu.CpuTraceInfo ongoingTraceInfo = Cpu.CpuTraceInfo.newBuilder().setTraceType(profilingStateResponse.getConfiguration().getTraceType()).setTraceMode(profilingStateResponse.getConfiguration().getTraceMode()).setFromTimestamp(profilingStateResponse.getStartTimestamp()).build();
            artifacts.add(new CpuCaptureSessionArtifact(profilers, session, sessionMetaData, ongoingTraceInfo, true));
        }
        return artifacts;
    }
}

