/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.CpuFrameTooltip;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuFrameTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final CpuFrameTooltip myTooltip;
    @NotNull
    private final JPanel myContent;
    @NotNull
    private final JPanel myMainFramePanel;
    @NotNull
    private final JLabel myMainFrameCpuText;
    @NotNull
    private final JLabel myMainFrameTotalTimeText;
    @NotNull
    private final JPanel myRenderFramePanel;
    @NotNull
    private final JLabel myRenderFrameCpuText;
    @NotNull
    private final JLabel myRenderTotalTimeText;
    @NotNull
    private final JLabel myTotalTimeText;

    protected CpuFrameTooltipView(@NotNull CpuProfilerStageView view, @NotNull CpuFrameTooltip tooltip) {
        super(view.getTimeline());
        this.myTooltip = tooltip;
        this.myContent = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        this.myMainFramePanel = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUI.scale((int)4)));
        JLabel mainThreadLabel = CpuFrameTooltipView.createTooltipLabel();
        mainThreadLabel.setText("Main Thread");
        this.myMainFrameCpuText = CpuFrameTooltipView.createTooltipLabel();
        this.myMainFrameTotalTimeText = CpuFrameTooltipView.createTooltipLabel();
        this.myTotalTimeText = CpuFrameTooltipView.createTooltipLabel();
        this.myMainFramePanel.add((Component)mainThreadLabel, new TabularLayout.Constraint(0, 0));
        this.myMainFramePanel.add((Component)this.myMainFrameCpuText, new TabularLayout.Constraint(2, 0));
        this.myMainFramePanel.add((Component)this.myMainFrameTotalTimeText, new TabularLayout.Constraint(4, 0));
        this.myRenderFramePanel = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUI.scale((int)4)));
        JLabel renderThreadLabel = CpuFrameTooltipView.createTooltipLabel();
        renderThreadLabel.setText("RenderThread");
        this.myRenderFrameCpuText = CpuFrameTooltipView.createTooltipLabel();
        this.myRenderTotalTimeText = CpuFrameTooltipView.createTooltipLabel();
        this.myRenderFramePanel.add((Component)renderThreadLabel, new TabularLayout.Constraint(0, 0));
        this.myRenderFramePanel.add((Component)this.myRenderFrameCpuText, new TabularLayout.Constraint(2, 0));
        this.myRenderFramePanel.add((Component)this.myRenderTotalTimeText, new TabularLayout.Constraint(4, 0));
        this.myContent.add((Component)this.myTotalTimeText, new TabularLayout.Constraint(0, 0));
        this.myContent.add((Component)this.myMainFramePanel, new TabularLayout.Constraint(1, 0));
        this.myContent.add((Component)this.myRenderFramePanel, new TabularLayout.Constraint(2, 0));
        tooltip.addDependency(this).onChange((Enum)CpuFrameTooltip.Aspect.FRAME_CHANGED, this::timeChanged);
    }

    private static void setLabelText(AtraceFrame frame, JLabel cpuText, JLabel totalTimeText) {
        cpuText.setText(String.format("CPU Time: %s", TimeFormatter.getSingleUnitDurationString((long)((long)((double)TimeUnit.SECONDS.toMicros(1L) * frame.getCpuTimeSeconds())))));
        totalTimeText.setText(String.format("Wall Time: %s", TimeFormatter.getSingleUnitDurationString((long)frame.getDurationUs())));
    }

    protected void timeChanged() {
        this.myContent.setVisible(false);
        this.myMainFramePanel.setVisible(false);
        this.myRenderFramePanel.setVisible(false);
        this.myTotalTimeText.setVisible(false);
        AtraceFrame frame = this.myTooltip.getFrame();
        if (frame == null || frame == AtraceFrame.EMPTY) {
            return;
        }
        this.myContent.setVisible(true);
        if (frame.getThread() == AtraceFrame.FrameThread.MAIN) {
            this.myMainFramePanel.setVisible(true);
            CpuFrameTooltipView.setLabelText(frame, this.myMainFrameCpuText, this.myMainFrameTotalTimeText);
            if (frame.getAssociatedFrame() != null) {
                this.myRenderFramePanel.setVisible(true);
                CpuFrameTooltipView.setLabelText(frame.getAssociatedFrame(), this.myRenderFrameCpuText, this.myRenderTotalTimeText);
            }
        } else if (frame.getThread() == AtraceFrame.FrameThread.RENDER) {
            this.myRenderFramePanel.setVisible(true);
            CpuFrameTooltipView.setLabelText(frame, this.myRenderFrameCpuText, this.myRenderTotalTimeText);
            if (frame.getAssociatedFrame() != null) {
                this.myMainFramePanel.setVisible(true);
                CpuFrameTooltipView.setLabelText(frame.getAssociatedFrame(), this.myMainFrameCpuText, this.myMainFrameTotalTimeText);
            }
        }
        if (frame.getAssociatedFrame() != null) {
            this.myTotalTimeText.setVisible(true);
            long associatedFrameLength = frame.getAssociatedFrame().getDurationUs();
            this.myTotalTimeText.setText("Total Time: " + TimeFormatter.getSingleUnitDurationString((long)(frame.getDurationUs() + associatedFrameLength)));
        }
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        return this.myContent;
    }
}

