/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.cpu.AtraceDataSeries;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.AtraceFrameFilterConfig;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class CpuFramesModel
extends DefaultListModel<FrameState> {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;
    public static final long SLOW_FRAME_RATE_US = TimeUnit.MILLISECONDS.toMicros(17L);

    public CpuFramesModel(@NotNull Range range, @NotNull CpuProfilerStage stage) {
        this.myRange = range;
        this.myStage = stage;
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::captureStateChanged);
        range.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::contentsChanged);
    }

    private void captureStateChanged() {
        this.removeAllElements();
        CpuCapture capture = this.myStage.getCapture();
        if (capture instanceof AtraceCpuCapture) {
            AtraceCpuCapture atraceCapture = (AtraceCpuCapture)capture;
            this.addElement(new FrameState("Main", new AtraceFrameFilterConfig("Choreographer#doFrame", capture.getMainThreadId(), SLOW_FRAME_RATE_US), this.myStage));
            this.addElement(new FrameState("Render", new AtraceFrameFilterConfig("(DrawFrame|doFrame|queueBuffer)", atraceCapture.getRenderThreadId(), SLOW_FRAME_RATE_US), this.myStage));
        }
        this.contentsChanged();
    }

    private void contentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public class FrameState {
        @NotNull
        private final AtraceDataSeries<AtraceFrame> myAtraceCpuStateDataSeries;
        @NotNull
        private final StateChartModel<AtraceFrame> myModel = new StateChartModel();
        private final String myThreadName;
        private final int myThreadId;

        public FrameState(@NotNull String threadName, @NotNull AtraceFrameFilterConfig filter, CpuProfilerStage stage) {
            this.myThreadName = threadName;
            this.myThreadId = filter.getThreadId();
            this.myAtraceCpuStateDataSeries = new AtraceDataSeries(stage, capture -> capture.getFrames(filter));
            this.myModel.addSeries(new RangedSeries(CpuFramesModel.this.myRange, this.myAtraceCpuStateDataSeries));
        }

        public String getThreadName() {
            return this.myThreadName;
        }

        public int getThreadId() {
            return this.myThreadId;
        }

        @NotNull
        public AtraceDataSeries<AtraceFrame> getSeries() {
            return this.myAtraceCpuStateDataSeries;
        }

        @NotNull
        public StateChartModel<AtraceFrame> getModel() {
            return this.myModel;
        }
    }
}

