/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.cpu.AtraceDataSeries;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class CpuKernelModel
extends DefaultListModel<CpuState> {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;

    public CpuKernelModel(@NotNull Range range, @NotNull CpuProfilerStage stage) {
        this.myRange = range;
        this.myStage = stage;
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::captureStateChanged);
        range.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::contentsChanged);
    }

    private void captureStateChanged() {
        this.removeAllElements();
        CpuCapture capture = this.myStage.getCapture();
        if (capture instanceof AtraceCpuCapture) {
            int count = ((AtraceCpuCapture)capture).getCpuCount();
            for (int i = 0; i < count; ++i) {
                this.addElement(new CpuState(i, this.myStage));
            }
        }
        this.contentsChanged();
    }

    private void contentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public class CpuState {
        private final int myCpuId;
        @NotNull
        private final AtraceDataSeries<CpuThreadSliceInfo> myAtraceCpuStateDataSeries;
        @NotNull
        private final StateChartModel<CpuThreadSliceInfo> myModel;

        public CpuState(@NotNull int cpuId, CpuProfilerStage stage) {
            this.myCpuId = cpuId;
            this.myModel = new StateChartModel();
            this.myAtraceCpuStateDataSeries = new AtraceDataSeries(stage, capture -> capture.getCpuThreadSliceInfoStates(this.myCpuId));
            this.myModel.addSeries(new RangedSeries(CpuKernelModel.this.myRange, this.myAtraceCpuStateDataSeries));
        }

        public int getCpuId() {
            return this.myCpuId;
        }

        @NotNull
        public AtraceDataSeries<CpuThreadSliceInfo> getSeries() {
            return this.myAtraceCpuStateDataSeries;
        }

        @NotNull
        public StateChartModel<CpuThreadSliceInfo> getModel() {
            return this.myModel;
        }
    }
}

