/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.atrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;

public class CpuKernelTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final CpuKernelTooltip myTooltip;
    @NotNull
    private final ProfilerTimeline myTimeline;
    private final int myProcessId;
    @NotNull
    private final JPanel myContent;
    @NotNull
    private final JLabel myThread;
    @NotNull
    private final JLabel myProcess;
    @NotNull
    private final JLabel myDuration;
    @NotNull
    private final JLabel myCpu;
    @NotNull
    private final JPanel myUnavailableDetails;

    protected CpuKernelTooltipView(@NotNull CpuProfilerStageView view, @NotNull CpuKernelTooltip tooltip) {
        super(view.getTimeline());
        this.myProcessId = ((CpuProfilerStage)view.getStage()).getStudioProfilers().getSession().getPid();
        this.myTimeline = view.getTimeline();
        this.myTooltip = tooltip;
        this.myContent = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUI.scale((int)8)));
        this.myThread = CpuKernelTooltipView.createTooltipLabel();
        this.myProcess = CpuKernelTooltipView.createTooltipLabel();
        this.myDuration = CpuKernelTooltipView.createTooltipLabel();
        this.myCpu = CpuKernelTooltipView.createTooltipLabel();
        this.myUnavailableDetails = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUI.scale((int)1)));
        tooltip.addDependency(this).onChange((Enum)CpuKernelTooltip.Aspect.CPU_KERNEL_THREAD_SLICE_INFO, this::threadSliceInfoChanged);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTooltip.removeDependencies(this);
    }

    private void addRow(JPanel parent, JComponent c) {
        int nextRow = parent.getComponentCount();
        parent.add((Component)c, new TabularLayout.Constraint(nextRow, 0));
    }

    private void threadSliceInfoChanged() {
        Range range = this.myTimeline.getTooltipRange();
        CpuThreadSliceInfo threadSlice = this.myTooltip.getCpuThreadSliceInfo();
        this.myContent.removeAll();
        if (range.isEmpty() || threadSlice == null) {
            return;
        }
        this.myThread.setText(String.format("Thread: %s", threadSlice.getName()));
        this.addRow(this.myContent, this.myThread);
        this.myProcess.setText(String.format("Process: %s", threadSlice.getProcessName()));
        this.addRow(this.myContent, this.myProcess);
        this.myDuration.setText(String.format("Duration: %s", TimeFormatter.getSingleUnitDurationString((long)threadSlice.getDurationUs())));
        this.addRow(this.myContent, this.myDuration);
        this.myCpu.setText(String.format("CPU: %d", this.myTooltip.getCpuId()));
        this.addRow(this.myContent, this.myCpu);
        if (this.myProcessId != threadSlice.getProcessId()) {
            this.addRow(this.myContent, this.myUnavailableDetails);
        }
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        JSeparator separator = new JSeparator(0);
        separator.setMinimumSize(separator.getPreferredSize());
        this.addRow(this.myUnavailableDetails, separator);
        JLabel unavailableLabel = new JLabel("Other (not selectable)");
        unavailableLabel.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        unavailableLabel.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        this.addRow(this.myUnavailableDetails, unavailableLabel);
        this.addRow(this.myContent, this.myUnavailableDetails);
        return this.myContent;
    }
}

