/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuMonitor;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceExporter;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfiler
extends StudioProfiler {
    @NotNull
    private final Map<Long, File> mySessionTraceFiles = new HashMap<Long, File>();

    public CpuProfiler(@NotNull StudioProfilers profilers) {
        super(profilers);
        if (profilers.getIdeServices().getFeatureConfig().isImportCpuTraceEnabled()) {
            this.registerImportedSessionListener();
            this.registerTraceImportHandler();
        }
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfiler.class);
    }

    private void registerImportedSessionListener() {
        this.myProfilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.CPU_CAPTURE, () -> {
            long sessionId = this.myProfilers.getSession().getSessionId();
            assert (this.mySessionTraceFiles.containsKey(sessionId));
            CpuProfilerStage stage = new CpuProfilerStage(this.myProfilers, this.mySessionTraceFiles.get(sessionId));
            this.myProfilers.setStage(stage);
        });
    }

    private void registerTraceImportHandler() {
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        sessionsManager.registerImportHandler("trace", file -> {
            long startTimestampEpochMs = System.currentTimeMillis();
            long startTimestampNs = CpuProfiler.getImportedSessionStartTimestampNs(file, startTimestampEpochMs);
            long endTimestampNs = startTimestampNs + TimeUnit.MINUTES.toNanos(1L);
            Common.Session importedSession = sessionsManager.createImportedSession(file.getName(), Common.SessionMetaData.SessionType.CPU_CAPTURE, startTimestampNs, endTimestampNs, startTimestampEpochMs);
            this.mySessionTraceFiles.put(importedSession.getSessionId(), (File)file);
            sessionsManager.update();
            sessionsManager.setSession(importedSession);
            ProfilerTimeline timeline = this.myProfilers.getTimeline();
            timeline.reset(this.myProfilers.getSession().getStartTimestamp(), this.myProfilers.getSession().getEndTimestamp());
            timeline.setIsPaused(true);
            this.myProfilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.CPU_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
        });
    }

    private static long getImportedSessionStartTimestampNs(File trace, long sessionStartTimestampEpochMs) {
        Path tracePath = Paths.get(trace.getPath(), new String[0]);
        try {
            BasicFileAttributes attributes = Files.readAttributes(tracePath, BasicFileAttributes.class, new LinkOption[0]);
            return attributes.creationTime().to(TimeUnit.NANOSECONDS);
        }
        catch (IOException e) {
            CpuProfiler.getLogger().warn("Trace file creation time could not be read. Falling back to session start time.");
            return TimeUnit.MICROSECONDS.toNanos(sessionStartTimestampEpochMs);
        }
    }

    @Nullable
    public File getTraceFile(Common.Session session) {
        return this.mySessionTraceFiles.get(session.getSessionId());
    }

    @Override
    public ProfilerMonitor newMonitor() {
        return new CpuMonitor(this.myProfilers);
    }

    @Override
    public void startProfiling(Common.Session session) {
        this.myProfilers.getClient().getCpuClient().startMonitoringApp(CpuProfiler.CpuStartRequest.newBuilder().setSession(session).build());
    }

    @Override
    public void stopProfiling(Common.Session session) {
        this.myProfilers.getClient().getCpuClient().stopMonitoringApp(CpuProfiler.CpuStopRequest.newBuilder().setSession(session).build());
    }

    static void saveCaptureToFile(@NotNull Cpu.CpuTraceInfo info, @NotNull OutputStream outputStream) {
        try {
            if (info.getTraceType() == Cpu.CpuTraceType.ATRACE) {
                AtraceExporter.export(new File(info.getTraceFilePath()), outputStream);
            } else {
                FileUtil.copy((InputStream)new FileInputStream(info.getTraceFilePath()), (OutputStream)outputStream);
            }
        }
        catch (IOException exception) {
            CpuProfiler.getLogger().warn("Failed to export CPU trace file:\n" + exception);
        }
    }

    @NotNull
    static String generateCaptureFileName(@NotNull Cpu.CpuTraceType profilerType) {
        StringBuilder traceName = new StringBuilder(String.format("cpu-%s-", StringUtil.toLowerCase((String)profilerType.name())));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        traceName.append(LocalDateTime.now().format(formatter));
        return traceName.toString();
    }
}

